/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.api.artemis.mapping;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.FeedbackType;
import java.io.Serializable;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Feedback
implements Comparable<Feedback>,
Serializable {
    private static final long serialVersionUID = 4531964872375020131L;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="credits")
    private Double credits;
    @JsonProperty(value="id")
    private Integer id;
    @JsonProperty(value="positive")
    private Boolean positive;
    @JsonProperty(value="visibility")
    private String visibility;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="reference")
    private String reference;
    @JsonProperty(value="detailText")
    private String detailText;

    public Feedback() {
    }

    public Feedback(String type, Double credits, Integer id, Boolean positive, String visibility, String text, String reference, String detailText) {
        this.type = type;
        this.credits = credits;
        this.id = id;
        this.positive = positive;
        this.visibility = visibility;
        this.text = text;
        this.reference = reference;
        this.detailText = detailText;
    }

    public Double getCredits() {
        if (Objects.equals("NEVER", this.visibility)) {
            return 0.0;
        }
        return this.credits;
    }

    public String getDetailText() {
        return this.detailText;
    }

    public FeedbackType getFeedbackType() {
        return FeedbackType.valueOfIgnoreCase(this.type);
    }

    public Integer getId() {
        return this.id;
    }

    public Boolean getPositive() {
        return this.positive;
    }

    public String getReference() {
        return this.reference;
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return this.type;
    }

    public String getVisibility() {
        return this.visibility;
    }

    @Override
    public int compareTo(Feedback o) {
        boolean similarType;
        boolean bl = similarType = this.getFeedbackType() == o.getFeedbackType() || this.getFeedbackType() != FeedbackType.AUTOMATIC && o.getFeedbackType() != FeedbackType.AUTOMATIC;
        if (!similarType) {
            return this.getFeedbackType() == FeedbackType.AUTOMATIC ? -1 : 1;
        }
        if (this.mandatoryTest() != o.mandatoryTest()) {
            return this.mandatoryTest() ? -1 : 1;
        }
        String thisName = this.getText() == null ? "" : this.getText();
        String otherName = o.getText() == null ? "" : o.getText();
        return thisName.compareToIgnoreCase(otherName);
    }

    private boolean mandatoryTest() {
        return this.text != null && this.text.toLowerCase().contains("mandatory");
    }

    public int hashCode() {
        return Objects.hash(this.credits, this.detailText, this.id, this.positive, this.reference, this.text, this.type, this.visibility);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Feedback other = (Feedback)obj;
        return Objects.equals(this.credits, other.credits) && Objects.equals(this.detailText, other.detailText) && Objects.equals(this.id, other.id) && Objects.equals(this.positive, other.positive) && Objects.equals(this.reference, other.reference) && Objects.equals(this.text, other.text) && Objects.equals(this.type, other.type) && Objects.equals(this.visibility, other.visibility);
    }

    @JsonIgnore
    public boolean isStaticCodeAnalysis() {
        return this.text != null && this.text.startsWith("SCAFeedbackIdentifier");
    }
}

