/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.view.controllers;

import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ICourse;
import edu.kit.kastel.eclipse.common.api.controller.IArtemisController;
import edu.kit.kastel.eclipse.common.api.controller.ISystemwideController;
import edu.kit.kastel.eclipse.common.api.controller.IViewInteraction;
import java.util.List;

public abstract class AbstractArtemisViewController<C extends ISystemwideController> {
    protected final C systemwideController;
    private IArtemisController artemisController;
    protected final IViewInteraction viewObserver;

    protected AbstractArtemisViewController(C systemwideController) {
        this.systemwideController = systemwideController;
        this.viewObserver = systemwideController.getViewInteractionHandler();
    }

    protected void initializeControllersAndObserver() {
        this.artemisController = this.systemwideController.getArtemisController();
    }

    public List<ICourse> getCourses() {
        return this.artemisController.getCourses();
    }

    public List<String> getCourseShortNames() {
        return this.artemisController.getCourseShortNames();
    }

    public List<String> getExamShortNames(String courseTitle) {
        return this.artemisController.getExamTitles(courseTitle);
    }

    public List<String> getExerciseShortNames(String courseName) {
        try {
            return this.systemwideController.setCourseIdAndGetExerciseShortNames(courseName);
        }
        catch (ArtemisClientException e) {
            this.viewObserver.error(e.getMessage(), (Throwable)e);
            return List.of();
        }
    }

    public List<String> getExercisesShortNamesForExam(String examShortName) {
        return this.artemisController.getExerciseShortNamesFromExam(examShortName);
    }

    public void setExerciseId(String exerciseShortName) {
        try {
            this.systemwideController.setExerciseId(exerciseShortName);
        }
        catch (ArtemisClientException e) {
            this.viewObserver.error(e.getMessage(), (Throwable)e);
        }
    }

    protected IArtemisController getArtemisController() {
        return this.artemisController;
    }
}

