/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.view.languages;

import edu.kit.kastel.eclipse.common.view.activator.CommonActivator;
import edu.kit.kastel.eclipse.common.view.languages.EnglishLanguage;
import edu.kit.kastel.eclipse.common.view.languages.GermanLanguage;
import edu.kit.kastel.eclipse.common.view.languages.I18N;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

public final class LanguageSettings {
    private static I18N currentLanguage = new EnglishLanguage();
    private static final List<I18N> availableLanguages = List.of(new EnglishLanguage(), new GermanLanguage());

    private LanguageSettings() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    public static I18N I18N() {
        return currentLanguage;
    }

    public static String[][] getAvailableLocalesForComboField() {
        String[][] ret = new String[availableLanguages.size()][];
        int i = 0;
        while (i < availableLanguages.size()) {
            ret[i] = new String[]{availableLanguages.get(i).languageDisplayName(), availableLanguages.get(i).languageDisplayName()};
            ++i;
        }
        return ret;
    }

    public static void updateI18N() {
        String languageString = CommonActivator.getDefault().getPreferenceStore().getString("preferredLanguageSelector");
        Optional<I18N> optionalLanguage = availableLanguages.stream().filter(lang -> lang.languageDisplayName().equals(languageString)).findFirst();
        if (optionalLanguage.isEmpty()) {
            optionalLanguage = Optional.of(LanguageSettings.getDefaultLanguage());
        }
        currentLanguage = optionalLanguage.orElseThrow(() -> new NoSuchElementException("No default language found!"));
    }

    public static I18N getDefaultLanguage() {
        return availableLanguages.get(0);
    }
}

