/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.view.ui;

import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.Feedback;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.FeedbackType;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.model.IAnnotation;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.api.util.Pair;
import edu.kit.kastel.eclipse.common.core.model.annotation.Annotation;
import edu.kit.kastel.eclipse.common.view.languages.LanguageSettings;
import edu.kit.kastel.eclipse.common.view.ui.AbstractResultTabCompositeController;
import edu.kit.kastel.eclipse.common.view.utilities.AssessmentUtilities;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;

public abstract class AbstractResultTab
extends AbstractResultTabCompositeController {
    protected final ILog log = Platform.getLog(((Object)((Object)this)).getClass());

    protected AbstractResultTab(TabFolder tabFolder, boolean hasReloadFunctionality) {
        super(tabFolder, hasReloadFunctionality);
        this.layout(true);
    }

    protected abstract IExercise getCurrentExercise();

    protected abstract Pair<String, List<Feedback>> getCurrentResultAndFeedback();

    protected abstract String getCurrentProjectNameForAnnotations();

    protected abstract String getCurrentSourceDirectoryRelative();

    @Override
    protected final void reloadFeedbackForExcerise() {
        IExercise currentExercise = this.getCurrentExercise();
        Pair<String, List<Feedback>> resultFeedback = this.getCurrentResultAndFeedback();
        String currentProjectFileForAnnotation = this.getCurrentProjectNameForAnnotations();
        String currentSourceDirectory = this.getCurrentSourceDirectoryRelative();
        if (!resultFeedback.isEmpty()) {
            this.handleNewResult(currentExercise, (String)resultFeedback.first(), (List)resultFeedback.second());
            if (currentProjectFileForAnnotation != null) {
                this.createAnnotationsMarkers(currentProjectFileForAnnotation, currentSourceDirectory, (List)resultFeedback.second());
            }
        } else {
            this.testTable.removeAll();
            this.resetView();
        }
    }

    private void addResultToTab(IExercise currentExercise, String completionTime, List<Feedback> feedbacks) {
        boolean successOfAutomaticTests = this.calculateSuccessOfAutomaticTests(feedbacks);
        double points = this.calculatePoints(currentExercise, feedbacks);
        double score = this.calculateScore(currentExercise, points);
        this.setSuccessAndScore(currentExercise, successOfAutomaticTests, points, score, completionTime);
        this.layout();
    }

    private double calculatePoints(IExercise exercise, List<Feedback> feedbacks) {
        if (exercise == null || feedbacks == null) {
            return Double.NaN;
        }
        double sum = feedbacks.stream().mapToDouble(f -> f.getCredits() == null ? 0.0 : f.getCredits()).sum();
        return Math.max(0.0, sum);
    }

    private double calculateScore(IExercise exercise, double points) {
        if (exercise == null || Double.isNaN(points)) {
            return Double.NaN;
        }
        points = Math.max(0.0, Math.min(exercise.getMaxPoints(), points));
        return points / exercise.getMaxPoints() * 100.0;
    }

    private boolean calculateSuccessOfAutomaticTests(List<Feedback> feedbacks) {
        if (feedbacks == null || feedbacks.isEmpty()) {
            return false;
        }
        return feedbacks.stream().filter(f -> f.getFeedbackType() == FeedbackType.AUTOMATIC).allMatch(f -> Boolean.TRUE.equals(f.getPositive()));
    }

    private void addFeedbackToTable(Table table, List<Feedback> entries) {
        if (entries == null) {
            return;
        }
        entries.stream().sorted().forEach(feedback -> {
            String name = feedback.getFeedbackType() != FeedbackType.AUTOMATIC && feedback.getText() == null ? LanguageSettings.I18N().tabResultsTutorComment() : feedback.getText();
            this.createTableItemsForFeedback(table, name, (Feedback)feedback);
        });
    }

    private void handleNewResult(IExercise currentExercise, String completionTime, List<Feedback> feedbacks) {
        this.testTable.removeAll();
        this.addFeedbackToTable(this.testTable, feedbacks);
        this.addResultToTab(currentExercise, completionTime, feedbacks);
    }

    protected final void createAnnotationsMarkers(String currentProjectName, String sourceDirectory, List<Feedback> feedbacks) {
        List<Feedback> feedbackForLines = feedbacks.stream().filter(f -> f.getFeedbackType() == FeedbackType.MANUAL).toList();
        List<Annotation> annotations = this.convertToAnnotation(feedbackForLines);
        for (Annotation annotation : annotations) {
            IMarker present = AssessmentUtilities.findPresentAnnotation((IAnnotation)annotation, currentProjectName, "src/");
            if (present != null) {
                try {
                    present.delete();
                }
                catch (CoreException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                AssessmentUtilities.createMarkerByAnnotation((IAnnotation)annotation, currentProjectName, sourceDirectory);
            }
            catch (ArtemisClientException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private List<Annotation> convertToAnnotation(List<Feedback> feedbackForLines) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Feedback f : feedbackForLines) {
            int startLine;
            String reference = f.getReference();
            if (reference == null || !reference.startsWith("file:")) continue;
            String[] fileXline = reference.split(".java_line:");
            String id = reference;
            IMistakeType type = null;
            int endLine = startLine = Integer.parseInt(fileXline[1]);
            String fullyClassifiedClassName = fileXline[0].substring("file:src/".length());
            String customMessage = f.getDetailText();
            Double customPenalty = f.getCredits();
            Annotation annotation = new Annotation(id, type, startLine, endLine, fullyClassifiedClassName, customMessage, customPenalty);
            annotations.add(annotation);
        }
        return annotations;
    }
}

