/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.view.utilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class JDTUtilities {
    private static final String STUDENT_CODE_PATH_REGEX = "\\/?[^\\/]+\\/assignment\\/.*";

    private JDTUtilities() {
        throw new IllegalStateException("Utility class");
    }

    public static List<IPackageFragment> getAllStudentPackages(IProject project) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ArrayList<IPackageFragment> packages = new ArrayList<IPackageFragment>();
        IPackageFragment[] iPackageFragmentArray = javaProject.getPackageFragments();
        int n = iPackageFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment packageFragment = iPackageFragmentArray[n2];
            if (JDTUtilities.isStudentPackage(packageFragment)) {
                packages.add(packageFragment);
            }
            ++n2;
        }
        return packages;
    }

    public static Optional<IType> findMainClass(IProject project) throws JavaModelException {
        for (IPackageFragment packageFragment : JDTUtilities.getAllStudentPackages(project)) {
            ICompilationUnit[] iCompilationUnitArray = packageFragment.getCompilationUnits();
            int n = iCompilationUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit compilationUnit = iCompilationUnitArray[n2];
                IType[] iTypeArray = compilationUnit.getAllTypes();
                int n3 = iTypeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType type = iTypeArray[n4];
                    IMethod[] iMethodArray = type.getMethods();
                    int n5 = iMethodArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IMethod method = iMethodArray[n6];
                        if (method.isMainMethod()) {
                            return Optional.of(type);
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return Optional.empty();
    }

    public static List<ICompilationUnit> getAllCompilationUnits(IProject project) throws JavaModelException {
        ArrayList<ICompilationUnit> compilationUnits = new ArrayList<ICompilationUnit>();
        for (IPackageFragment packageFragment : JDTUtilities.getAllStudentPackages(project)) {
            ICompilationUnit[] iCompilationUnitArray = packageFragment.getCompilationUnits();
            int n = iCompilationUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit compilationUnit = iCompilationUnitArray[n2];
                compilationUnits.add(compilationUnit);
                ++n2;
            }
        }
        return compilationUnits;
    }

    private static boolean isStudentPackage(IPackageFragment packageFragment) throws JavaModelException {
        return packageFragment.getKind() == 1 && packageFragment.getPath().toString().matches(STUDENT_CODE_PATH_REGEX);
    }
}

