/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core;

import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.EclipseArtemisConstants;
import edu.kit.kastel.eclipse.common.api.artemis.ILockResult;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.Feedback;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ICourse;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExam;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExerciseGroup;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ISubmission;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.User;
import edu.kit.kastel.eclipse.common.api.client.IAuthenticationArtemisClient;
import edu.kit.kastel.eclipse.common.api.controller.AbstractController;
import edu.kit.kastel.eclipse.common.api.controller.IArtemisController;
import edu.kit.kastel.eclipse.common.api.controller.IViewInteraction;
import edu.kit.kastel.eclipse.common.api.util.Version;
import edu.kit.kastel.eclipse.common.client.rest.RestClientManager;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ArtemisController
extends AbstractController
implements IArtemisController {
    protected final Map<Integer, ILockResult> lockResults;
    protected final RestClientManager clientManager;
    protected List<ICourse> courses;

    protected ArtemisController(String host, String username, String password, IViewInteraction handler) {
        super(handler);
        this.clientManager = new RestClientManager(host, username, password);
        this.lockResults = new HashMap<Integer, ILockResult>();
        if (host != null && !host.isBlank()) {
            this.checkVersion();
            this.loginOrNotify();
        }
    }

    protected abstract List<ICourse> fetchCourses();

    public User getUserLogin() {
        IAuthenticationArtemisClient login = this.clientManager.getAuthenticationClient();
        if (login == null) {
            return null;
        }
        return login.getUser();
    }

    public final List<ICourse> getCourses() {
        if (this.courses == null) {
            this.courses = this.fetchCourses();
        }
        return this.courses;
    }

    public List<Feedback> getAllFeedbacksGottenFromLocking(ISubmission submission) {
        ILockResult lockResult = this.lockResults.get(submission.getSubmissionId());
        if (lockResult == null) {
            this.error("No Lock found for submission=" + submission.getSubmissionId(), null);
            return List.of();
        }
        return lockResult.getLatestFeedback();
    }

    public List<ISubmission> getBegunSubmissions(IExercise exercise) {
        try {
            return this.clientManager.getSubmissionArtemisClient().getSubmissions(exercise);
        }
        catch (ArtemisClientException e) {
            this.error(e.getMessage(), e);
            return List.of();
        }
    }

    protected ICourse getCourseByShortName(String courseShortName) {
        List<ICourse> filteredCourses = this.getCourses().stream().filter(course -> course.getShortName().equals(courseShortName)).toList();
        if (filteredCourses.isEmpty()) {
            this.error("No course found for courseShortName=" + courseShortName, null);
            return null;
        }
        if (filteredCourses.size() > 1) {
            this.error("Multiple courses found for courseShortName=" + courseShortName, null);
            return null;
        }
        return filteredCourses.iterator().next();
    }

    public List<String> getCourseShortNames() {
        return this.getCourses().stream().map(ICourse::getShortName).toList();
    }

    public List<String> getExamTitles(String courseShortName) {
        try {
            ICourse course = this.getCourseByShortName(courseShortName);
            if (course == null) {
                return List.of();
            }
            return course.getExams().stream().map(IExam::getTitle).toList();
        }
        catch (Exception e) {
            this.error(e.getMessage(), e);
            return List.of();
        }
    }

    public List<IExercise> getExercises(ICourse course, boolean withExamExercises) {
        if (course == null) {
            return List.of();
        }
        try {
            ArrayList<IExercise> allExercises = new ArrayList<IExercise>(course.getExercises());
            if (withExamExercises) {
                for (IExam e : course.getExams()) {
                    for (IExerciseGroup g : e.getExerciseGroups()) {
                        allExercises.addAll(g.getExercises());
                    }
                }
            }
            return allExercises;
        }
        catch (Exception e) {
            this.error(e.getMessage(), e);
            return List.of();
        }
    }

    public LocalDateTime getCurrentDate() {
        try {
            return this.clientManager.getUtilArtemisClient().getTime();
        }
        catch (ArtemisClientException artemisClientException) {
            return LocalDateTime.now();
        }
    }

    public List<IExercise> getExercisesFromExam(String examTitle) {
        return this.getExercisesFromExam(examTitle, this.getCourses());
    }

    private List<IExercise> getExercisesFromExam(String examTitle, List<ICourse> courses) {
        IExam foundExam = null;
        for (ICourse course : courses) {
            IExam exam2;
            List<IExam> filteredExams;
            try {
                filteredExams = course.getExams().stream().filter(exam -> exam.getTitle().equals(examTitle)).toList();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
                continue;
            }
            if (filteredExams.size() != 1 || !(exam2 = filteredExams.iterator().next()).getTitle().equals(examTitle)) continue;
            foundExam = exam2;
        }
        if (foundExam == null) {
            this.error("No exam found for examTitle=" + examTitle, null);
            return List.of();
        }
        try {
            return foundExam.getExerciseGroups().stream().map(IExerciseGroup::getExercises).flatMap(Collection::stream).toList();
        }
        catch (Exception e) {
            this.error(e.getMessage(), e);
            return List.of();
        }
    }

    protected Map.Entry<ICourse, IExam> filterGetExamObjectFromLoadedCourses(String examTitle, List<ICourse> courses) {
        for (ICourse course : courses) {
            IExam exam2;
            List<IExam> filteredExams;
            try {
                filteredExams = course.getExams().stream().filter(exam -> exam.getTitle().equals(examTitle)).toList();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
                continue;
            }
            if (filteredExams.size() != 1 || !(exam2 = filteredExams.iterator().next()).getTitle().equals(examTitle)) continue;
            return Map.entry(course, exam2);
        }
        return null;
    }

    private void loginOrNotify() {
        try {
            this.clientManager.login();
        }
        catch (ArtemisClientException e) {
            this.error(e.getMessage(), e);
        }
    }

    private void checkVersion() {
        try {
            Version currentVersion = this.clientManager.getUtilArtemisClient().getVersion();
            if (currentVersion.compareTo(EclipseArtemisConstants.MINIMUM_ARTEMIS_VERSION_INCLUSIVE) == -1) {
                String response = "This version of Eclipse Artemis has Artemis %s as minimum requirement.\nYour Artemis instance runs %s\nProceed on your own responsibility.\n";
                this.warn(response.formatted(EclipseArtemisConstants.MINIMUM_ARTEMIS_VERSION_INCLUSIVE, currentVersion));
            } else if (currentVersion.compareTo(EclipseArtemisConstants.MAXIMUM_ARTEMIS_VERSION_EXCLUSIVE) != -1) {
                String response = "This version of Eclipse Artemis has Artemis %s as maximum (exclusive) requirement.\nYour Artemis instance runs %s\nProceed on your own responsibility.\n";
                this.warn(response.formatted(EclipseArtemisConstants.MAXIMUM_ARTEMIS_VERSION_EXCLUSIVE, currentVersion));
            }
        }
        catch (ArtemisClientException e) {
            this.error(e.getMessage(), e);
        }
    }
}

