/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core;

import edu.kit.kastel.eclipse.common.api.artemis.IProjectFileNamingStrategy;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ICourse;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ISubmission;
import edu.kit.kastel.eclipse.common.api.controller.AbstractController;
import edu.kit.kastel.eclipse.common.api.controller.IAssessmentController;
import edu.kit.kastel.eclipse.common.api.model.IAnnotation;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.api.model.IRatingGroup;
import edu.kit.kastel.eclipse.common.core.GradingSystemwideController;
import edu.kit.kastel.eclipse.common.core.artemis.AnnotationDeserializer;
import edu.kit.kastel.eclipse.common.core.artemis.AnnotationMapper;
import edu.kit.kastel.eclipse.common.core.artemis.WorkspaceUtil;
import edu.kit.kastel.eclipse.common.core.config.ExerciseConfig;
import edu.kit.kastel.eclipse.common.core.config.ExerciseConfigConverterException;
import edu.kit.kastel.eclipse.common.core.config.GradingDAO;
import edu.kit.kastel.eclipse.common.core.config.JsonFileConfigDAO;
import edu.kit.kastel.eclipse.common.core.model.annotation.AnnotationDAO;
import edu.kit.kastel.eclipse.common.core.model.annotation.AnnotationException;
import edu.kit.kastel.eclipse.common.core.model.annotation.IAnnotationDAO;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class AssessmentController
extends AbstractController
implements IAssessmentController {
    private final GradingSystemwideController systemWideController;
    private final ICourse course;
    private final IExercise exercise;
    private final ISubmission submission;
    private GradingDAO gradingDAO;
    private IAnnotationDAO annotationDAO;

    protected AssessmentController(GradingSystemwideController systemWideController, ICourse course, IExercise exercise, ISubmission submission) {
        super(systemWideController.getViewInteractionHandler());
        this.systemWideController = systemWideController;
        this.course = course;
        this.exercise = exercise;
        this.submission = submission;
        this.annotationDAO = new AnnotationDAO();
        this.gradingDAO = this.loadGradingDAO();
        try {
            ExerciseConfig exerciseConfig = this.gradingDAO.getExerciseConfig(this.exercise);
            if (!exerciseConfig.getAllowedExercises().isEmpty() && !exerciseConfig.getAllowedExercises().contains(this.exercise.getExerciseId())) {
                systemWideController.getViewInteractionHandler().warn("You are using a configuration file not designed for this exercise!\n\nYour file is \"%s\", however you are correcting exercise \"%s\"!\n\nPlease double check your settings!\n".formatted(exerciseConfig.getShortName(), this.exercise.getShortName()));
            }
        }
        catch (ExerciseConfigConverterException | IOException e) {
            this.error("Exercise Config not parseable: " + e.getMessage(), e);
        }
        try {
            this.initializeWithDeserializedAnnotations();
        }
        catch (IOException iOException) {
            this.warn("Deserializing Annotations from Artemis failed (most likely none were present)!");
        }
    }

    private GradingDAO loadGradingDAO() {
        return new JsonFileConfigDAO(new File(this.systemWideController.getPreferences().getString("absoluteConfigPath")));
    }

    public void addAnnotation(String annotationId, IMistakeType mistakeType, int startLine, int endLine, String fullyClassifiedClassName, String customMessage, Double customPenalty) {
        try {
            this.annotationDAO.addAnnotation(annotationId, mistakeType, startLine, endLine, fullyClassifiedClassName, customMessage, customPenalty);
        }
        catch (AnnotationException e) {
            this.error(e.getMessage(), e);
        }
    }

    public void deleteEclipseProject(IProjectFileNamingStrategy projectNaming) {
        String projectName = projectNaming.getProjectFileInWorkspace(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), this.exercise, this.submission).getName();
        try {
            WorkspaceUtil.deleteEclipseProject(projectName);
        }
        catch (IOException | CoreException e) {
            this.error("Eclipse Exception occurred while trying to delete project: " + e.getMessage(), e);
        }
    }

    public List<IAnnotation> getAnnotations() {
        return this.annotationDAO.getAnnotations().stream().toList();
    }

    public Optional<IAnnotation> getAnnotationById(String id) {
        return this.annotationDAO.getAnnotations().stream().filter(annotation -> annotation.getUUID().equals(id)).findFirst();
    }

    public IExercise getExercise() {
        return this.exercise;
    }

    public ISubmission getSubmission() {
        return this.submission;
    }

    public List<IMistakeType> getMistakes() {
        try {
            return this.gradingDAO.getExerciseConfig(this.exercise).getIMistakeTypes();
        }
        catch (ExerciseConfigConverterException | IOException e) {
            this.error("Exercise Config not parseable: " + e.getMessage(), e);
            return List.of();
        }
    }

    public boolean isPositiveFeedbackAllowed() {
        try {
            return this.gradingDAO.getExerciseConfig(this.exercise).isPositiveFeedbackAllowed();
        }
        catch (ExerciseConfigConverterException | IOException e) {
            this.error("Exercise Config not parseable: " + e.getMessage(), e);
            return true;
        }
    }

    public IRatingGroup getRatingGroupById(String id) {
        Optional<IRatingGroup> ratingGroupOptional = this.getRatingGroups().stream().filter(ratingGroup -> ratingGroup.getIdentifier().equals(id)).findFirst();
        if (ratingGroupOptional.isPresent()) {
            return ratingGroupOptional.get();
        }
        this.error("Rating Group \"" + id + "\" not found in config!", null);
        return null;
    }

    public List<IRatingGroup> getRatingGroups() {
        try {
            return this.gradingDAO.getExerciseConfig(this.exercise).getIRatingGroups();
        }
        catch (ExerciseConfigConverterException | IOException e) {
            this.error("Exercise Config not parseable: " + e.getMessage(), e);
            return List.of();
        }
    }

    public String getTooltipForMistakeType(String languageKey, IMistakeType mistakeType) {
        List<IAnnotation> annotations = this.getAnnotations().stream().filter(annotation -> annotation.getMistakeType().equals(mistakeType)).toList();
        return mistakeType.getTooltip(languageKey, annotations);
    }

    private void initializeWithDeserializedAnnotations() throws IOException {
        AnnotationDeserializer annotationDeserializer = new AnnotationDeserializer(this.getMistakes());
        List allFeedbacksGottenFromLocking = this.systemWideController.getArtemisController().getAllFeedbacksGottenFromLocking(this.submission);
        if (allFeedbacksGottenFromLocking == null) {
            throw new IOException("No feedbacks gotten from locking could be acquired.");
        }
        for (IAnnotation annotation : annotationDeserializer.deserialize(allFeedbacksGottenFromLocking)) {
            this.addAnnotation(annotation.getUUID(), annotation.getMistakeType(), annotation.getStartLine(), annotation.getEndLine(), annotation.getClassFilePath(), annotation.getCustomMessage().orElse(null), annotation.getCustomPenalty().orElse(null));
        }
    }

    public void modifyAnnotation(String annatationId, String customMessage, Double customPenalty) {
        this.annotationDAO.modifyAnnotation(annatationId, customMessage, customPenalty);
    }

    public void removeAnnotation(String annotationId) {
        this.annotationDAO.removeAnnotation(annotationId);
    }

    public void resetAndRestartAssessment(IProjectFileNamingStrategy projectNaming) {
        this.deleteEclipseProject(projectNaming);
        this.systemWideController.getArtemisController().startAssessment(this.submission);
        this.systemWideController.downloadExerciseAndSubmission(this.course, this.exercise, this.submission, projectNaming);
        this.annotationDAO = new AnnotationDAO();
        this.gradingDAO = this.loadGradingDAO();
        try {
            this.initializeWithDeserializedAnnotations();
        }
        catch (IOException e) {
            this.info("Deserializing Annotations from Artemis failed: " + e.getMessage());
        }
    }

    public double getCurrentPenaltyForRatingGroup(IRatingGroup ratingGroup) {
        AnnotationMapper mapper = new AnnotationMapper(this.exercise, this.submission, this.getAnnotations(), this.getRatingGroups(), null, null);
        return mapper.calculatePointsForRatingGroup(ratingGroup).points();
    }
}

