/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core.artemis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.kit.kastel.eclipse.common.api.artemis.AssessmentResult;
import edu.kit.kastel.eclipse.common.api.artemis.ILockResult;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.Feedback;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.FeedbackType;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ISubmission;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.User;
import edu.kit.kastel.eclipse.common.api.model.IAnnotation;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.api.model.IRatingGroup;
import edu.kit.kastel.eclipse.common.api.util.Pair;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;

public class AnnotationMapper {
    private static final int FEEDBACK_DETAIL_TEXT_MAX_CHARACTERS = 5000;
    private static final int FEEDBACK_DETAIL_SAFETY_MARGIN = 50;
    private static final NumberFormat nf = new DecimalFormat("##.###", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static final ILog log = Platform.getLog(AnnotationMapper.class);
    private final ObjectMapper oom = new ObjectMapper();
    private final IExercise exercise;
    private final ISubmission submission;
    private final List<IAnnotation> annotations;
    private final List<IRatingGroup> ratingGroups;
    private final User assessor;
    private final ILockResult lock;

    public AnnotationMapper(IExercise exercise, ISubmission submission, List<IAnnotation> annotations, List<IRatingGroup> ratingGroups, User assessor, ILockResult lock) {
        this.exercise = exercise;
        this.submission = submission;
        this.annotations = annotations;
        this.ratingGroups = ratingGroups;
        this.assessor = assessor;
        this.lock = lock;
    }

    private double calculateAbsoluteScore(List<Feedback> allFeedbacks) {
        return allFeedbacks.stream().mapToDouble(Feedback::getCredits).sum();
    }

    private List<Feedback> calculateAllFeedbacks() throws IOException {
        ArrayList<Feedback> result = new ArrayList<Feedback>(this.getFilteredPreexistentFeedbacks(FeedbackType.AUTOMATIC));
        result.addAll(this.calculateManualFeedbacks());
        result.addAll(this.calculateAnnotationSerialitationAsFeedbacks());
        result.removeIf(Objects::isNull);
        return result;
    }

    private List<Feedback> calculateAnnotationSerialisationAsFeedbacks(List<IAnnotation> givenAnnotations, int detailTextMaxCharacters) throws IOException {
        String givenAnnotationsJSONString = this.convertAnnotationsToJSONString(givenAnnotations);
        if (givenAnnotationsJSONString.length() < detailTextMaxCharacters) {
            return List.of(new Feedback(FeedbackType.MANUAL_UNREFERENCED.name(), Double.valueOf(0.0), null, null, "NEVER", "CLIENT_DATA", null, givenAnnotationsJSONString));
        }
        if (givenAnnotations.size() == 1) {
            throw new IOException("This annotation is too large to serialize! " + givenAnnotationsJSONString);
        }
        int givenAnnotationsSize = givenAnnotations.size();
        ArrayList<Feedback> resultFeedbacks = new ArrayList<Feedback>(this.calculateAnnotationSerialisationAsFeedbacks(givenAnnotations.subList(0, givenAnnotationsSize / 2), detailTextMaxCharacters));
        resultFeedbacks.addAll(this.calculateAnnotationSerialisationAsFeedbacks(givenAnnotations.subList(givenAnnotationsSize / 2, givenAnnotations.size()), detailTextMaxCharacters));
        return resultFeedbacks;
    }

    private List<Feedback> calculateAnnotationSerialitationAsFeedbacks() throws IOException {
        return this.calculateAnnotationSerialisationAsFeedbacks(new ArrayList<IAnnotation>(this.annotations), 5000);
    }

    private List<Feedback> calculateManualFeedbacks() {
        ArrayList<Feedback> manualFeedbacks = new ArrayList<Feedback>(this.annotations.stream().collect(Collectors.groupingBy(IAnnotation::getStartLine)).entrySet().stream().map(this::createInlineFeedbackWithNoDeduction).toList());
        this.ratingGroups.forEach(group -> {
            boolean bl = manualFeedbacks.addAll(this.createGlobalFeedbackWithDeduction((IRatingGroup)group));
        });
        return manualFeedbacks;
    }

    private double calculateRelativeScore(double absoluteScore) {
        return absoluteScore / this.exercise.getMaxPoints() * 100.0;
    }

    private String convertAnnotationsToJSONString(List<IAnnotation> givenAnnotations) throws JsonProcessingException {
        return this.oom.writeValueAsString(givenAnnotations);
    }

    public AssessmentResult createAssessmentResult() throws IOException {
        List<Feedback> allFeedbacks = this.calculateAllFeedbacks();
        double absoluteScore = Math.min(Math.max(0.0, this.calculateAbsoluteScore(allFeedbacks)), this.exercise.getMaxPoints());
        double relativeScore = this.calculateRelativeScore(absoluteScore);
        List<Feedback> initialFeedback = this.getFilteredPreexistentFeedbacks(FeedbackType.AUTOMATIC);
        List tests = initialFeedback.stream().filter(f -> f.getReference() == null).collect(Collectors.toList());
        int codeIssueCount = (int)initialFeedback.stream().filter(Feedback::isStaticCodeAnalysis).count();
        int passedTestCaseCount = (int)tests.stream().filter(feedback -> feedback.getPositive() != null && feedback.getPositive() != false).count();
        return new AssessmentResult(this.submission.getSubmissionId(), "SEMI_AUTOMATIC", relativeScore, true, true, this.assessor, allFeedbacks, codeIssueCount, passedTestCaseCount, tests.size());
    }

    private Feedback createInlineFeedbackWithNoDeduction(Map.Entry<Integer, List<IAnnotation>> annotations) {
        int line = annotations.getKey();
        IAnnotation sampleAnnotation = annotations.getValue().get(0);
        String text = "File " + sampleAnnotation.getClassFilePath() + " at line " + (line + 1);
        String reference = "file:" + sampleAnnotation.getClassFilePath() + ".java_line:" + line;
        String resultText = "";
        for (IAnnotation annotation : annotations.getValue()) {
            IMistakeType mistakeType = annotation.getMistakeType();
            String detailText = "[" + mistakeType.getRatingGroup().getDisplayName(null) + ":" + mistakeType.getButtonText(null) + "] ";
            if (mistakeType.isCustomPenalty()) {
                detailText = String.valueOf(detailText) + (String)annotation.getCustomMessage().get() + " (" + nf.format(annotation.getCustomPenalty().get()) + "P)";
            } else {
                detailText = String.valueOf(detailText) + mistakeType.getMessage(null);
                if (annotation.getCustomMessage().isPresent()) {
                    detailText = String.valueOf(detailText) + "\nExplanation: " + (String)annotation.getCustomMessage().get();
                }
            }
            resultText = String.valueOf(resultText) + detailText + "\n\n";
        }
        return new Feedback(FeedbackType.MANUAL.name(), Double.valueOf(0.0), null, null, null, text, reference, resultText.trim());
    }

    private List<Feedback> createGlobalFeedbackWithDeduction(IRatingGroup ratingGroup) {
        PointResult pointResult = this.calculatePointsForRatingGroup(ratingGroup);
        Pair range = ratingGroup.getRange();
        ArrayList<String> lines = new ArrayList<String>();
        String annotationHeadline = "";
        annotationHeadline = String.valueOf(ratingGroup.getDisplayName(null)) + " [" + nf.format(pointResult.points);
        if (!range.isEmpty()) {
            double lower = range.first() == null ? Double.NEGATIVE_INFINITY : (Double)range.first();
            double upper = range.second() == null ? Double.POSITIVE_INFINITY : (Double)range.second();
            annotationHeadline = String.valueOf(annotationHeadline) + " (Range: " + nf.format(lower) + " -- " + nf.format(upper) + ")";
        }
        annotationHeadline = String.valueOf(annotationHeadline) + " points]";
        for (Map.Entry<IMistakeType, Double> mistakeTypeXScore : pointResult.scores.entrySet()) {
            IMistakeType mistakeType = mistakeTypeXScore.getKey();
            double currentPenalty = mistakeTypeXScore.getValue();
            List<IAnnotation> currentAnnotations = this.annotations.stream().filter(annotation -> annotation.getMistakeType().equals(mistakeType)).toList();
            lines.add("\n    * \"" + mistakeType.getButtonText(null) + "\" [" + nf.format(currentPenalty) + "P]:");
            if (mistakeType.isCustomPenalty()) {
                for (IAnnotation annotation2 : currentAnnotations) {
                    String penalty = nf.format(annotation2.getCustomPenalty().get());
                    lines.add("\n        * " + annotation2.getClassFilePath() + " at line " + (annotation2.getStartLine() + 1) + " (" + penalty + "P)");
                }
                continue;
            }
            for (IAnnotation annotation2 : currentAnnotations) {
                lines.add("\n        * " + annotation2.getClassFilePath() + " at line " + (annotation2.getStartLine() + 1));
            }
        }
        if (pointResult.reachedLimit) {
            lines.add("\n    * Note: The sum of penalties hit the limits for this rating group.");
        }
        LinkedList<String> feedbackTexts = new LinkedList<String>();
        if (lines.isEmpty()) {
            return List.of();
        }
        String text = String.valueOf(annotationHeadline) + " (annotation " + 1 + ")";
        int i = 0;
        while (i < lines.size()) {
            if (text.length() + ((String)lines.get(i)).length() >= 5000 - annotationHeadline.length() - 50) {
                feedbackTexts.add(text);
                text = String.valueOf(annotationHeadline) + " (annotation " + (feedbackTexts.size() + 1) + ")";
            }
            text = String.valueOf(text) + (String)lines.get(i);
            ++i;
        }
        feedbackTexts.add(text);
        LinkedList<Feedback> feedbacks = new LinkedList<Feedback>();
        feedbacks.add(new Feedback(FeedbackType.MANUAL_UNREFERENCED.name(), Double.valueOf(pointResult.points), null, null, null, null, null, (String)feedbackTexts.get(0)));
        int i2 = 1;
        while (i2 < feedbackTexts.size()) {
            feedbacks.add(new Feedback(FeedbackType.MANUAL_UNREFERENCED.name(), Double.valueOf(0.0), null, null, null, null, null, (String)feedbackTexts.get(i2)));
            ++i2;
        }
        return feedbacks;
    }

    private List<Feedback> getFilteredPreexistentFeedbacks(FeedbackType feedbackType) {
        ArrayList<Feedback> feedbacks = new ArrayList<Feedback>();
        for (Feedback feedback : this.lock.getLatestFeedback()) {
            if (feedback.getFeedbackType() == null || feedback.getFeedbackType() != feedbackType) continue;
            feedbacks.add(feedback);
        }
        return feedbacks;
    }

    public PointResult calculatePointsForRatingGroup(IRatingGroup ratingGroup) {
        boolean reachedLimit;
        log.info("Calculate Points for RG " + ratingGroup.getDisplayName(null));
        double sum = 0.0;
        HashMap<IMistakeType, Double> scores = new HashMap<IMistakeType, Double>();
        for (IMistakeType mistakeType : ratingGroup.getMistakeTypes()) {
            Double score = this.calculatePointsForMistakeType(mistakeType);
            if (score == null) continue;
            scores.put(mistakeType, score);
            sum += score.doubleValue();
        }
        boolean bl = reachedLimit = !ratingGroup.getRange().isEmpty() && ratingGroup.setToRange(sum) != sum;
        if (reachedLimit) {
            log.info("RG " + ratingGroup.getDisplayName(null) + " reached limit");
            sum = ratingGroup.setToRange(sum);
        }
        return new PointResult(sum, reachedLimit, scores);
    }

    private Double calculatePointsForMistakeType(IMistakeType mistakeType) {
        log.info("Calculate Points for MT " + mistakeType.getButtonText(null));
        List<IAnnotation> filteredAnnotations = this.annotations.stream().filter(a -> a.getMistakeType().equals(mistakeType)).toList();
        if (filteredAnnotations.isEmpty()) {
            return null;
        }
        double points = mistakeType.calculate(filteredAnnotations);
        log.info("MT " + mistakeType.getButtonText(null) + " -> " + points);
        return points;
    }

    public record PointResult(double points, boolean reachedLimit, Map<IMistakeType, Double> scores) {
    }
}

