/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core.artemis;

import edu.kit.kastel.eclipse.common.api.controller.ISubmissionLifecycleCallback;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;

public class WorkspaceUtil {
    private static final ILog LOG = Platform.getLog(WorkspaceUtil.class);

    public static final void createEclipseProject(File projectDirectory, List<ISubmissionLifecycleCallback> buildCallbacks) throws CoreException {
        WorkspaceUtil.createEclipseProject(projectDirectory.getName(), buildCallbacks);
    }

    public static final void createEclipseProject(String projectName, final List<ISubmissionLifecycleCallback> buildCallbacks) throws CoreException {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        String[] natures = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.m2e.core.maven2Nature"};
        description.setNatureIds(natures);
        description.setBuildSpec(new ICommand[]{WorkspaceUtil.createBuildCommand("org.eclipse.jdt.core.javabuilder"), WorkspaceUtil.createBuildCommand("org.eclipse.m2e.core.maven2Builder")});
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        project.create(null);
        project.open(null);
        project.setDescription(description, null);
        UpdateMavenProjectJob job = new UpdateMavenProjectJob(List.of(project));
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent e) {
                LOG.info("Maven update & build completed. Notifying " + buildCallbacks.size() + " listeners");
                buildCallbacks.forEach(c -> c.onPhaseCompleted(project));
            }
        });
        job.schedule();
    }

    private static ICommand createBuildCommand(String name) {
        BuildCommand command = new BuildCommand();
        command.setBuilderName(name);
        return command;
    }

    public static final void deleteDirectoryRecursively(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static final void deleteEclipseProject(String projectName) throws CoreException, IOException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.exists()) {
            return;
        }
        File projectLocation = project.getLocation().toFile();
        project.delete(true, null);
        if (projectLocation.exists()) {
            WorkspaceUtil.deleteDirectoryRecursively(projectLocation.toPath());
        }
    }

    public static final File getWorkspaceFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
    }

    private WorkspaceUtil() {
    }
}

