/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.api.model.IRatingGroup;
import edu.kit.kastel.eclipse.common.core.config.ExerciseConfigConverter;
import edu.kit.kastel.eclipse.common.core.model.MistakeType;
import edu.kit.kastel.eclipse.common.core.model.RatingGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonDeserialize(converter=ExerciseConfigConverter.class)
public class ExerciseConfig {
    @JsonProperty(value="shortName")
    private String shortName;
    @JsonProperty(value="allowedExercises")
    private List<Integer> allowedExercises;
    @JsonProperty(value="ratingGroups")
    private List<RatingGroup> ratingGroups;
    @JsonProperty(value="mistakeTypes")
    private List<MistakeType> mistakeTypes;
    @JsonProperty(value="positiveFeedbackAllowed")
    private Boolean isPositiveFeedbackAllowed;

    public List<Integer> getAllowedExercises() {
        return Collections.unmodifiableList(this.allowedExercises == null ? List.of() : this.allowedExercises);
    }

    public List<IMistakeType> getIMistakeTypes() {
        return new ArrayList<IMistakeType>(this.mistakeTypes);
    }

    public List<IRatingGroup> getIRatingGroups() {
        return new ArrayList<IRatingGroup>(this.ratingGroups);
    }

    public List<MistakeType> getMistakeTypes() {
        return this.mistakeTypes;
    }

    public List<RatingGroup> getRatingGroups() {
        return this.ratingGroups;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void initialize(IExercise exercise) {
        this.mistakeTypes.forEach(e -> e.initialize(exercise));
    }

    public boolean isPositiveFeedbackAllowed() {
        return this.isPositiveFeedbackAllowed == null ? true : this.isPositiveFeedbackAllowed;
    }
}

