/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import edu.kit.kastel.eclipse.common.core.model.rule.CustomPenaltyRule;
import edu.kit.kastel.eclipse.common.core.model.rule.PenaltyRule;
import edu.kit.kastel.eclipse.common.core.model.rule.StackingPenaltyRule;
import edu.kit.kastel.eclipse.common.core.model.rule.ThresholdPenaltyRule;
import java.io.IOException;
import java.util.function.Function;

public class PenaltyRuleDeserializer
extends StdDeserializer<PenaltyRule> {
    private static final long serialVersionUID = 6326274512036616184L;

    protected PenaltyRuleDeserializer() {
        super(PenaltyRule.class);
    }

    public PenaltyRule deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode penaltyRuleNode = (JsonNode)parser.getCodec().readTree(parser);
        String penaltyRuleShortName = penaltyRuleNode.get("shortName").asText();
        PenaltyRuleType penaltyRuleType = PenaltyRuleType.fromShortName(penaltyRuleShortName);
        if (penaltyRuleType != null) {
            return penaltyRuleType.construct(penaltyRuleNode);
        }
        throw new IOException("No PenaltyRule Subclass defined for penaltyRule " + penaltyRuleShortName);
    }

    public static enum PenaltyRuleType {
        THRESHOLD_PENALTY_RULE_TYPE("thresholdPenalty", ThresholdPenaltyRule::new),
        STACKING_PENATLY_RULE_TYPE("stackingPenalty", StackingPenaltyRule::new),
        CUSTOM_PENALTY_RULE_TYPE("customPenalty", CustomPenaltyRule::new);

        private final Function<JsonNode, PenaltyRule> constructor;
        private final String shortName;

        public static PenaltyRuleType fromShortName(String shortName) {
            PenaltyRuleType[] penaltyRuleTypeArray = PenaltyRuleType.values();
            int n = penaltyRuleTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PenaltyRuleType penaltyRuleType = penaltyRuleTypeArray[n2];
                if (penaltyRuleType.getShortName().equalsIgnoreCase(shortName)) {
                    return penaltyRuleType;
                }
                ++n2;
            }
            return null;
        }

        private PenaltyRuleType(String shortName, Function<JsonNode, PenaltyRule> constructor) {
            this.shortName = shortName;
            this.constructor = constructor;
        }

        public PenaltyRule construct(JsonNode penaltyRuleNode) {
            return this.constructor.apply(penaltyRuleNode);
        }

        public String getShortName() {
            return this.shortName;
        }
    }
}

