/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.core.model.rule;

import com.fasterxml.jackson.databind.JsonNode;
import edu.kit.kastel.eclipse.common.api.model.IAnnotation;
import edu.kit.kastel.eclipse.common.core.model.rule.PenaltyRule;
import java.util.List;
import java.util.Objects;

public class ThresholdPenaltyRule
extends PenaltyRule {
    private static final String DISPLAY_NAME = "Threshold Penalty";
    public static final String SHORT_NAME = "thresholdPenalty";
    private int threshold;
    private double penalty;

    public ThresholdPenaltyRule(JsonNode penaltyRuleNode) {
        this.threshold = penaltyRuleNode.get("threshold").asInt();
        this.penalty = penaltyRuleNode.get("penalty").asDouble();
    }

    public ThresholdPenaltyRule(int threshold, double penalty) {
        this.threshold = threshold;
        this.penalty = penalty;
    }

    @Override
    public double calculate(List<IAnnotation> annotations) {
        return annotations.size() >= this.threshold ? -this.penalty : 0.0;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getTooltip(List<IAnnotation> annotations) {
        if (this.penalty == 0.0) {
            return String.valueOf(annotations.size()) + " annotations. No deduction will be made.";
        }
        double penaltyValue = this.calculate(annotations);
        return String.valueOf(penaltyValue) + " points [" + annotations.size() + " of at least " + this.threshold + " annotations made]";
    }

    public String toString() {
        return "ThresholdPenaltyRule [threshold=" + this.threshold + ", penalty=" + this.penalty + "]";
    }

    @Override
    public boolean isCustomPenalty() {
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.penalty, this.threshold);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThresholdPenaltyRule other = (ThresholdPenaltyRule)obj;
        return Double.doubleToLongBits(this.penalty) == Double.doubleToLongBits(other.penalty) && this.threshold == other.threshold;
    }
}

