/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.client.git;

import edu.kit.kastel.eclipse.common.client.git.GitCredentials;
import edu.kit.kastel.eclipse.common.client.git.GitException;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FileUtils;

public final class GitHandler {
    private static final String REMOTE_NAME = "origin";

    public static void cloneRepo(File destination, String repoURL, GitCredentials credentials) throws GitException {
        try (Repository repository = null;){
            try {
                CloneCommand cloneRepository = Git.cloneRepository();
                cloneRepository.setDirectory(destination);
                cloneRepository.setRemote(REMOTE_NAME);
                cloneRepository.setURI(String.valueOf(new URIish(repoURL)));
                cloneRepository.setCloneAllBranches(true);
                cloneRepository.setCloneSubmodules(false);
                GitHandler.makeAuth(cloneRepository, credentials);
                Git git = cloneRepository.call();
                repository = git.getRepository();
            }
            catch (Exception e) {
                try {
                    FileUtils.delete((File)destination, (int)1);
                }
                catch (IOException iOException) {}
                throw new GitException("Git clone failed with exception: " + e.getMessage(), e);
            }
        }
    }

    public static void commitExercise(String authorName, String email, String commitMsg, File exerciseRepo) throws GitException {
        try (Git git = GitHandler.openGit(exerciseRepo);){
            try {
                git.add().addFilepattern(".").call();
                git.add().setUpdate(true).addFilepattern(".").call();
                git.rm().addFilepattern(".").call();
                git.commit().setCommitter(authorName, email).setMessage(commitMsg).setSign(Boolean.valueOf(false)).call();
            }
            catch (GitAPIException e) {
                throw new GitException("Git commit failed for path: " + exerciseRepo.getPath(), e);
            }
        }
    }

    public static void pushExercise(File exerciseRepo, GitCredentials credentials) throws GitException {
        Git git = GitHandler.openGit(exerciseRepo);
        PushCommand pushCommand = git.push();
        GitHandler.makeAuth(pushCommand, credentials);
        try {
            try {
                pushCommand.call().iterator().next();
            }
            catch (GitAPIException e) {
                throw new GitException("Git push failed for path: " + exerciseRepo.getPath(), e);
            }
        }
        finally {
            git.close();
        }
    }

    public static void pullExercise(File exerciseRepo, GitCredentials credentials) throws GitException {
        Git git = GitHandler.openGit(exerciseRepo);
        PullCommand pullCommand = git.pull();
        GitHandler.makeAuth(pullCommand, credentials);
        try {
            try {
                PullResult result = pullCommand.call();
                if (!result.isSuccessful()) {
                    throw new GitException("Git push failed for path: " + exerciseRepo.getPath());
                }
            }
            catch (GitAPIException e) {
                throw new GitException("Git push failed for path: " + exerciseRepo.getPath(), e);
            }
        }
        finally {
            git.close();
        }
    }

    public static Set<String> cleanRepo(File exerciseRepo) throws GitException {
        try (Git git = GitHandler.openGit(exerciseRepo);){
            git.add().addFilepattern(".").call();
            Status status = git.status().call();
            Set untrackedChanges = status.getUncommittedChanges();
            git.reset().setMode(ResetCommand.ResetType.HARD).call();
            Set set = untrackedChanges;
            return set;
        }
    }

    private static Git openGit(File repo) throws GitException {
        try {
            return Git.open((File)repo);
        }
        catch (IOException e) {
            throw new GitException("Git open failed for path: " + repo.getPath(), e);
        }
    }

    private static void makeAuth(TransportCommand<?, ?> command, final GitCredentials credentials) {
        if (credentials == null) {
            return;
        }
        command.setCredentialsProvider(credentials.toCredentialsProvider());
        command.setTransportConfigCallback(new TransportConfigCallback(){

            public void configure(Transport transport) {
                if (!(transport instanceof TransportHttp var2_3)) {
                    return;
                }
                if (credentials != null) {
                    httpTransport.setPreemptiveBasicAuthentication(credentials.username(), credentials.password());
                }
            }
        });
    }

    private GitHandler() {
        throw new IllegalAccessError();
    }
}

