/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.client.mappings;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ICourse;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExam;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.User;
import edu.kit.kastel.eclipse.common.client.mappings.IMappingLoader;
import java.io.Serializable;
import java.util.List;

public class ArtemisCourse
implements ICourse,
Serializable {
    private static final long serialVersionUID = -2658127210041804941L;
    @JsonProperty(value="id")
    private int courseId;
    @JsonProperty
    private String title;
    @JsonProperty
    private String shortName;
    @JsonProperty(value="instructorGroupName")
    private String instructorGroup;
    private transient List<IExercise> exercises;
    private transient List<IExam> exams;
    private transient IMappingLoader client;

    public int getCourseId() {
        return this.courseId;
    }

    public List<IExam> getExams() throws ArtemisClientException {
        if (this.exams == null) {
            this.exams = this.client.getExamsForCourse(this);
            this.exams.sort((e1, e2) -> e1.getTitle().compareTo(e2.getTitle()));
        }
        return this.exams;
    }

    public List<IExercise> getExercises() throws ArtemisClientException {
        if (this.exercises == null) {
            this.exercises = this.client.getGradingExercisesForCourse(this);
            this.exercises.sort((e1, e2) -> e1.getShortName().compareTo(e2.getShortName()));
        }
        return this.exercises;
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean isInstructor(User assessor) {
        return assessor != null && assessor.getGroups().contains(this.instructorGroup);
    }

    public void init(IMappingLoader client) {
        this.client = client;
    }
}

