/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.client.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractArtemisClient {
    private static final ILog log = Platform.getLog(AbstractArtemisClient.class);
    private static final String DEFAULT_PROTOCOL_PREFIX = "https://";
    protected static final String PROGRAMMING_SUBMISSION_PATHPART = "programming-submissions";
    protected static final String EXERCISES_PATHPART = "exercises";
    protected static final String COURSES_PATHPART = "courses";
    protected static final String EXAMS_PATHPART = "exams";
    protected static final String PARTICIPATION_PATHPART = "participations";
    protected static final String RESULT_PATHPART = "results";
    protected static final String COOKIE_NAME_JWT = "jwt";
    protected static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    protected final String hostname;
    private final String protocol;
    private ObjectMapper orm;

    protected AbstractArtemisClient(String hostname) {
        this.protocol = AbstractArtemisClient.extractProtocol(hostname.trim());
        this.hostname = AbstractArtemisClient.cleanupHostnameString(hostname.trim(), this.protocol);
        this.orm = this.createObjectMapper();
    }

    protected final OkHttpClient createClient(final String token) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).callTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS);
        if (token != null && !token.isBlank()) {
            builder = builder.cookieJar(new CookieJar(){

                public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
                }

                public List<Cookie> loadForRequest(HttpUrl url) {
                    return List.of(new Cookie.Builder().domain(AbstractArtemisClient.this.hostname).path("/").name(AbstractArtemisClient.COOKIE_NAME_JWT).value(token).httpOnly().secure().build());
                }
            });
        }
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final <R> R call(OkHttpClient client, Request request, Class<R> resultClass) throws ArtemisClientException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Response response = client.newCall(request).execute();){
                this.throwIfStatusUnsuccessful(response);
                if (resultClass != null) return this.read(response.body().string(), resultClass);
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ArtemisClientException(e.getMessage(), (Throwable)e);
        }
    }

    protected final HttpUrl path(Object ... path) {
        String requestPath = this.getApiRootURL();
        Object[] objectArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            Object segment = objectArray[n2];
            requestPath = String.valueOf(requestPath) + "/" + segment;
            ++n2;
        }
        return HttpUrl.parse((String)requestPath);
    }

    protected final String getRootURL() {
        return String.valueOf(this.protocol) + this.hostname;
    }

    private static String cleanupHostnameString(String hostname, String protocol) {
        String finalHostname = hostname;
        if (hostname.startsWith(protocol)) {
            finalHostname = finalHostname.substring(protocol.length());
        }
        if (finalHostname.contains("/")) {
            finalHostname = finalHostname.split("/", 2)[0];
        }
        log.info("Using " + finalHostname + " as hostname of artemis. Protocol is " + protocol);
        return finalHostname;
    }

    private static String extractProtocol(String hostname) {
        if (!hostname.contains("://")) {
            return DEFAULT_PROTOCOL_PREFIX;
        }
        return String.valueOf(hostname.split("://", 2)[0]) + "://";
    }

    protected final String getApiRootURL() {
        return String.valueOf(this.getRootURL()) + "/api";
    }

    protected void throwIfStatusUnsuccessful(Response response) throws ArtemisClientException {
        if (!response.isSuccessful()) {
            throw new ArtemisClientException(String.format("Communication with \" %s \" failed with status \"%s: %s\".", this.getApiRootURL(), response.code(), "HTTP_ERROR"));
        }
    }

    protected <E> String payload(E rspEntity) throws ArtemisClientException {
        try {
            return this.orm.writeValueAsString(rspEntity);
        }
        catch (JsonProcessingException e) {
            throw new ArtemisClientException(e.getMessage(), (Throwable)e);
        }
    }

    protected <E> E read(String rspEntity, Class<E> clazz) throws ArtemisClientException {
        try {
            return (E)this.orm.readValue(rspEntity, clazz);
        }
        catch (JsonProcessingException e) {
            throw new ArtemisClientException(e.getMessage(), (Throwable)e);
        }
    }

    private ObjectMapper createObjectMapper() {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

