/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.client.rest;

import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.artemis.AssessmentResult;
import edu.kit.kastel.eclipse.common.api.artemis.ILockResult;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ISubmission;
import edu.kit.kastel.eclipse.common.api.client.IAssessmentArtemisClient;
import edu.kit.kastel.eclipse.common.api.controller.ExerciseStats;
import edu.kit.kastel.eclipse.common.client.mappings.ArtemisSubmission;
import edu.kit.kastel.eclipse.common.client.mappings.lock.LockResult;
import edu.kit.kastel.eclipse.common.client.mappings.stats.Stats;
import edu.kit.kastel.eclipse.common.client.mappings.stats.Timing;
import edu.kit.kastel.eclipse.common.client.rest.AbstractArtemisClient;
import java.io.IOException;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;

public class AssessmentArtemisClient
extends AbstractArtemisClient
implements IAssessmentArtemisClient {
    private static final ILog log = Platform.getLog(AssessmentArtemisClient.class);
    private static final String SUBMISSION_WIHOUT_ASSESSMENT_PATH = "programming-submission-without-assessment";
    private static final String PARTICIPATION_PATHPART = "participations";
    private static final String MANUAL_RESULT_PATHPART = "manual-results";
    private static final String CORRECTION_ROUND_QUERY_PARAM = "correction-round";
    private static final String LOCK_QUERY_PARAM = "lock";
    private static final String SUBMIT_QUERY_PARAM = "submit";
    protected static final String STATS_PATH = "stats-for-assessment-dashboard";
    private final OkHttpClient client;

    public AssessmentArtemisClient(String hostname, String token) {
        super(hostname);
        this.client = this.createClient(token);
    }

    public void saveAssessment(int participationId, boolean submit, AssessmentResult assessment) throws ArtemisClientException {
        String assessmentPayload = this.payload(assessment);
        log.info(String.format("Saving assessment for submission %s with json: %s", assessment.id, assessmentPayload));
        Request request = new Request.Builder().url(this.path(PARTICIPATION_PATHPART, participationId, MANUAL_RESULT_PATHPART).newBuilder().addQueryParameter(SUBMIT_QUERY_PARAM, String.valueOf(submit)).build()).put(RequestBody.create((String)assessmentPayload, (MediaType)JSON)).build();
        this.call(this.client, request, null);
    }

    public ILockResult startAssessment(ISubmission submission) throws ArtemisClientException {
        Request request = new Request.Builder().url(this.path("programming-submissions", submission.getSubmissionId(), LOCK_QUERY_PARAM).newBuilder().addQueryParameter(CORRECTION_ROUND_QUERY_PARAM, String.valueOf(submission.getCorrectionRound())).build()).get().build();
        return this.call(this.client, request, LockResult.class);
    }

    public Optional<ILockResult> startNextAssessment(IExercise exercise, int correctionRound) throws ArtemisClientException {
        Request request = new Request.Builder().url(this.path("exercises", exercise.getExerciseId(), SUBMISSION_WIHOUT_ASSESSMENT_PATH).newBuilder().addQueryParameter(CORRECTION_ROUND_QUERY_PARAM, String.valueOf(correctionRound)).addQueryParameter(LOCK_QUERY_PARAM, String.valueOf(true)).build()).get().build();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Response response = this.client.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    return Optional.empty();
                }
                return Optional.of((ILockResult)this.read(response.body().string(), LockResult.class));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ArtemisClientException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExerciseStats getStats(IExercise exercise) throws ArtemisClientException {
        Request request = new Request.Builder().url(this.path("exercises", exercise.getExerciseId(), STATS_PATH)).get().build();
        Stats stats = null;
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (Response response = this.client.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    return null;
                }
                stats = this.read(response.body().string(), Stats.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ArtemisClientException(e.getMessage(), (Throwable)e);
        }
        int submissionsInRound1 = this.countSubmissions(exercise, 0);
        int submissionsInRound2 = 0;
        if (!exercise.hasSecondCorrectionRound()) return new ExerciseStats(this.countInRounds(stats.numberOfAssessmentsOfCorrectionRounds()), stats.numberOfSubmissions().inTime(), stats.totalNumberOfAssessmentLocks(), submissionsInRound1 + submissionsInRound2);
        submissionsInRound2 = this.countSubmissions(exercise, 1);
        return new ExerciseStats(this.countInRounds(stats.numberOfAssessmentsOfCorrectionRounds()), stats.numberOfSubmissions().inTime(), stats.totalNumberOfAssessmentLocks(), submissionsInRound1 + submissionsInRound2);
    }

    private int countInRounds(Timing[] rounds) {
        int countInTime = 0;
        Timing[] timingArray = rounds;
        int n = rounds.length;
        int n2 = 0;
        while (n2 < n) {
            Timing round = timingArray[n2];
            countInTime += round.inTime();
            ++n2;
        }
        return countInTime;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int countSubmissions(IExercise exercise, int correctionRound) throws ArtemisClientException {
        Request request = new Request.Builder().url(this.path("exercises", exercise.getExerciseId(), "programming-submissions").newBuilder().addQueryParameter("assessedByTutor", String.valueOf(true)).addQueryParameter(CORRECTION_ROUND_QUERY_PARAM, String.valueOf(correctionRound)).build()).get().build();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Response response = this.client.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    return 0;
                }
                ArtemisSubmission[] submissionsArray = this.read(response.body().string(), ArtemisSubmission[].class);
                return submissionsArray.length;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ArtemisClientException(e.getMessage(), (Throwable)e);
        }
    }
}

