/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.client.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.User;
import edu.kit.kastel.eclipse.common.api.client.IAuthenticationArtemisClient;
import edu.kit.kastel.eclipse.common.client.BrowserLogin;
import edu.kit.kastel.eclipse.common.client.rest.AbstractArtemisClient;
import java.io.IOException;
import java.io.Serializable;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LoginManager
extends AbstractArtemisClient
implements IAuthenticationArtemisClient {
    private String username;
    private String password;
    private String token;
    private final OkHttpClient client;
    private User assessor;

    public LoginManager(String hostname, String username, String password) {
        super(hostname);
        this.username = username;
        this.password = password;
        this.client = this.createClient(null);
    }

    public String getArtemisUrl() {
        return this.getRootURL();
    }

    public void login() throws ArtemisClientException {
        if (this.hostname.isBlank()) {
            throw new ArtemisClientException("Login without hostname is impossible");
        }
        if (this.username.isBlank() || this.password.isBlank()) {
            BrowserLogin login = new BrowserLogin(this.getRootURL());
            this.token = login.getToken();
        } else {
            this.token = this.loginViaUsernameAndPassword();
        }
        this.assessor = this.fetchAssessor();
    }

    public boolean isLoggedIn() {
        return this.token != null;
    }

    public String getRawToken() {
        return this.token;
    }

    public String getBearerToken() {
        return this.token;
    }

    public User getUser() {
        return this.assessor;
    }

    private User fetchAssessor() throws ArtemisClientException {
        if (this.token == null) {
            return null;
        }
        OkHttpClient clientWithToken = this.createClient(this.token);
        Request request = new Request.Builder().url(this.path("account")).get().build();
        return this.call(clientWithToken, request, User.class);
    }

    private String loginViaUsernameAndPassword() throws ArtemisClientException {
        String payload = this.payload(this.getAuthenticationEntity());
        Request request = new Request.Builder().url(this.path("authenticate")).post(RequestBody.create((String)payload, (MediaType)JSON)).build();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Response response = this.client.newCall(request).execute();){
                this.throwIfStatusUnsuccessful(response);
                String cookieHeader = response.headers().get("set-cookie");
                if (cookieHeader != null && cookieHeader.startsWith("jwt")) {
                    return cookieHeader.split(";", 2)[0].trim().substring("jwt=".length());
                }
                throw new ArtemisClientException("Authentication was not successful. Cookie not received!");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ArtemisClientException(e.getMessage(), (Throwable)e);
        }
    }

    private final AuthenticationEntity getAuthenticationEntity() {
        AuthenticationEntity entity = new AuthenticationEntity();
        entity.username = this.username;
        entity.password = this.password;
        return entity;
    }

    private static final class AuthenticationEntity
    implements Serializable {
        private static final long serialVersionUID = -6291795795865534155L;
        @JsonProperty
        private String username;
        @JsonProperty
        private String password;
        @JsonProperty
        private boolean rememberMe = true;

        private AuthenticationEntity() {
        }
    }
}

