/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.common.client.rest;

import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ISubmission;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.User;
import edu.kit.kastel.eclipse.common.api.client.ISubmissionsArtemisClient;
import edu.kit.kastel.eclipse.common.client.mappings.ArtemisSubmission;
import edu.kit.kastel.eclipse.common.client.rest.AbstractArtemisClient;
import java.util.Arrays;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class SubmissionsArtemisClient
extends AbstractArtemisClient
implements ISubmissionsArtemisClient {
    private final OkHttpClient client;
    private User assessor;

    public SubmissionsArtemisClient(String hostname, String token, User assessor) {
        super(hostname);
        this.client = this.createClient(token);
        this.assessor = assessor;
    }

    public List<ISubmission> getSubmissions(IExercise exercise, int correctionRound) throws ArtemisClientException {
        ArtemisSubmission[] submissionsArray;
        boolean isInstructor = exercise.getCourse().isInstructor(this.assessor);
        Request request = new Request.Builder().url(this.path("exercises", exercise.getExerciseId(), "programming-submissions").newBuilder().addQueryParameter("assessedByTutor", String.valueOf(!isInstructor)).addQueryParameter("correction-round", String.valueOf(correctionRound)).build()).get().build();
        ArtemisSubmission[] artemisSubmissionArray = submissionsArray = this.call(this.client, request, ArtemisSubmission[].class);
        int n = submissionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArtemisSubmission submission = artemisSubmissionArray[n2];
            submission.init(correctionRound);
            ++n2;
        }
        return Arrays.asList(submissionsArray);
    }

    public ISubmission getSubmissionById(IExercise artemisExercise, int submissionId) throws ArtemisClientException {
        List submissions = this.getSubmissions(artemisExercise);
        ISubmission target = submissions.stream().filter(s -> s.getSubmissionId() == submissionId).findFirst().orElse(null);
        if (target == null) {
            throw new ArtemisClientException(String.format("Submission %d not found!", submissionId));
        }
        return target;
    }
}

