/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.io.File;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectSorter;
import org.apache.maven.repository.DelegatingLocalArtifactRepository;
import org.apache.maven.repository.LocalArtifactRepository;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.ILocalRepositoryListener;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.ExtensionReader;
import org.eclipse.m2e.core.internal.IMavenToolbox;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.URLConnectionCaches;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.MavenProperties;
import org.eclipse.m2e.core.internal.embedder.PlexusContainerManager;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingResult;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.MarkerUtils;
import org.eclipse.m2e.core.internal.project.ResolverConfigurationIO;
import org.eclipse.m2e.core.internal.project.registry.AbstractMavenDependencyResolver;
import org.eclipse.m2e.core.internal.project.registry.Capability;
import org.eclipse.m2e.core.internal.project.registry.DefaultMavenDependencyResolver;
import org.eclipse.m2e.core.internal.project.registry.DependencyResolutionContext;
import org.eclipse.m2e.core.internal.project.registry.EclipseWorkspaceArtifactRepository;
import org.eclipse.m2e.core.internal.project.registry.ILifecycleMapping2;
import org.eclipse.m2e.core.internal.project.registry.IProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.MavenCapability;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectCache;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.MavenRequiredCapability;
import org.eclipse.m2e.core.internal.project.registry.MutableProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.ProjectProcessingTracker;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryReader;
import org.eclipse.m2e.core.internal.project.registry.RequiredCapability;
import org.eclipse.m2e.core.internal.project.registry.StaleMutableProjectRegistryException;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IProjectConfiguration;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ProjectRegistryManager.class})
public class ProjectRegistryManager
implements ISaveParticipant {
    static final Logger log = LoggerFactory.getLogger(ProjectRegistryManager.class);
    static final String ARTIFACT_TYPE_POM = "pom";
    static final String ARTIFACT_TYPE_JAR = "jar";
    public static final String ARTIFACT_TYPE_JAVA_SOURCE = "java-source";
    public static final String ARTIFACT_TYPE_JAVADOC = "javadoc";
    public static final String LIFECYCLE_DEFAULT = "deploy";
    public static final String LIFECYCLE_CLEAN = "clean";
    public static final String LIFECYCLE_SITE = "site";
    public static final List<IPath> METADATA_PATH = List.of(new Path("pom.xml"), new Path(".settings/org.eclipse.m2e.core.prefs"));
    private ProjectRegistry projectRegistry;
    @Reference
    IMaven maven;
    @Reference
    IMavenMarkerManager markerManager;
    @Reference
    private IMavenConfiguration configuration;
    @Reference
    private PlexusContainerManager containerManager;
    @Reference
    private ProjectRegistryReader stateReader;
    @Reference
    private MavenProjectCache mavenProjectCache;
    private final Set<IMavenProjectChangedListener> projectChangeListeners = new LinkedHashSet<IMavenProjectChangedListener>();
    private volatile Thread syncRefreshThread;
    Consumer<Map<IMavenProjectFacade, MavenProject>> addContextProjectListener;

    @Activate
    void init() {
        ProjectRegistry state = this.configuration.isUpdateProjectsOnStartup() ? null : this.stateReader.readWorkspaceState(this);
        this.projectRegistry = state != null && state.isValid() ? state : new ProjectRegistry();
    }

    public MavenProjectFacade create(IProject project, IProgressMonitor monitor) {
        return this.create(this.getPom(project), false, monitor);
    }

    public MavenProjectFacade create(IFile pom, boolean load, IProgressMonitor monitor) {
        if (pom == null) {
            return null;
        }
        MavenProjectFacade projectFacade = this.projectRegistry.getProjectFacade(pom);
        if (projectFacade == null && load) {
            IProjectConfiguration config = ResolverConfigurationIO.readResolverConfiguration(pom.getProject());
            MavenExecutionResult executionResult = this.readProjectsWithDependencies(pom, config, monitor).iterator().next();
            MavenProject mavenProject = executionResult.getProject();
            if (mavenProject != null && mavenProject.getArtifact() != null) {
                projectFacade = new MavenProjectFacade(this, pom, mavenProject, config);
            } else {
                List exceptions = executionResult.getExceptions();
                if (exceptions != null) {
                    for (Throwable ex : exceptions) {
                        String msg = "Failed to read Maven project: " + ex.getMessage();
                        log.error(msg, ex);
                    }
                }
            }
        }
        return projectFacade;
    }

    IFile getPom(IProject project) {
        if (project == null || !project.isAccessible()) {
            return null;
        }
        File baseDir = project.getLocation().toFile();
        Optional<File> pom = IMavenToolbox.of(this.containerManager.getComponentLookup(baseDir)).locatePom(baseDir);
        return pom.map(pomFile -> {
            IFile file = project.getFile(pomFile.getName());
            try {
                file.refreshLocal(0, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return file;
        }).orElse(null);
    }

    public Set<IFile> remove(MutableProjectRegistry state, Set<IFile> poms, boolean force) {
        LinkedHashSet<IFile> pomSet = new LinkedHashSet<IFile>();
        for (IFile pom : poms) {
            MavenProjectFacade facade = state.getProjectFacade(pom);
            if (!force && facade != null && !facade.isStale()) continue;
            pomSet.addAll(this.remove(state, pom));
        }
        return pomSet;
    }

    public Set<IFile> remove(MutableProjectRegistry state, IFile pom) {
        MavenProjectFacade facade = state.getProjectFacade(pom);
        ArtifactKey mavenProject = facade != null ? facade.getArtifactKey() : null;
        this.flushCaches(facade, false);
        if (mavenProject == null) {
            state.removeProject(pom, null);
            return Collections.emptySet();
        }
        LinkedHashSet<IFile> pomSet = new LinkedHashSet<IFile>();
        pomSet.addAll(state.getDependents(MavenCapability.createMavenArtifact(mavenProject), false));
        pomSet.addAll(state.getDependents(MavenCapability.createMavenParent(mavenProject), false));
        state.removeProject(pom, mavenProject);
        pomSet.addAll(this.refreshWorkspaceModules(state, mavenProject));
        pomSet.remove(pom);
        return pomSet;
    }

    private boolean isForceDependencyUpdate() throws CoreException {
        MavenExecutionContext context = MavenExecutionContext.getThreadContext();
        return context != null && context.getExecutionRequest().isUpdateSnapshots();
    }

    public Map<IFile, IStatus> refresh(Collection<IFile> pomFiles, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ProjectRegistryManager_task_refreshing, (int)100);
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        Job.getJobManager().beginRule((ISchedulingRule)rule, (IProgressMonitor)progress);
        this.syncRefreshThread = Thread.currentThread();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            MutableProjectRegistry newState = this.newMutableProjectRegistry();
            try {
                Map<IFile, IStatus> result = this.refresh(newState, pomFiles, (IProgressMonitor)progress.newChild(95));
                this.applyMutableProjectRegistry(newState, (IProgressMonitor)progress.newChild(5));
                Map<IFile, IStatus> map = result;
                if (newState != null) {
                    newState.close();
                }
                return map;
            }
            catch (Throwable throwable2) {
                try {
                    if (newState != null) {
                        newState.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }
        finally {
            this.syncRefreshThread = null;
            Job.getJobManager().endRule((ISchedulingRule)rule);
        }
    }

    Map<IFile, IStatus> refresh(MutableProjectRegistry newState, Collection<IFile> pomFiles, IProgressMonitor monitor) throws CoreException {
        long start = System.currentTimeMillis();
        log.debug("Refreshing ({} files): {}", (Object)pomFiles.size(), pomFiles);
        URLConnectionCaches.assertDisabled();
        DependencyResolutionContext context = new DependencyResolutionContext(pomFiles);
        HashSet installedArtifacts = new HashSet();
        ILocalRepositoryListener listener = (repositoryBasedir, baseArtifact, artifact, artifactFile) -> {
            if (artifactFile == null) {
                return;
            }
            LinkedHashSet<IFile> refresh = new LinkedHashSet<IFile>();
            if (installedArtifacts.add(artifact)) {
                refresh.addAll(newState.getVersionedDependents(MavenCapability.createMavenParent(artifact), true));
                refresh.addAll(newState.getVersionedDependents(MavenCapability.createMavenArtifact(artifact), true));
                refresh.addAll(newState.getVersionedDependents(MavenCapability.createMavenArtifactImport(artifact), true));
            }
            if (installedArtifacts.add(baseArtifact)) {
                refresh.addAll(newState.getVersionedDependents(MavenCapability.createMavenParent(baseArtifact), true));
                refresh.addAll(newState.getVersionedDependents(MavenCapability.createMavenArtifact(baseArtifact), true));
                refresh.addAll(newState.getVersionedDependents(MavenCapability.createMavenArtifactImport(baseArtifact), true));
            }
            if (!refresh.isEmpty()) {
                log.debug("Automatic refresh. artifact={}/{}. projects={}", new Object[]{baseArtifact, artifact, refresh});
                context.forcePomFiles(refresh);
            }
        };
        this.maven.addLocalRepositoryListener(listener);
        try {
            this.refresh(newState, context, monitor);
            ConcurrentHashMap<IFile, IStatus> statusResult = new ConcurrentHashMap<IFile, IStatus>();
            for (IFile file : pomFiles) {
                statusResult.put(file, context.getStatus(file));
            }
            ConcurrentHashMap<IFile, IStatus> concurrentHashMap = statusResult;
            return concurrentHashMap;
        }
        finally {
            this.maven.removeLocalRepositoryListener(listener);
            log.debug("Refresh takes {} ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    private void refresh(MutableProjectRegistry newState, DependencyResolutionContext context, IProgressMonitor monitor) throws CoreException {
        LinkedHashSet<IFile> allProcessedPoms = new LinkedHashSet<IFile>();
        HashSet<IFile> allNewFacades = new HashSet<IFile>();
        HashMap<IFile, Set<Capability>> originalCapabilities = new HashMap<IFile, Set<Capability>>();
        HashMap<IFile, Set<RequiredCapability>> originalRequirements = new HashMap<IFile, Set<RequiredCapability>>();
        while (!context.isEmpty()) {
            List<IFile> pomsForUpdate = this.calculateFacadesForUpdate(newState, context, allProcessedPoms::add, allNewFacades::contains, monitor);
            context.clearErrors(pomsForUpdate);
            Map<IFile, MavenProjectFacade> newFacades = this.readMavenProjectFacades(pomsForUpdate, newState, context, monitor);
            for (Map.Entry<IFile, MavenProjectFacade> entry : newFacades.entrySet()) {
                IFile pom2 = entry.getKey();
                MavenProjectFacade newFacade = entry.getValue();
                newState.setProject(pom2, newFacade);
                if (newFacade == null) continue;
                MavenCapability mavenParentCapability = MavenCapability.createMavenParent(newFacade.getArtifactKey());
                for (IFile file : newState.getVersionedDependents(mavenParentCapability, true)) {
                    if (newFacades.containsKey(file)) continue;
                    context.forcePomFile(file);
                }
                MavenCapability mavenArtifactImportCapability = MavenCapability.createMavenArtifactImport(newFacade.getArtifactKey());
                for (IFile file : newState.getVersionedDependents(mavenArtifactImportCapability, true)) {
                    if (newFacades.containsKey(file)) continue;
                    context.forcePomFile(file);
                }
                LinkedHashSet<Capability> capabilities = new LinkedHashSet<Capability>();
                capabilities.add(mavenParentCapability);
                capabilities.add(MavenCapability.createMavenArtifact(newFacade.getArtifactKey()));
                Set<Capability> oldCapabilities = newState.setCapabilities(pom2, capabilities);
                originalCapabilities.putIfAbsent(pom2, oldCapabilities);
                MavenProject mavenProject = this.getMavenProject(newFacade);
                LinkedHashSet<RequiredCapability> requirements = new LinkedHashSet<RequiredCapability>();
                DefaultMavenDependencyResolver.addProjectStructureRequirements(requirements, mavenProject);
                Set<RequiredCapability> oldRequirements = newState.setRequirements(pom2, requirements);
                originalRequirements.putIfAbsent(pom2, oldRequirements);
            }
            allNewFacades.addAll(newFacades.keySet());
            ArrayList<IFile> erroneousPoms = new ArrayList<IFile>(pomsForUpdate);
            erroneousPoms.removeAll(newFacades.keySet());
            erroneousPoms.forEach(pom -> newState.setProject((IFile)pom, null));
            if (newFacades.isEmpty()) continue;
            HashSet<IFile> pomFiles = new HashSet<IFile>(erroneousPoms);
            context.forcePomFiles(pomFiles);
        }
        context.forcePomFiles(allProcessedPoms);
        ProjectProcessingTracker tracker = new ProjectProcessingTracker(context);
        while (true) {
            if (!context.isEmpty()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (newState.isStale() || this.syncRefreshThread != null && this.syncRefreshThread != Thread.currentThread()) {
                    throw new StaleMutableProjectRegistryException();
                }
                IFile pom3 = context.pop();
                if (!tracker.shouldProcess(pom3)) continue;
                MavenProjectFacade newFacade = null;
                if (pom3.isAccessible() && pom3.getProject().hasNature("org.eclipse.m2e.core.maven2Nature")) {
                    newFacade = newState.getProjectFacade(pom3);
                }
                if (newFacade != null) {
                    MavenProject mavenProject = this.getMavenProject(newFacade);
                    if (!allProcessedPoms.contains(newFacade.getPom())) {
                        newFacade = this.readMavenProjectFacades(Collections.singletonList(pom3), newState, context, monitor).get(pom3);
                    } else {
                        this.putMavenProject(newFacade, null);
                        newFacade = new MavenProjectFacade(newFacade);
                        this.putMavenProject(newFacade, mavenProject);
                    }
                    this.mavenProjectCache.updateMavenProject(newFacade, mavenProject);
                }
                if (newFacade != null) {
                    MavenProjectFacade facade = newFacade;
                    IProjectConfiguration resolverConfiguration = facade.getConfiguration();
                    this.createExecutionContext(newState, pom3, resolverConfiguration).execute(this.getMavenProject(newFacade), (executionContext, pm) -> {
                        this.refreshPhase2(newState, context, originalCapabilities, originalRequirements, pom3, facade, pm);
                        return null;
                    }, monitor);
                } else {
                    this.refreshPhase2(newState, context, originalCapabilities, originalRequirements, pom3, newFacade, monitor);
                }
                monitor.worked(1);
                continue;
            }
            if (!tracker.needsImprovement()) break;
        }
    }

    private List<IFile> calculateFacadesForUpdate(MutableProjectRegistry registry, DependencyResolutionContext context, Consumer<IFile> processingListener, Predicate<IFile> alreadyProcessed, IProgressMonitor monitor) throws CoreException {
        ArrayList<IFile> toReadPomFiles = new ArrayList<IFile>();
        while (!context.isEmpty()) {
            MavenCapability mavenArtifactImportCapability;
            MavenCapability mavenParentCapability;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (registry.isStale() || this.syncRefreshThread != null && this.syncRefreshThread != Thread.currentThread()) {
                throw new StaleMutableProjectRegistryException();
            }
            IFile pom = context.pop();
            if (alreadyProcessed.test(pom)) continue;
            processingListener.accept(pom);
            monitor.subTask(NLS.bind((String)Messages.ProjectRegistryManager_task_project, (Object)pom.getProject().getName()));
            MavenProjectFacade oldFacade = registry.getProjectFacade(pom);
            context.forcePomFiles(this.flushCaches(oldFacade, this.isForceDependencyUpdate()));
            if (oldFacade != null) {
                this.putMavenProject(oldFacade, null);
            }
            if (pom.isAccessible() && pom.getProject().hasNature("org.eclipse.m2e.core.maven2Nature")) {
                toReadPomFiles.add(pom);
                if (oldFacade == null) continue;
                mavenParentCapability = MavenCapability.createMavenParent(oldFacade.getArtifactKey());
                context.forcePomFiles(registry.getVersionedDependents(mavenParentCapability, true));
                mavenArtifactImportCapability = MavenCapability.createMavenArtifactImport(oldFacade.getArtifactKey());
                context.forcePomFiles(registry.getVersionedDependents(mavenArtifactImportCapability, true));
                continue;
            }
            registry.setProject(pom, null);
            if (oldFacade == null) continue;
            mavenParentCapability = MavenCapability.createMavenParent(oldFacade.getArtifactKey());
            context.forcePomFiles(registry.getDependents(mavenParentCapability, true));
            mavenArtifactImportCapability = MavenCapability.createMavenArtifactImport(oldFacade.getArtifactKey());
            context.forcePomFiles(registry.getVersionedDependents(mavenArtifactImportCapability, true));
        }
        return toReadPomFiles;
    }

    void refreshPhase2(MutableProjectRegistry newState, DependencyResolutionContext context, Map<IFile, Set<Capability>> originalCapabilities, Map<IFile, Set<RequiredCapability>> originalRequirements, IFile pom, MavenProjectFacade newFacade, IProgressMonitor monitor) throws CoreException {
        LinkedHashSet<Capability> capabilities = null;
        HashSet requirements = null;
        if (newFacade != null) {
            monitor.subTask(NLS.bind((String)Messages.ProjectRegistryManager_task_project, (Object)newFacade.getProject().getName()));
            this.setupLifecycleMapping(monitor, newFacade);
            capabilities = new LinkedHashSet<Capability>();
            requirements = new LinkedHashSet<RequiredCapability>();
            mavenParentCapability = MavenCapability.createMavenParent(newFacade.getArtifactKey());
            capabilities.add(MavenCapability.createMavenArtifact(newFacade.getArtifactKey()));
            capabilities.add((Capability)mavenParentCapability);
            DefaultMavenDependencyResolver.addProjectStructureRequirements(requirements, this.getMavenProject(newFacade));
            resolver2 = this.getMavenDependencyResolver(newFacade, monitor);
            resolver2.setContextProjectRegistry(newState);
            try {
                resolver2.resolveProjectDependencies(newFacade, capabilities, requirements, monitor);
            }
            finally {
                resolver2.setContextProjectRegistry(null);
            }
            newState.setProject(pom, newFacade);
            newFacade.setMavenProjectArtifacts(this.getMavenProject(newFacade));
        } else if (pom.isAccessible() && pom.getProject().hasNature("org.eclipse.m2e.core.maven2Nature")) {
            try {
                mavenParentCapability = null;
                resolver2 = null;
                try (InputStream is = pom.getContents();){
                    Parent parent;
                    Model model = IMavenToolbox.of(this.maven).readModel(is);
                    if (model != null && model.getParent() != null && (parent = model.getParent()).getGroupId() != null && parent.getArtifactId() != null && parent.getVersion() != null) {
                        ArtifactKey parentKey = new ArtifactKey(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), null);
                        requirements = new HashSet();
                        requirements.add((RequiredCapability)MavenRequiredCapability.createMavenParent(parentKey));
                    }
                }
                catch (Throwable resolver2) {
                    if (mavenParentCapability == null) {
                        mavenParentCapability = resolver2;
                    } else if (mavenParentCapability != resolver2) {
                        mavenParentCapability.addSuppressed(resolver2);
                    }
                    throw mavenParentCapability;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        Set<Capability> oldCapabilities = newState.setCapabilities(pom, capabilities);
        if (originalCapabilities.containsKey(pom)) {
            oldCapabilities = originalCapabilities.get(pom);
        }
        Set<Capability> changedCapabilities = ProjectRegistryManager.diff(oldCapabilities, capabilities);
        boolean versionedCapabilitiesOnly = true;
        for (Capability capability : changedCapabilities) {
            if (!"maven-artifact".equals(capability.getVersionlessKey().namespace())) continue;
            versionedCapabilitiesOnly = false;
            break;
        }
        for (Capability capability : changedCapabilities) {
            context.forcePomFiles(versionedCapabilitiesOnly ? newState.getVersionedDependents(capability, true) : newState.getDependents(capability, true));
        }
        Set<RequiredCapability> oldRequirements = newState.setRequirements(pom, requirements);
        if (originalRequirements.containsKey(pom)) {
            oldRequirements = originalRequirements.get(pom);
        }
        if (oldCapabilities != null && ProjectRegistryManager.hasDiff(oldRequirements, requirements)) {
            for (Capability capability : oldCapabilities) {
                context.forcePomFiles(newState.getVersionedDependents(capability, true));
            }
        }
    }

    private void setupLifecycleMapping(IProgressMonitor monitor, MavenProjectFacade newFacade) throws CoreException {
        LifecycleMappingResult mappingResult = LifecycleMappingFactory.calculateLifecycleMapping(this.getMavenProject(newFacade), newFacade.getMojoExecutions(), newFacade.getConfiguration().getLifecycleMappingId(), monitor);
        newFacade.setLifecycleMappingId(mappingResult.getLifecycleMappingId());
        Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping = mappingResult.getMojoExecutionMapping();
        if (mojoExecutionMapping != null) {
            this.detachMappingSources(mojoExecutionMapping);
        }
        newFacade.setMojoExecutionMapping(mojoExecutionMapping);
        newFacade.setSessionProperty(MavenProjectFacade.PROP_LIFECYCLE_MAPPING, mappingResult.getLifecycleMapping());
        LifecycleMappingFactory.setProjectConfigurators(newFacade, mappingResult);
        this.markerManager.deleteMarkers((IResource)newFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.lifecycleMapping");
        if (mappingResult.hasProblems()) {
            this.markerManager.addErrorMarkers((IResource)newFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.lifecycleMapping", mappingResult.getProblems());
        }
    }

    private void detachMappingSources(Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mapping) {
        for (List<IPluginExecutionMetadata> executions : mapping.values()) {
            if (executions == null) continue;
            ListIterator<IPluginExecutionMetadata> iterator = executions.listIterator();
            while (iterator.hasNext()) {
                IPluginExecutionMetadata metadata = iterator.next();
                if (!(metadata instanceof PluginExecutionMetadata var6_6)) continue;
                execution = execution.clone();
                execution.setSource(null);
                iterator.set(execution);
            }
        }
    }

    private static <T> Set<T> diff(Set<T> a, Set<T> b) {
        if (a == null || a.isEmpty()) {
            if (b == null || b.isEmpty()) {
                return Collections.emptySet();
            }
            return b;
        }
        if (b == null || b.isEmpty()) {
            return a;
        }
        Map<Object, Long> m = Stream.concat(a.stream(), b.stream()).collect(Collectors.groupingBy(e -> e, Collectors.counting()));
        m.values().removeIf(c -> c > 1L);
        return m.keySet();
    }

    static <T> boolean hasDiff(Set<T> a, Set<T> b) {
        if (a == null || a.isEmpty()) {
            return b != null && !b.isEmpty();
        }
        if (b == null || b.isEmpty()) {
            return true;
        }
        if (a.size() != b.size()) {
            return true;
        }
        Iterator<T> oldIter = a.iterator();
        Iterator<T> iter = b.iterator();
        while (oldIter.hasNext()) {
            T requirement;
            T oldRequirement = oldIter.next();
            if (oldRequirement.equals(requirement = iter.next())) continue;
            return true;
        }
        return false;
    }

    private AbstractMavenDependencyResolver getMavenDependencyResolver(MavenProjectFacade newFacade, IProgressMonitor monitor) {
        ILifecycleMapping lifecycleMapping = LifecycleMappingFactory.getLifecycleMapping(newFacade);
        if (lifecycleMapping instanceof ILifecycleMapping2 var4_5) {
            AbstractMavenDependencyResolver resolver = lifecycleMapping2.getDependencyResolver(monitor);
            resolver.setManager(this);
            return resolver;
        }
        return new DefaultMavenDependencyResolver(this, this.markerManager);
    }

    /*
     * Unable to fully structure code
     */
    private Map<IFile, MavenProjectFacade> readMavenProjectFacades(Collection<IFile> poms, MutableProjectRegistry state, DependencyResolutionContext resolutionContext, IProgressMonitor monitor) throws CoreException {
        if (poms.isEmpty()) {
            return Collections.emptyMap();
        }
        subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)poms.size());
        for (IFile pom : poms) {
            this.markerManager.deleteMarkers((IResource)pom, "org.eclipse.m2e.core.maven2Problem.pomloading");
        }
        resolverConfigurations = new HashMap<K, V>(poms.size(), 1.0f);
        groupsToImport = poms.stream().collect(Collectors.groupingBy((Function<IFile, IProjectConfiguration>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$8(org.eclipse.core.runtime.SubMonitor java.util.Map org.eclipse.core.resources.IFile ), (Lorg/eclipse/core/resources/IFile;)Lorg/eclipse/m2e/core/project/IProjectConfiguration;)((SubMonitor)subMonitor, resolverConfigurations), (Supplier<LinkedHashMap>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/util/LinkedHashMap;)(), Collectors.toCollection((Supplier<Collection>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/util/Collection;)())));
        result = new LinkedHashMap<IFile, MavenProjectFacade>(poms.size(), 1.0f);
        block3: for (Map.Entry<K, V> entry : groupsToImport.entrySet()) {
            resolverConfiguration = (IProjectConfiguration)entry.getKey();
            fileList = (Collection)entry.getValue();
            moduleProjectDirectory = resolverConfiguration.getMultiModuleProjectDirectory();
            context = new MavenExecutionContext(this.containerManager.getComponentLookup(moduleProjectDirectory), moduleProjectDirectory, moduleProjectDirectory, null);
            this.configureExecutionRequest(context.getExecutionRequest(), state, fileList.size() == 1 ? (IFile)fileList.iterator().next() : null, resolverConfiguration);
            try {
                context.execute((ICallable<Map>)LambdaMetafactory.metafactory(null, null, null, (Lorg/eclipse/m2e/core/embedder/IMavenExecutionContext;Lorg/eclipse/core/runtime/IProgressMonitor;)Ljava/lang/Object;, lambda$11(java.util.Collection org.eclipse.m2e.core.project.IProjectConfiguration java.util.Map org.eclipse.m2e.core.embedder.IMavenExecutionContext org.eclipse.core.runtime.IProgressMonitor ), (Lorg/eclipse/m2e/core/embedder/IMavenExecutionContext;Lorg/eclipse/core/runtime/IProgressMonitor;)Ljava/util/Map;)((ProjectRegistryManager)this, (Collection)fileList, (IProjectConfiguration)resolverConfiguration, result), (IProgressMonitor)subMonitor.split(1));
                continue;
            }
            catch (CoreException e) {
                ** for (file : fileList)
            }
lbl-1000:
            // 1 sources

            {
                resolutionContext.setStatus(file, e.getStatus());
                continue;
lbl25:
                // 1 sources

            }
        }
        return result;
    }

    private Collection<MavenProject> getSortedProjects(Collection<MavenProject> projects) {
        if (projects.size() <= 1) {
            return projects;
        }
        try {
            ProjectSorter sorter = new ProjectSorter(projects);
            return sorter.getSortedProjects();
        }
        catch (DuplicateProjectException | CycleDetectedException ex) {
            return projects;
        }
    }

    IMavenMarkerManager getMarkerManager() {
        return this.markerManager;
    }

    public IFile getModulePom(IFile pom, String moduleName) {
        return pom.getParent().getFile(new Path(moduleName).append("pom.xml"));
    }

    private Set<IFile> refreshWorkspaceModules(MutableProjectRegistry state, ArtifactKey mavenProject) {
        if (mavenProject == null) {
            return Collections.emptySet();
        }
        return state.removeWorkspaceModules(mavenProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addMavenProjectChangedListener(IMavenProjectChangedListener listener) {
        Set<IMavenProjectChangedListener> set = this.projectChangeListeners;
        synchronized (set) {
            this.projectChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMavenProjectChangedListener(IMavenProjectChangedListener listener) {
        if (listener != null) {
            Set<IMavenProjectChangedListener> set = this.projectChangeListeners;
            synchronized (set) {
                this.projectChangeListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyProjectChangeListeners(List<MavenProjectChangedEvent> events, IProgressMonitor monitor) {
        if (!events.isEmpty()) {
            ArrayList<IMavenProjectChangedListener> listeners = new ArrayList<IMavenProjectChangedListener>();
            Set<IMavenProjectChangedListener> set = this.projectChangeListeners;
            synchronized (set) {
                listeners.addAll(this.projectChangeListeners);
            }
            listeners.addAll(ExtensionReader.readProjectChangedEventListenerExtentions());
            for (IMavenProjectChangedListener listener : listeners) {
                listener.mavenProjectChanged(events, monitor);
            }
        }
    }

    public MavenProjectFacade getMavenProject(String groupId, String artifactId, String version) {
        return this.projectRegistry.getProjectFacade(groupId, artifactId, version);
    }

    private MavenProject readProjectWithDependencies(IMavenProjectFacade facade) {
        IProjectConfiguration resolverConfiguration;
        IFile pomFile = facade.getPom();
        Collection<MavenExecutionResult> results = this.readProjectsWithDependencies(pomFile, resolverConfiguration = facade.getConfiguration(), null);
        if (results.size() != 1) {
            throw new IllegalStateException("Results should contain one entry.");
        }
        MavenExecutionResult result = results.iterator().next();
        MavenProject mavenProject = result.getProject();
        if (mavenProject != null && !ProjectRegistryManager.hasError(result)) {
            return mavenProject;
        }
        MultiStatus status = new MultiStatus("org.eclipse.m2e.core", 0, Messages.MavenProjectFacade_error);
        for (Throwable e : result.getExceptions()) {
            status.add(Status.error((String)e.getMessage(), (Throwable)e));
        }
        throw new IllegalStateException(new CoreException((IStatus)status).fillInStackTrace());
    }

    private static boolean hasError(MavenExecutionResult mavenExecutionResult) {
        if (!mavenExecutionResult.getExceptions().stream().anyMatch(ex -> !(ex instanceof ProjectBuildingException))) {
            if (!mavenExecutionResult.getExceptions().stream().map(ProjectBuildingException.class::cast).flatMap(ex -> ex.getResults().stream()).flatMap(result -> result.getProblems().stream()).map(ModelProblem::getSeverity).anyMatch(severity -> severity != ModelProblem.Severity.WARNING)) {
                return false;
            }
        }
        return true;
    }

    private Collection<MavenExecutionResult> readProjectsWithDependencies(IFile pomFile, IProjectConfiguration resolverConfiguration, IProgressMonitor monitor) {
        try {
            Map resultMap = Map.of();
            File multiModuleProjectDirectory = resolverConfiguration.getMultiModuleProjectDirectory();
            MavenExecutionContext context = new MavenExecutionContext(this.containerManager.getComponentLookup(multiModuleProjectDirectory), pomFile.getLocation().toFile(), multiModuleProjectDirectory, null);
            this.configureExecutionRequest(context.getExecutionRequest(), this.projectRegistry, pomFile, resolverConfiguration);
            resultMap = context.execute((ctx, mon) -> {
                ProjectBuildingRequest request = context.newProjectBuildingRequest();
                request.setResolveDependencies(true);
                List<File> pomFiles = Stream.of(ProjectRegistryManager.toJavaIoFile(pomFile)).filter(Objects::nonNull).toList();
                return IMavenToolbox.of(ctx).readMavenProjects(pomFiles, request);
            }, monitor);
            return resultMap.values();
        }
        catch (CoreException ex) {
            return List.of(new DefaultMavenExecutionResult().addException((Throwable)ex));
        }
    }

    public List<MavenProjectFacade> getProjects() {
        return this.projectRegistry.getProjects();
    }

    public IMavenProjectFacade getProject(IProject project) {
        return this.projectRegistry.getProjectFacade(this.getPom(project));
    }

    private MavenExecutionRequest configureExecutionRequest(MavenExecutionRequest request, IProjectRegistry state, IFile pom, IProjectConfiguration resolverConfiguration) throws CoreException {
        if (pom != null) {
            request.setPom(ProjectRegistryManager.toJavaIoFile(pom));
        }
        request.addActiveProfiles(resolverConfiguration.getActiveProfileList());
        request.addInactiveProfiles(resolverConfiguration.getInactiveProfileList());
        Properties userProperties = request.getUserProperties();
        userProperties.putAll(resolverConfiguration.getUserProperties());
        Map<String, String> addProperties = resolverConfiguration.getConfigurationProperties();
        if (addProperties != null && !addProperties.isEmpty()) {
            userProperties.putAll(addProperties);
        }
        request.setLocalRepository(this.maven.getLocalRepository());
        request.setWorkspaceReader((WorkspaceReader)ProjectRegistryManager.getWorkspaceReader(state, pom, resolverConfiguration));
        if (pom != null && pom.getLocation() != null) {
            request.setMultiModuleProjectDirectory(MavenProperties.computeMultiModuleProjectDirectory(pom.getLocation().toFile()));
        }
        return request;
    }

    private static EclipseWorkspaceArtifactRepository getWorkspaceReader(IProjectRegistry state, IFile pom, IProjectConfiguration resolverConfiguration) {
        Context context = new Context(state, resolverConfiguration, pom);
        return new EclipseWorkspaceArtifactRepository(context);
    }

    public MavenArtifactRepository getWorkspaceLocalRepository() throws CoreException {
        ResolverConfiguration resolverConfiguration = new ResolverConfiguration();
        resolverConfiguration.setResolveWorkspaceProjects(true);
        EclipseWorkspaceArtifactRepository workspaceReader = ProjectRegistryManager.getWorkspaceReader(this.projectRegistry, null, resolverConfiguration);
        return this.createDelegate(workspaceReader, this.maven.getLocalRepository());
    }

    private MavenArtifactRepository createDelegate(EclipseWorkspaceArtifactRepository workspaceReader, ArtifactRepository localRepository) {
        DelegatingLocalArtifactRepository localRepo = new DelegatingLocalArtifactRepository(localRepository);
        localRepo.setIdeWorkspace((LocalArtifactRepository)workspaceReader);
        return localRepo;
    }

    MutableProjectRegistry newMutableProjectRegistry() {
        return new MutableProjectRegistry(this.projectRegistry);
    }

    void applyMutableProjectRegistry(MutableProjectRegistry newState, IProgressMonitor monitor) {
        List<MavenProjectChangedEvent> events = this.projectRegistry.apply(newState);
        this.notifyProjectChangeListeners(events, monitor);
    }

    public void writeWorkspaceState() {
        if (this.stateReader != null && this.projectRegistry != null) {
            this.stateReader.writeWorkspaceState(this.projectRegistry);
        }
    }

    PlexusContainerManager getContainerManager() {
        return this.containerManager;
    }

    private IMavenExecutionContext createExecutionContext(IProjectRegistry state, IFile pom, IProjectConfiguration resolverConfiguration) throws CoreException {
        IMavenExecutionContext context;
        try {
            MavenProjectFacade facade = this.projectRegistry.getProjectFacade(pom);
            if (facade != null) {
                context = facade.createExecutionContext();
            } else {
                File pomLocation;
                File basedir = pom != null && pom.getLocation() != null ? ((pomLocation = pom.getLocation().toFile()).isDirectory() ? pomLocation : pomLocation.getParentFile()) : null;
                context = new MavenExecutionContext(this.containerManager.aquire((IResource)pom).getComponentLookup(), basedir, null);
            }
        }
        catch (Exception ex) {
            throw new CoreException(Status.error((String)"Acquire container failed", (Throwable)ex));
        }
        this.configureExecutionRequest(context.getExecutionRequest(), state, pom, resolverConfiguration);
        return context;
    }

    public IMavenExecutionContext createExecutionContext(IFile pom, IProjectConfiguration resolverConfiguration) throws CoreException {
        return this.createExecutionContext(this.projectRegistry, pom, resolverConfiguration);
    }

    /*
     * WARNING - void declaration
     */
    MavenProject getMavenProject(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        Map<IMavenProjectFacade, MavenProject> mavenProjects = MavenProjectCache.getContextProjectMap();
        try {
            return mavenProjects.computeIfAbsent(facade, fac -> this.mavenProjectCache.getMavenProject((IMavenProjectFacade)fac, this::readProjectWithDependencies));
        }
        catch (RuntimeException ex) {
            Throwable cause;
            Throwable throwable = cause = ex.getCause();
            if (throwable instanceof CoreException var6_7) {
                void coreException;
                throw coreException;
            }
            throw new CoreException(Status.error((String)"Unexpected internal Error occured", (Throwable)ex));
        }
    }

    MavenProject getMavenProject(MavenProjectFacade facade) {
        MavenProject mavenProject = this.mavenProjectCache.getMavenProject(facade, null);
        if (mavenProject != null) {
            this.putMavenProject(facade, mavenProject);
        } else {
            mavenProject = MavenProjectCache.getContextProjectMap().get(facade);
        }
        return mavenProject;
    }

    public void putMavenProject(MavenProjectFacade facade, MavenProject mavenProject) {
        Map<IMavenProjectFacade, MavenProject> mavenProjects = MavenProjectCache.getContextProjectMap();
        if (mavenProject != null) {
            mavenProjects.put(facade, mavenProject);
            if (this.addContextProjectListener != null) {
                this.addContextProjectListener.accept(mavenProjects);
            }
        } else {
            mavenProjects.remove(facade);
        }
    }

    private Set<IFile> flushCaches(IMavenProjectFacade facade, boolean forceDependencyUpdate) {
        if (facade != null) {
            ArtifactKey key = facade.getArtifactKey();
            this.mavenProjectCache.invalidateProjectFacade(facade);
            HashSet<IFile> ifiles = new HashSet<IFile>();
            for (File file : this.mavenProjectCache.flushMavenCaches(facade.getPomFile(), key, forceDependencyUpdate)) {
                MavenProjectFacade affected = this.projectRegistry.getProjectFacade(file);
                if (affected == null) continue;
                ifiles.add(affected.getPom());
            }
            return ifiles;
        }
        return Collections.emptySet();
    }

    static File toJavaIoFile(IFile file) {
        IPath path = file.getLocation();
        if (path == null) {
            return ProjectRegistryManager.getRemoteFile(file);
        }
        return path.toFile();
    }

    private static File getRemoteFile(IFile file) {
        try {
            URI fileLocation = file.getLocationURI();
            IFileStore fileStore = EFS.getStore((URI)fileLocation);
            return fileStore.toLocalFile(4096, null);
        }
        catch (CoreException ex) {
            log.warn("Failed to create local file representation of {}", (Object)file);
            return null;
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    void setWorkspace(IWorkspace workspace) throws CoreException {
        workspace.addSaveParticipant("org.eclipse.m2e.core", (ISaveParticipant)this);
    }

    void unsetWorkspace(IWorkspace workspace) {
        workspace.removeSaveParticipant("org.eclipse.m2e.core");
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) {
        this.writeWorkspaceState();
    }

    private static /* synthetic */ IProjectConfiguration lambda$8(SubMonitor subMonitor, Map map, IFile pom) {
        subMonitor.checkCanceled();
        IProjectConfiguration resolverConfiguration = ResolverConfigurationIO.readResolverConfiguration(pom.getProject());
        map.put(pom, resolverConfiguration);
        return resolverConfiguration;
    }

    private /* synthetic */ Map lambda$11(Collection collection, IProjectConfiguration iProjectConfiguration, Map map, IMavenExecutionContext ctx, IProgressMonitor mon) throws CoreException {
        Map pomFiles = collection.stream().filter(IResource::isAccessible).collect(Collectors.toMap(Function.identity(), ProjectRegistryManager::toJavaIoFile));
        Map<File, MavenExecutionResult> mavenResults = IMavenToolbox.of(ctx).readMavenProjects(pomFiles.values(), ctx.newProjectBuildingRequest());
        HashMap facades = new HashMap(mavenResults.size(), 1.0f);
        HashMap<MavenProject, MavenProjectFacade> facadeMap = new HashMap<MavenProject, MavenProjectFacade>();
        for (Map.Entry fileEntry : pomFiles.entrySet()) {
            IFile pom = (IFile)fileEntry.getKey();
            File file = fileEntry.getValue();
            if (!pom.isAccessible()) continue;
            MavenExecutionResult mavenResult = mavenResults.get(file);
            MavenProject mavenProject = mavenResult.getProject();
            MarkerUtils.addEditorHintMarkers(this.markerManager, pom, mavenProject, "org.eclipse.m2e.core.maven2Problem.pomloading");
            this.markerManager.addMarkers((IResource)pom, "org.eclipse.m2e.core.maven2Problem.pomloading", mavenResult);
            if (mavenProject == null || mavenProject.getArtifact() == null) continue;
            MavenProjectFacade mavenProjectFacade = new MavenProjectFacade(this, pom, mavenProject, iProjectConfiguration);
            this.putMavenProject(mavenProjectFacade, mavenProject);
            facadeMap.put(mavenProject, mavenProjectFacade);
        }
        for (MavenProject mp : this.getSortedProjects(facadeMap.keySet())) {
            MavenProjectFacade facade = (MavenProjectFacade)facadeMap.get(mp);
            map.put(facade.getPom(), facade);
        }
        return facades;
    }

    static class Context {
        final IProjectRegistry state;
        final IProjectConfiguration resolverConfiguration;
        final IFile pom;

        Context(IProjectRegistry state, IProjectConfiguration resolverConfiguration, IFile pom) {
            this.state = state;
            this.resolverConfiguration = resolverConfiguration;
            this.pom = pom;
        }
    }
}

