/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.grading.view.assessment;

import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.controller.ExerciseStats;
import edu.kit.kastel.eclipse.common.api.controller.IAssessmentController;
import edu.kit.kastel.eclipse.common.api.controller.IGradingSystemwideController;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.api.model.IRatingGroup;
import edu.kit.kastel.eclipse.common.api.util.Pair;
import edu.kit.kastel.eclipse.common.view.activator.CommonActivator;
import edu.kit.kastel.eclipse.common.view.languages.LanguageSettings;
import edu.kit.kastel.eclipse.common.view.marker.AssessmentMarkerView;
import edu.kit.kastel.eclipse.common.view.utilities.AssessmentUtilities;
import edu.kit.kastel.eclipse.common.view.utilities.JDTUtilities;
import edu.kit.kastel.eclipse.common.view.utilities.UIUtilities;
import edu.kit.kastel.eclipse.grading.view.activator.Activator;
import edu.kit.kastel.eclipse.grading.view.assessment.AssessmentTab;
import edu.kit.kastel.eclipse.grading.view.assessment.AutograderUtil;
import edu.kit.kastel.eclipse.grading.view.assessment.CustomButtonDialog;
import edu.kit.kastel.eclipse.grading.view.assessment.GradingTabComposite;
import edu.kit.kastel.eclipse.grading.view.assessment.ResultTab;
import edu.kit.kastel.eclipse.grading.view.commands.AddAnnotationCommandHandler;
import edu.kit.kastel.eclipse.grading.view.controllers.AssessmentViewController;
import edu.kit.kastel.eclipse.grading.view.listeners.AssessmentMarkerViewDoubleClickListener;
import edu.kit.kastel.eclipse.grading.view.listeners.KeyboardAwareMouseListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wb.swt.SWTResourceManager;
import org.osgi.framework.Version;

public class ArtemisGradingView
extends ViewPart {
    private static final String ADD_ANNOTATION_COMMAND = "edu.kit.kastel.eclipse.grading.assessment.keybindings.addAnnotation";
    private static final ILog LOG = Platform.getLog(ArtemisGradingView.class);
    private AssessmentViewController viewController = new AssessmentViewController();
    private Map<String, Group> ratingGroupViewElements = new HashMap<String, Group>();
    private Map<String, Button> mistakeButtons = new HashMap<String, Button>();
    private AssessmentTab assessmentTab;
    private GradingTabComposite gradingTabComposite;
    private Composite gradingButtonComposite;
    private ResultTab result;

    public ArtemisGradingView() {
        this.initializeAnnotationEditing();
        this.addListenerForMarkerDeletion();
        Activator.getDefault().getSystemwideController().addSubmissionBuildListener(this::openPackagesAndFiles);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        ICommandService commandService = (ICommandService)this.getSite().getService(ICommandService.class);
        Command command = commandService.getCommand(ADD_ANNOTATION_COMMAND);
        command.setHandler((IHandler)new AddAnnotationCommandHandler(this, this.viewController));
    }

    private void addListenerForMarkerDeletion() {
        AssessmentUtilities.getWorkspace().addResourceChangeListener(event -> Arrays.asList(event.findMarkerDeltas("edu.kit.kastel.eclipse.common.view.assessment.marker", true)).forEach(marker -> {
            if (marker.getKind() == 2) {
                this.viewController.deleteAnnotation((String)marker.getAttribute("annotationID"));
                this.updatePenalties();
            }
        }));
    }

    private void initializeAnnotationEditing() {
        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(AssessmentMarkerView.class.getName());
        if (view instanceof AssessmentMarkerView var2_3) {
            markerView.addDoubleClickListener((IDoubleClickListener)new AssessmentMarkerViewDoubleClickListener(this));
        }
    }

    private void addSelectionListenerForLoadFromBacklogButton(Combo backlogCombo, Button btnLoadAgain) {
        btnLoadAgain.addListener(13, e -> {
            if (backlogCombo.getSelectionIndex() < 0) {
                return;
            }
            this.viewController.setAssessedSubmission(backlogCombo.getItem(backlogCombo.getSelectionIndex()));
            this.viewController.onLoadAgain();
            this.prepareNewAssessment();
            this.updateState();
        });
    }

    private void addSelectionListenerForRefreshButton(Button refreshButton, Combo backlogCombo) {
        refreshButton.addListener(13, e -> this.fillBacklogComboWithData(backlogCombo));
    }

    private void addSelectionListenerForReloadButton(Button btnReloadA) {
        btnReloadA.addListener(13, e -> {
            this.viewController.onReloadAssessment();
            this.prepareNewAssessment();
            this.updateState();
        });
    }

    private void addSelectionListenerForSaveButton(Button btnSave) {
        btnSave.addListener(13, e -> {
            this.viewController.onSaveAssessment();
            this.updateState();
        });
    }

    private void addSelectionListenerForStartFirstRound(Button btnStartRound1) {
        btnStartRound1.addListener(13, e -> {
            boolean started = this.viewController.onStartCorrectionRound1();
            if (started) {
                this.prepareNewAssessment();
            }
            this.updateState();
        });
    }

    private void addSelectionListenerForStartSecondRound(Button btnStartRound2) {
        btnStartRound2.addListener(13, e -> {
            boolean started = this.viewController.onStartCorrectionRound2();
            if (started) {
                this.prepareNewAssessment();
            }
            this.updateState();
        });
    }

    private void addSelectionListenerForSubmitButton(Button btnSubmit) {
        btnSubmit.addListener(13, e -> {
            this.viewController.onSubmitAssessment();
            this.updateState();
            this.result.reset();
        });
    }

    private void createBacklog() {
        Combo backlogCombo = this.assessmentTab.comboBacklogSubmission;
        Button refreshButton = this.assessmentTab.btnBacklogRefreshSubmissions;
        Button btnLoadAgain = this.assessmentTab.btnBacklogLoadSubmission;
        this.addSelectionListenerForRefreshButton(refreshButton, backlogCombo);
        this.addSelectionListenerForLoadFromBacklogButton(backlogCombo, btnLoadAgain);
    }

    private void createResultTab(TabFolder tabFolder) {
        this.result = new ResultTab(Activator.getDefault().getSystemwideController(), tabFolder);
    }

    private void createCustomButton(IRatingGroup ratingGroup, Group rgDisplay, IMistakeType mistake) {
        Button customButton = new Button((Composite)rgDisplay, 8);
        customButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        customButton.setText(mistake.getButtonText(LanguageSettings.I18N().key()));
        customButton.addListener(13, event -> {
            CustomButtonDialog customDialog = new CustomButtonDialog(AssessmentUtilities.getWindowsShell(), this.isPositiveFeedbackAllowed(), this.viewController, mistake);
            customDialog.setBlockOnOpen(true);
            customDialog.open();
            Display.getDefault().asyncExec(() -> this.updatePenalty(ratingGroup.getIdentifier()));
        });
    }

    private void fillExamComboList(Combo courseCombo, Combo examCombo, Combo examExerciseCombo) {
        examCombo.removeAll();
        examExerciseCombo.removeAll();
        this.viewController.getExerciseShortNames(courseCombo.getItem(courseCombo.getSelectionIndex())).forEach(arg_0 -> ((Combo)examExerciseCombo).add(arg_0));
        examCombo.add("None");
        this.viewController.getExamShortNames(courseCombo.getItem(courseCombo.getSelectionIndex())).forEach(arg_0 -> ((Combo)examCombo).add(arg_0));
        examCombo.addListener(13, e -> {
            examExerciseCombo.removeAll();
            if ("None".equals(examCombo.getItem(examCombo.getSelectionIndex()))) {
                this.viewController.getExerciseShortNames(courseCombo.getItem(courseCombo.getSelectionIndex())).forEach(arg_0 -> ((Combo)examExerciseCombo).add(arg_0));
            } else {
                this.viewController.getExercisesShortNamesForExam(examCombo.getItem(examCombo.getSelectionIndex())).forEach(arg_0 -> ((Combo)examExerciseCombo).add(arg_0));
            }
            this.updateState();
        });
        examExerciseCombo.addListener(13, e -> {
            this.viewController.setExerciseId(examExerciseCombo.getItem(examExerciseCombo.getSelectionIndex()));
            this.updateState();
        });
    }

    private void createAssessmentTab(TabFolder tabFolder) {
        this.assessmentTab = new AssessmentTab(tabFolder);
        this.loadExamComboEntries(this.assessmentTab.comboCourse, this.assessmentTab.comboExam, this.assessmentTab.comboExercise);
        this.addSelectionListenerForReloadButton(this.assessmentTab.btnReload);
        this.addSelectionListenerForSaveButton(this.assessmentTab.btnSave);
        this.addSelectionListenerForStartFirstRound(this.assessmentTab.btnStartRoundOne);
        this.addSelectionListenerForStartSecondRound(this.assessmentTab.btnStartRoundTwo);
        this.addSelectionListenerForSubmitButton(this.assessmentTab.btnSubmit);
        this.addSelectionListenerForCloseAssessmentButton(this.assessmentTab.btnCloseAssessment);
        this.addSelectionListenerForRefreshArtemisStateButton(this.assessmentTab.btnResetPluginState);
        this.setVersionText(this.assessmentTab.lblPluginVersion);
        this.assessmentTab.btnHelp.addListener(13, e -> {});
    }

    private void setVersionText(Label label) {
        Version pluginVersion = Activator.getDefault().getBundle().getVersion();
        String versionText = String.format("Artemis Grading %d.%d.%d", pluginVersion.getMajor(), pluginVersion.getMinor(), pluginVersion.getMicro());
        label.setText(versionText);
    }

    private void addSelectionListenerForRefreshArtemisStateButton(Button btnRefreshArtemisState) {
        btnRefreshArtemisState.addListener(13, e -> this.refreshArtemisState());
    }

    private void addSelectionListenerForCloseAssessmentButton(Button btnCloseAssessment) {
        btnCloseAssessment.addListener(13, e -> {
            this.viewController.onCloseAssessment();
            this.updateState();
            this.result.reset();
        });
    }

    private void fillGradingTab() {
        if (this.gradingButtonComposite != null && !this.gradingButtonComposite.isDisposed()) {
            this.gradingButtonComposite.dispose();
        }
        ScrolledComposite container = this.gradingTabComposite.gradingCompositeContainerScrollable;
        this.gradingButtonComposite = new Composite((Composite)container, 0);
        this.viewController.setCurrentAssessmentController();
        this.gradingButtonComposite.setLayout((Layout)new GridLayout(1, true));
        this.viewController.getRatingGroups().forEach(ratingGroup -> {
            Group rgDisplay = new Group(this.gradingButtonComposite, 0);
            this.ratingGroupViewElements.put(ratingGroup.getIdentifier(), rgDisplay);
            this.updatePenalty(ratingGroup.getIdentifier());
            int columns = CommonActivator.getDefault().getPreferenceStore().getInt("grading_buttons_in_column");
            GridLayout gridLayout = new GridLayout(columns, true);
            rgDisplay.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(4, 0x1000000, true, false, 1, 1);
            rgDisplay.setLayoutData((Object)gridData);
            this.viewController.getMistakeTypes().forEach(mistake -> {
                if (mistake.getRatingGroup().equals(ratingGroup)) {
                    if (mistake.isCustomPenalty()) {
                        this.createCustomButton((IRatingGroup)ratingGroup, rgDisplay, (IMistakeType)mistake);
                        return;
                    }
                    Button mistakeButton = new Button((Composite)rgDisplay, 8);
                    mistakeButton.setText(mistake.getButtonText(LanguageSettings.I18N().key()));
                    mistakeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
                    mistakeButton.setEnabled(mistake.isEnabledMistakeType());
                    if (!mistake.isEnabledPenalty() && mistake.isEnabledMistakeType()) {
                        mistakeButton.addPaintListener(e -> mistakeButton.setForeground(SWTResourceManager.getColor((int)13)));
                    }
                    this.mistakeButtons.put(mistake.getIdentifier(), mistakeButton);
                    mistakeButton.setToolTipText(this.viewController.getToolTipForMistakeType(LanguageSettings.I18N().key(), (IMistakeType)mistake));
                    KeyboardAwareMouseListener listener = new KeyboardAwareMouseListener();
                    listener.setClickHandler(() -> AssessmentUtilities.createAssessmentAnnotation((IAssessmentController)this.viewController.getAssessmentController(), (IMistakeType)mistake, null, null), 524288);
                    listener.setClickHandler(() -> this.createMistakePenaltyWithCustomMessageDialog((IMistakeType)mistake), 131072, 0x100000);
                    listener.setClickHandlerForEveryClick(() -> {
                        this.updatePenalty(mistake.getRatingGroup().getIdentifier());
                        this.updateMistakeButtonToolTips((IMistakeType)mistake);
                    });
                    mistakeButton.addMouseListener((MouseListener)listener);
                }
            });
        });
        UIUtilities.initializeTabAfterFilling((Composite)container, (Composite)this.gradingButtonComposite);
    }

    public void createPartControl(Composite parent) {
        this.createView(parent);
    }

    private void createMistakePenaltyWithCustomMessageDialog(IMistakeType mistake) {
        CustomButtonDialog buttonDialog = new CustomButtonDialog(AssessmentUtilities.getWindowsShell(), this.isPositiveFeedbackAllowed(), this.viewController, null);
        buttonDialog.setBlockOnOpen(true);
        buttonDialog.open();
        if (buttonDialog.isClosedByOk()) {
            AssessmentUtilities.createAssessmentAnnotation((IAssessmentController)this.viewController.getAssessmentController(), (IMistakeType)mistake, (String)buttonDialog.getCustomMessage(), null);
        }
    }

    private void createView(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        this.createAssessmentTab(tabFolder);
        this.createGradingTab(tabFolder);
        this.createResultTab(tabFolder);
        this.createBacklog();
        this.updateState();
    }

    private void createGradingTab(TabFolder tabFolder) {
        this.gradingTabComposite = new GradingTabComposite(tabFolder);
        this.setVersionText(this.gradingTabComposite.lblPluginVersion);
    }

    private void fillBacklogComboWithData(Combo backlogCombo) {
        backlogCombo.removeAll();
        this.viewController.getSubmissionsForBacklog().forEach(arg_0 -> ((Combo)backlogCombo).add(arg_0));
    }

    private void loadExamComboEntries(Combo examCourseCombo, Combo examCombo, Combo examExerciseCombo) {
        this.viewController.getCourseShortNames().forEach(arg_0 -> ((Combo)examCourseCombo).add(arg_0));
        examCourseCombo.addListener(13, e -> {
            this.fillExamComboList(this.assessmentTab.comboCourse, examCombo, examExerciseCombo);
            this.updateState();
        });
    }

    private void prepareNewAssessment() {
        this.fillGradingTab();
        this.viewController.createAnnotationsMarkers();
        this.viewController.getRatingGroups().forEach(ratingGroup -> this.updatePenalty(ratingGroup.getIdentifier()));
        this.result.loadFeedbackForExcerise();
        AutograderUtil.runAutograder(this.viewController.getAssessmentController(), Activator.getDefault().getSystemwideController().getCurrentProjectPath().resolve("assignment").resolve("src"), success -> this.updatePenalties());
    }

    public void setFocus() {
    }

    private void updateMistakeButtonToolTips(IMistakeType mistakeType) {
        Button button = this.mistakeButtons.get(mistakeType.getIdentifier());
        if (button != null) {
            Display.getDefault().asyncExec(() -> button.setToolTipText(this.viewController.getToolTipForMistakeType(LanguageSettings.I18N().key(), mistakeType)));
        }
    }

    public void updatePenalties() {
        this.viewController.getRatingGroups().forEach(ratingGroup -> this.updatePenalty(ratingGroup.getIdentifier()));
        this.updateAllToolTips();
    }

    private void updateAllToolTips() {
        List<IMistakeType> mistakes = this.viewController.getMistakeTypes();
        for (IMistakeType mistake : mistakes) {
            this.updateMistakeButtonToolTips(mistake);
        }
    }

    private void updatePenalty(String ratingGroupId) {
        Group viewElement = this.ratingGroupViewElements.get(ratingGroupId);
        IRatingGroup ratingGroup = this.viewController.getRatingGroupById(ratingGroupId);
        if (ratingGroup == null) {
            return;
        }
        StringBuilder builder = new StringBuilder(ratingGroup.getDisplayName(LanguageSettings.I18N().key()));
        builder.append("(");
        builder.append(this.viewController.getAssessmentController().getCurrentPenaltyForRatingGroup(ratingGroup));
        Pair range = ratingGroup.getRange();
        if (!range.isEmpty()) {
            double lower = range.first() == null ? Double.NEGATIVE_INFINITY : (Double)range.first();
            double upper = range.second() == null ? Double.POSITIVE_INFINITY : (Double)range.second();
            builder.append(" in [").append(lower).append(",").append(upper).append("]");
        }
        builder.append(") penalty points");
        Display.getDefault().asyncExec(() -> viewElement.setText(builder.toString()));
    }

    private void updateState() {
        boolean secondCorrectionRound;
        boolean courseSelected = this.assessmentTab.comboCourse.getSelectionIndex() >= 0;
        boolean examSelected = this.assessmentTab.comboExam.getSelectionIndex() >= 0;
        boolean exerciseSelected = this.assessmentTab.comboExercise.getSelectionIndex() >= 0;
        boolean bl = secondCorrectionRound = courseSelected && examSelected && exerciseSelected;
        if (secondCorrectionRound) {
            Optional<IExercise> currentExercise = this.viewController.getSelectedExercise();
            secondCorrectionRound &= currentExercise.isPresent();
            secondCorrectionRound &= currentExercise.get().hasSecondCorrectionRound();
            secondCorrectionRound &= currentExercise.get().isSecondCorrectionEnabled();
        }
        boolean assessmentStarted = this.viewController.isAssessmentStarted();
        this.assessmentTab.setAssessmentInProgress(courseSelected, examSelected, exerciseSelected, assessmentStarted, secondCorrectionRound);
        this.updateCorrectedSubmissionCount();
    }

    private void updateCorrectedSubmissionCount() {
        if (this.assessmentTab.comboExercise.getSelectionIndex() != -1) {
            IGradingSystemwideController sc = Activator.getDefault().getSystemwideController();
            ExerciseStats stats = sc.getStats();
            this.assessmentTab.lblStatisticsInformation.setText(LanguageSettings.I18N().tabAssessmentStartedSubmitted(stats.totalAssessments(), stats.totalSubmissions(), stats.locked(), stats.submittedByTutor()));
        } else {
            this.assessmentTab.lblStatisticsInformation.setText("");
        }
    }

    private void refreshArtemisState() {
        this.viewController = new AssessmentViewController();
        Activator.getDefault().getSystemwideController().addSubmissionBuildListener(this::openPackagesAndFiles);
        this.result.setController(Activator.getDefault().getSystemwideController());
        this.result.reset();
        this.resetCombos();
        this.updateState();
    }

    private void resetCombos() {
        this.assessmentTab.resetCombos();
        this.viewController.getCourseShortNames().forEach(courseShortName -> this.assessmentTab.comboCourse.add(courseShortName));
    }

    private void openPackagesAndFiles(IProject project) {
        IWorkbenchPage page = this.getSite().getPage();
        try {
            Optional explorer = AssessmentUtilities.getProjectExplorer((IWorkbenchPage)page);
            List<IResource> packagePaths = JDTUtilities.getAllCompilationUnits((IProject)project).stream().map(IJavaElement::getResource).toList();
            Display.getDefault().asyncExec(() -> {
                explorer.ifPresent(e -> e.selectReveal((ISelection)new StructuredSelection(packagePaths)));
                explorer.ifPresent(e -> e.selectReveal((ISelection)new StructuredSelection()));
            });
            String openPreference = CommonActivator.getDefault().getPreferenceStore().getString("openFilesOnAssessmentStart");
            if ("all".equals(openPreference)) {
                JDTUtilities.getAllCompilationUnits((IProject)project).forEach(c -> AssessmentUtilities.openJavaElement((IJavaElement)c, (IWorkbenchPage)page));
            }
            if (!"none".equals(openPreference)) {
                Optional mainType = JDTUtilities.findMainClass((IProject)project);
                if (mainType.isPresent()) {
                    AssessmentUtilities.openJavaElement((IJavaElement)((IJavaElement)mainType.get()), (IWorkbenchPage)page);
                    Display.getDefault().asyncExec(() -> explorer.ifPresent(e -> e.selectReveal((ISelection)new StructuredSelection((Object)((IType)mainType.get()).getResource()))));
                } else {
                    LOG.warn("No main class found");
                }
            }
        }
        catch (JavaModelException e) {
            LOG.error("JDT failure", (Throwable)e);
        }
    }

    public boolean isPositiveFeedbackAllowed() {
        return this.viewController.getAssessmentController().isPositiveFeedbackAllowed();
    }
}

