/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.grading.view.assessment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.ISubmission;
import edu.kit.kastel.eclipse.common.api.controller.IAssessmentController;
import edu.kit.kastel.eclipse.common.api.model.IAnnotation;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.view.activator.CommonActivator;
import edu.kit.kastel.eclipse.common.view.utilities.AssessmentUtilities;
import edu.kit.kastel.eclipse.grading.view.activator.Activator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AutograderUtil {
    private static final ILog LOG = Platform.getLog(AutograderUtil.class);

    public static void runAutograder(IAssessmentController assessmentController, Path path, Consumer<Boolean> onCompletion) {
        if (!assessmentController.getAnnotations().isEmpty()) {
            LOG.info("Skipping autograder as there already annotation present");
            return;
        }
        Job.create((String)"Autograder", monitor -> {
            try {
                ISubmission submission = assessmentController.getSubmission();
                Map<String, String> config = AutograderUtil.getConfig();
                String autograderConfig = "[" + config.keySet().stream().collect(Collectors.joining(", ")) + "]";
                monitor.beginTask("Autograder", 8);
                monitor.subTask("Downloading Autograder JAR");
                LOG.info("Downloading autograder JAR");
                Path autograderJar = AutograderUtil.maybeDownloadAutograderRelease();
                monitor.worked(1);
                monitor.subTask("Running Autograder checks");
                ProcessBuilder processBuilder = new ProcessBuilder("java", "-DFile.Encoding=UTF-8", "-jar", autograderJar.toAbsolutePath().toString(), autograderConfig, path.toAbsolutePath().toString(), "--static-only", "--output-json", "--pass-config", "--java-version", "17");
                Process process = processBuilder.start();
                Scanner autograderOutput = new Scanner(process.getInputStream(), StandardCharsets.UTF_8);
                LOG.info("Autograder started");
                String problems = "[]";
                while (autograderOutput.hasNext() && process.isAlive()) {
                    String line = autograderOutput.nextLine();
                    if (line.equals(">> Problems <<")) {
                        problems = autograderOutput.nextLine();
                        continue;
                    }
                    monitor.worked(1);
                }
                monitor.setTaskName("Parsing annotations");
                String errorOutput = new String(process.getErrorStream().readAllBytes());
                if (!errorOutput.isBlank()) {
                    LOG.error("Autograder failed: " + errorOutput);
                    onCompletion.accept(false);
                    Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)AssessmentUtilities.getWindowsShell(), (String)"Autograder failed", (String)"Autograder failed. Please assess the submission normally. Additional information can be found in the Eclipse log"));
                } else if (assessmentController.getSubmission().getSubmissionId() != submission.getSubmissionId()) {
                    Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)AssessmentUtilities.getWindowsShell(), (String)"Submission changed", (String)"Autograder completed successfully, but the current submission has changed during analysis, so no annotations will be created."));
                } else {
                    LOG.info("Autograder completed successfully");
                    List<AutograderAnnotation> annotations = Arrays.asList((AutograderAnnotation[])new ObjectMapper().readValue(problems, AutograderAnnotation[].class));
                    for (AutograderAnnotation annotation : annotations) {
                        Optional<IMistakeType> type = AutograderUtil.mapAnnotation(assessmentController, annotation, config);
                        if (type.isPresent()) {
                            String id = IAnnotation.createID();
                            assessmentController.addAnnotation(id, type.get(), annotation.startLine() - 1, annotation.endLine() - 1, "src/" + annotation.file(), annotation.message(), type.get().isCustomPenalty() ? Double.valueOf(0.0) : null);
                            AssessmentUtilities.createMarkerByAnnotation((IAnnotation)((IAnnotation)assessmentController.getAnnotationById(id).get()), (String)Activator.getDefault().getSystemwideController().getCurrentProjectName(), (String)"assignment/");
                            continue;
                        }
                        LOG.warn("No mistake type found for autograder annotation type " + annotation.type());
                    }
                    onCompletion.accept(true);
                    monitor.done();
                    Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)AssessmentUtilities.getWindowsShell(), (String)"Autograder succeeded", (String)String.format("Autograder found %d issues. Please check that there are no false-positives.", annotations.size())));
                }
            }
            catch (Exception ex) {
                LOG.error("Autograder failed: " + ex.getMessage(), (Throwable)ex);
                Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)AssessmentUtilities.getWindowsShell(), (String)"Autograder failed", (String)"Autograder failed. Please assess the submission normally. Additional information can be found in the Eclipse log"));
            }
        }).schedule();
    }

    public static Path maybeDownloadAutograderRelease() throws IOException {
        if (!CommonActivator.getDefault().getPreferenceStore().getBoolean("autograderDownloadJar")) {
            return Path.of(CommonActivator.getDefault().getPreferenceStore().getString("autograderJarPath"), new String[0]);
        }
        URLConnection connection = new URL("https://github.com/Feuermagier/autograder/releases/latest").openConnection();
        connection.connect();
        InputStream inputStream = connection.getInputStream();
        String[] components = connection.getURL().getFile().split("/");
        String tag = components[components.length - 1];
        inputStream.close();
        Path existingJAR = Path.of(CommonActivator.getDefault().getPreferenceStore().getString("autograderDownloadedJarPath"), new String[0]);
        if (!Files.exists(existingJAR, new LinkOption[0]) || !existingJAR.getFileName().toString().startsWith(tag)) {
            Files.deleteIfExists(existingJAR);
            Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)AssessmentUtilities.getWindowsShell(), (String)"Downloading Autograder", (String)("Downloading Autograder " + tag + ". This may take a moment. You can safely close this window.")));
            existingJAR = AutograderUtil.downloadAutograderRelease(tag);
        } else {
            LOG.info("Skipping autograder JAR download as most recent one is already present at " + existingJAR.toAbsolutePath().toString());
        }
        return existingJAR;
    }

    private static Path downloadAutograderRelease(String version) {
        try {
            Path targetPath = Files.createTempFile(String.valueOf(version) + "_autograder_jar", ".jar", new FileAttribute[0]);
            LOG.info("Downloading autograder JAR with version/tag " + version + " to " + targetPath.toAbsolutePath().toString());
            Files.deleteIfExists(targetPath);
            Files.createFile(targetPath, new FileAttribute[0]);
            URL url = new URL("https://github.com/Feuermagier/autograder/releases/latest/download/autograder-cmd.jar");
            ReadableByteChannel channel = Channels.newChannel(url.openStream());
            FileOutputStream outStream = new FileOutputStream(targetPath.toFile());
            outStream.getChannel().transferFrom(channel, 0L, Long.MAX_VALUE);
            CommonActivator.getDefault().getPreferenceStore().setValue("autograderDownloadedJarPath", targetPath.toAbsolutePath().toString());
            return targetPath;
        }
        catch (IOException e) {
            LOG.error("Failed to download the autograder JAR", (Throwable)e);
            return null;
        }
    }

    private static Optional<IMistakeType> mapAnnotation(IAssessmentController assessmentController, AutograderAnnotation annotation, Map<String, String> config) {
        String id = config.get(annotation.type());
        return assessmentController.getMistakes().stream().filter(m -> m.getIdentifier().equals(id)).findAny().or(() -> assessmentController.getMistakes().stream().filter(m -> m.getIdentifier().equals("custom")).findAny());
    }

    public static Map<String, String> getConfig() throws IOException {
        Path autograderConfigPath = Path.of(CommonActivator.getDefault().getPreferenceStore().getString("autograderConfigPath"), new String[0]);
        return (Map)new ObjectMapper().readValue(Files.readString(autograderConfigPath), (TypeReference)new TypeReference<Map<String, String>>(){});
    }

    public record AutograderAnnotation(String type, String message, String file, int startLine, int endLine) {
    }
}

