/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.grading.view.assessment;

import edu.kit.kastel.eclipse.common.api.controller.IAssessmentController;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.view.activator.CommonActivator;
import edu.kit.kastel.eclipse.common.view.utilities.AssessmentUtilities;
import edu.kit.kastel.eclipse.grading.view.controllers.AssessmentViewController;
import java.util.Objects;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class CustomButtonDialog
extends Dialog {
    private static final int CUSTOM_PENALTY_FIELD_WIDTH_MULTIPLIER = 24;
    private static final int CUSTOM_PENALTY_FIELD_HEIGHT_MULTIPLIER = 8;
    private Text customMessageInputField;
    private Spinner customPointsInputField;
    private boolean closedByOk;
    private boolean forcePenaltyField;
    private final AssessmentViewController viewController;
    private final boolean allowPositiveFeedback;
    private String customMessage;
    private Double customPoints;
    private IMistakeType customMistake;

    public CustomButtonDialog(Shell parentShell, boolean allowPositiveFeedback, AssessmentViewController viewController, IMistakeType mistake) {
        super(parentShell);
        this.viewController = viewController;
        this.customMistake = mistake;
        this.allowPositiveFeedback = allowPositiveFeedback;
    }

    protected void cancelPressed() {
        this.customMessageInputField.setText("");
        super.cancelPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create custom penalty");
    }

    protected Control createDialogArea(Composite parent) {
        GridData customMessageInputFieldData;
        Composite comp = (Composite)super.createDialogArea(parent);
        boolean userWantsBigWindow = CommonActivator.getDefault().getPreferenceStore().getBoolean("userPreferresLargePenaltyText");
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.numColumns = userWantsBigWindow ? 1 : 2;
        Label customMessageLabel = new Label(comp, 131072);
        customMessageLabel.setText("Custom Message: ");
        GridData data = new GridData(4, 0x1000000, true, false);
        if (userWantsBigWindow) {
            int textWrapping = CommonActivator.getDefault().getPreferenceStore().getBoolean("userPrefersTextWrappingInPenaltyText") ? 64 : 0;
            this.customMessageInputField = new Text(comp, 0xB02 | textWrapping);
            customMessageInputFieldData = new GridData(1808);
            customMessageInputFieldData.minimumHeight = this.customMessageInputField.getLineHeight() * 8;
            customMessageInputFieldData.minimumWidth = this.customMessageInputField.getLineHeight() * 24;
            this.customMessageInputField.addKeyListener((KeyListener)new MultiLineTextEditorKeyListener(this));
        } else {
            this.customMessageInputField = new Text(comp, 2052);
            customMessageInputFieldData = data;
        }
        this.customMessageInputField.setLayoutData((Object)customMessageInputFieldData);
        this.customMessageInputField.setText(Objects.requireNonNullElse(this.customMessage, ""));
        if (this.customMistake != null || this.forcePenaltyField) {
            Label customPenaltyLabel = new Label(comp, 131072);
            customPenaltyLabel.setText("Custom Points: ");
            this.customPointsInputField = new Spinner(comp, 2052);
            this.customPointsInputField.setDigits(1);
            this.customPointsInputField.setIncrement(5);
            this.customPointsInputField.setLayoutData((Object)data);
            this.customPointsInputField.setMinimum(Integer.MIN_VALUE);
            if (this.allowPositiveFeedback) {
                this.customPointsInputField.setMaximum(Integer.MAX_VALUE);
            } else {
                this.customPointsInputField.setMaximum(0);
            }
            this.customPointsInputField.addModifyListener(e -> {
                if (this.customPointsInputField.getSelection() == 0) {
                    this.customPointsInputField.setForeground(SWTResourceManager.getColor((int)2));
                    this.customMessageInputField.setForeground(SWTResourceManager.getColor((int)2));
                }
                if (this.customPointsInputField.getSelection() > 0) {
                    this.customPointsInputField.setForeground(SWTResourceManager.getColor((int)6));
                    this.customMessageInputField.setForeground(SWTResourceManager.getColor((int)6));
                }
                if (this.customPointsInputField.getSelection() < 0) {
                    this.customPointsInputField.setForeground(SWTResourceManager.getColor((int)3));
                    this.customMessageInputField.setForeground(SWTResourceManager.getColor((int)3));
                }
            });
            this.customPointsInputField.setSelection((int)(Objects.requireNonNullElse(this.customPoints, 0.0) * 10.0));
        }
        return comp;
    }

    public void setForcePenaltyField(boolean forcePenaltyField) {
        this.forcePenaltyField = forcePenaltyField;
    }

    public void setCustomMessage(String customMessage) {
        this.customMessage = customMessage;
        if (this.customMessageInputField != null) {
            this.customMessageInputField.setText(this.customMessage);
        }
    }

    public String getCustomMessage() {
        return this.isClosedByOk() ? this.customMessage : null;
    }

    public void setCustomPoints(Double customPoints) {
        this.customPoints = customPoints;
        if (this.customPointsInputField != null) {
            this.customPointsInputField.setSelection((int)(customPoints * 10.0));
        }
    }

    public Double getCustomPoints() {
        return this.customPoints;
    }

    protected void okPressed() {
        this.closedByOk = true;
        this.customMessage = this.customMessageInputField.getText();
        if (this.customPointsInputField != null) {
            this.customPoints = Double.parseDouble(this.customPointsInputField.getText().replace(',', '.'));
            if (this.customMistake != null) {
                AssessmentUtilities.createAssessmentAnnotation((IAssessmentController)this.viewController.getAssessmentController(), (IMistakeType)this.customMistake, (String)this.customMessage, (Double)this.customPoints);
            }
        }
        super.okPressed();
    }

    public boolean isClosedByOk() {
        return this.closedByOk;
    }

    private static class MultiLineTextEditorKeyListener
    implements KeyListener {
        private static final int LINE_SEPARATOR_LENGTH = System.lineSeparator().length();
        private boolean isShiftPressed;
        private final CustomButtonDialog customButtonDialog;

        public MultiLineTextEditorKeyListener(CustomButtonDialog customButtonDialog) {
            this.customButtonDialog = customButtonDialog;
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 131072) {
                this.isShiftPressed = false;
            }
            if (!this.isShiftPressed && (e.keyCode == 9 || this.isReturnCharacter(e.keyCode))) {
                int insertedLength = this.isReturnCharacter(e.keyCode) ? LINE_SEPARATOR_LENGTH : 1;
                int pos = this.customButtonDialog.customMessageInputField.getCaretPosition();
                String text = this.customButtonDialog.customMessageInputField.getText();
                String modified = String.valueOf(text.substring(0, pos - insertedLength)) + text.substring(pos);
                this.customButtonDialog.customMessageInputField.setText(modified);
                if (this.isReturnCharacter(e.keyCode)) {
                    this.customButtonDialog.okPressed();
                } else {
                    this.customButtonDialog.customPointsInputField.setFocus();
                }
            }
        }

        private boolean isReturnCharacter(int keyCode) {
            return keyCode == 13 || keyCode == 10;
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 131072) {
                this.isShiftPressed = true;
            }
        }
    }
}

