/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.grading.view.commands;

import edu.kit.kastel.eclipse.common.api.controller.IAssessmentController;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.view.languages.LanguageSettings;
import edu.kit.kastel.eclipse.common.view.utilities.AssessmentUtilities;
import edu.kit.kastel.eclipse.grading.view.activator.Activator;
import edu.kit.kastel.eclipse.grading.view.assessment.ArtemisGradingView;
import edu.kit.kastel.eclipse.grading.view.assessment.CustomButtonDialog;
import edu.kit.kastel.eclipse.grading.view.commands.AddAnnotationDialog;
import edu.kit.kastel.eclipse.grading.view.controllers.AssessmentViewController;
import java.lang.reflect.Method;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class AddAnnotationCommandHandler
extends AbstractHandler {
    private static final int DIALOG_OFFSET_X = 10;
    private final AssessmentViewController controller;
    private final ArtemisGradingView view;

    public AddAnnotationCommandHandler(ArtemisGradingView view, AssessmentViewController controller) {
        this.controller = controller;
        this.view = view;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IAssessmentController assessment = Activator.getDefault().getSystemwideController().getCurrentAssessmentController();
        if (assessment == null) {
            Platform.getLog(((Object)((Object)this)).getClass()).warn("Not executing the Add Annotation command because the assessment is null");
            return null;
        }
        AddAnnotationDialog dialog = new AddAnnotationDialog(AssessmentUtilities.getWindowsShell(), assessment);
        dialog.setBlockOnOpen(true);
        dialog.create();
        Point dialogPosition = this.getCaretPosition();
        dialogPosition.x += 10;
        dialogPosition.y += this.getLineHeight();
        dialog.getShell().setLocation(dialogPosition);
        dialog.open();
        Optional<IMistakeType> selectedMistake = dialog.getSelectedMistake();
        if (selectedMistake.isPresent()) {
            if (selectedMistake.get().isCustomPenalty()) {
                CustomButtonDialog customDialog = new CustomButtonDialog(AssessmentUtilities.getWindowsShell(), assessment.isPositiveFeedbackAllowed(), this.controller, selectedMistake.get());
                customDialog.setBlockOnOpen(true);
                customDialog.create();
                customDialog.getShell().setLocation(dialogPosition);
                customDialog.open();
            } else if (dialog.isCustomMessageWanted()) {
                CustomButtonDialog customDialog = new CustomButtonDialog(AssessmentUtilities.getWindowsShell(), assessment.isPositiveFeedbackAllowed(), this.controller, null);
                customDialog.setBlockOnOpen(true);
                customDialog.create();
                customDialog.getShell().setLocation(dialogPosition);
                customDialog.getShell().setText("Add custom message to penalty \"" + selectedMistake.get().getButtonText(LanguageSettings.I18N().key()) + "\"");
                customDialog.open();
                if (customDialog.isClosedByOk()) {
                    AssessmentUtilities.createAssessmentAnnotation((IAssessmentController)assessment, (IMistakeType)selectedMistake.get(), (String)customDialog.getCustomMessage(), null);
                }
            } else {
                AssessmentUtilities.createAssessmentAnnotation((IAssessmentController)assessment, (IMistakeType)selectedMistake.get(), null, null);
            }
            this.view.updatePenalties();
        }
        if (event.getTrigger() != null) {
            ((Event)event.getTrigger()).doit = false;
        }
        AssessmentUtilities.getActiveEditor().setFocus();
        return null;
    }

    private ISourceViewer getActiveSourceViewer() {
        try {
            Method method = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            method.setAccessible(true);
            return (ISourceViewer)method.invoke((Object)AssessmentUtilities.getActiveEditor(), new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error("Failed to obtain the source viewer", (Throwable)e);
            return null;
        }
    }

    private Point getCaretPosition() {
        ISourceViewer viewer = this.getActiveSourceViewer();
        int caret = viewer.getTextWidget().getCaretOffset();
        return viewer.getTextWidget().toDisplay(viewer.getTextWidget().getLocationAtOffset(caret));
    }

    private int getLineHeight() {
        ISourceViewer viewer = this.getActiveSourceViewer();
        return viewer.getTextWidget().getLineHeight();
    }
}

