/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.grading.view.commands;

import edu.kit.kastel.eclipse.common.api.controller.IAssessmentController;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.view.languages.LanguageSettings;
import edu.kit.kastel.eclipse.grading.view.commands.AnnotationFilter;
import java.util.Optional;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddAnnotationDialog
extends Dialog {
    private static final int LIST_HEIGHT = 200;
    private static final int LIST_WIDTH = 400;
    private final IAssessmentController controller;
    private TableViewer displayList;
    private AnnotationFilter filter;
    private IMistakeType selectedMistake;
    private boolean customMessageWanted;

    public AddAnnotationDialog(Shell parentShell, IAssessmentController controller) {
        super(parentShell);
        this.controller = controller;
    }

    public Optional<IMistakeType> getSelectedMistake() {
        return Optional.ofNullable(this.selectedMistake);
    }

    public boolean isCustomMessageWanted() {
        return this.customMessageWanted;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.createSearchField(container);
        this.createAnnotationList(container);
        return container;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Add Annotation");
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected boolean isResizable() {
        return true;
    }

    private void updateDisplayList(String filter) {
        this.filter.setFilterString(filter);
        this.displayList.refresh();
        this.displayList.getTable().setSelection(0);
    }

    private void createSearchField(Composite container) {
        Text inputField = new Text(container, 2052);
        inputField.addTraverseListener(e -> {
            if (e.detail == 4) {
                this.processMistakeSelection(this.isShiftPressed(e.stateMask));
                this.okPressed();
            } else if (e.detail == 2) {
                this.cancelPressed();
            }
        });
        inputField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int index = AddAnnotationDialog.this.displayList.getTable().getSelectionIndex();
                if (e.keyCode == 0x1000002) {
                    AddAnnotationDialog.this.displayList.getTable().select(index + 1);
                    AddAnnotationDialog.this.displayList.getTable().showSelection();
                    e.doit = false;
                } else if (e.keyCode == 0x1000001) {
                    AddAnnotationDialog.this.displayList.getTable().select(index - 1);
                    AddAnnotationDialog.this.displayList.getTable().showSelection();
                    e.doit = false;
                }
            }
        });
        inputField.addModifyListener(e -> this.updateDisplayList(inputField.getText()));
        inputField.setFocus();
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        inputField.setLayoutData((Object)gridData);
    }

    private void createAnnotationList(Composite container) {
        this.displayList = new TableViewer(container, 772);
        this.displayList.getTable().setHeaderVisible(false);
        this.displayList.getTable().setLinesVisible(false);
        this.displayList.setLabelProvider((IBaseLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                IMistakeType mistake = (IMistakeType)cell.getElement();
                cell.setText(String.valueOf(mistake.getButtonText(LanguageSettings.I18N().key())) + " " + mistake.getMessage(LanguageSettings.I18N().key()));
                StyleRange style = new StyleRange(0, mistake.getButtonText(LanguageSettings.I18N().key()).length(), null, null);
                style.fontStyle = 1;
                cell.setStyleRanges(new StyleRange[]{style});
            }
        });
        this.displayList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.displayList.setInput((Object)this.controller.getMistakes());
        this.displayList.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddAnnotationDialog.this.processMistakeSelection(AddAnnotationDialog.this.isShiftPressed(e.stateMask));
                AddAnnotationDialog.this.close();
            }
        });
        this.filter = new AnnotationFilter();
        this.displayList.addFilter((ViewerFilter)this.filter);
        this.displayList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((IMistakeType)e1).getButtonText(LanguageSettings.I18N().key()).compareTo(((IMistakeType)e2).getButtonText(LanguageSettings.I18N().key()));
            }
        });
        this.updateDisplayList("");
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 200;
        gridData.widthHint = 400;
        gridData.horizontalAlignment = 4;
        this.displayList.getControl().setLayoutData((Object)gridData);
    }

    private void processMistakeSelection(boolean customText) {
        IMistakeType mistake = (IMistakeType)this.displayList.getStructuredSelection().getFirstElement();
        if (mistake != null) {
            this.selectedMistake = mistake;
            this.customMessageWanted = customText;
        }
    }

    private boolean isShiftPressed(int stateMask) {
        return (stateMask & SWT.MOD2) != 0;
    }
}

