/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.grading.view.controllers;

import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.artemis.mapping.IExercise;
import edu.kit.kastel.eclipse.common.api.controller.IAssessmentController;
import edu.kit.kastel.eclipse.common.api.controller.IGradingSystemwideController;
import edu.kit.kastel.eclipse.common.api.controller.ISystemwideController;
import edu.kit.kastel.eclipse.common.api.model.IAnnotation;
import edu.kit.kastel.eclipse.common.api.model.IMistakeType;
import edu.kit.kastel.eclipse.common.api.model.IRatingGroup;
import edu.kit.kastel.eclipse.common.view.controllers.AbstractArtemisViewController;
import edu.kit.kastel.eclipse.common.view.utilities.AssessmentUtilities;
import edu.kit.kastel.eclipse.grading.view.activator.Activator;
import java.util.List;
import java.util.Optional;

public class AssessmentViewController
extends AbstractArtemisViewController<IGradingSystemwideController> {
    private IAssessmentController assessmentController;

    public AssessmentViewController() {
        super((ISystemwideController)Activator.getDefault().createNewSystemwideController());
        this.initializeControllersAndObserver();
    }

    public void createAnnotationsMarkers() {
        this.getAnnotations().stream().filter(annotation -> AssessmentUtilities.findPresentAnnotation((IAnnotation)annotation, (String)((IGradingSystemwideController)this.systemwideController).getCurrentProjectName(), (String)"assignment/") == null).forEach(annatoation -> {
            try {
                AssessmentUtilities.createMarkerByAnnotation((IAnnotation)annatoation, (String)((IGradingSystemwideController)this.systemwideController).getCurrentProjectName(), (String)"assignment/");
            }
            catch (ArtemisClientException e) {
                this.viewObserver.error("Unable to create marker for annotation", (Throwable)e);
            }
        });
    }

    public void deleteAnnotation(String id) {
        if (this.assessmentController != null) {
            this.assessmentController.removeAnnotation(id);
        }
    }

    public List<IAnnotation> getAnnotations() {
        return this.assessmentController.getAnnotations();
    }

    public List<IMistakeType> getMistakeTypes() {
        return this.assessmentController.getMistakes();
    }

    public IRatingGroup getRatingGroupById(String id) {
        return this.assessmentController.getRatingGroupById(id);
    }

    public List<IRatingGroup> getRatingGroups() {
        return this.assessmentController.getRatingGroups();
    }

    public List<String> getSubmissionsForBacklog() {
        return ((IGradingSystemwideController)this.systemwideController).getBegunSubmissionsProjectNames();
    }

    public String getToolTipForMistakeType(String languageKey, IMistakeType mistakeType) {
        return this.assessmentController.getTooltipForMistakeType(languageKey, mistakeType);
    }

    public void onLoadAgain() {
        ((IGradingSystemwideController)this.systemwideController).loadAgain();
    }

    public void onReloadAssessment() {
        ((IGradingSystemwideController)this.systemwideController).reloadAssessment();
    }

    public void onSaveAssessment() {
        ((IGradingSystemwideController)this.systemwideController).saveAssessment();
    }

    public boolean onStartCorrectionRound1() {
        return ((IGradingSystemwideController)this.systemwideController).startCorrectionRound1();
    }

    public boolean onStartCorrectionRound2() {
        return ((IGradingSystemwideController)this.systemwideController).startCorrectionRound2();
    }

    public void onSubmitAssessment() {
        ((IGradingSystemwideController)this.systemwideController).submitAssessment();
    }

    public void onCloseAssessment() {
        ((IGradingSystemwideController)this.systemwideController).closeAssessment();
    }

    public void setAssessedSubmission(String projectName) {
        ((IGradingSystemwideController)this.systemwideController).setAssessedSubmissionByProjectName(projectName);
    }

    public void setCurrentAssessmentController() {
        this.assessmentController = ((IGradingSystemwideController)this.systemwideController).getCurrentAssessmentController();
    }

    public IAssessmentController getAssessmentController() {
        return this.assessmentController;
    }

    public boolean isAssessmentStarted() {
        return ((IGradingSystemwideController)this.systemwideController).isAssessmentStarted();
    }

    public Optional<IExercise> getSelectedExercise() {
        return ((IGradingSystemwideController)this.systemwideController).getSelectedExercise();
    }
}

