/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.kastel.eclipse.grading.view.listeners;

import edu.kit.kastel.eclipse.common.api.ArtemisClientException;
import edu.kit.kastel.eclipse.common.api.model.IAnnotation;
import edu.kit.kastel.eclipse.common.view.utilities.AssessmentUtilities;
import edu.kit.kastel.eclipse.grading.view.activator.Activator;
import edu.kit.kastel.eclipse.grading.view.assessment.ArtemisGradingView;
import edu.kit.kastel.eclipse.grading.view.assessment.CustomButtonDialog;
import java.util.NoSuchElementException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.views.markers.MarkerItem;

public class AssessmentMarkerViewDoubleClickListener
implements IDoubleClickListener {
    private ArtemisGradingView gradingView;

    public AssessmentMarkerViewDoubleClickListener(ArtemisGradingView gradingView) {
        this.gradingView = gradingView;
    }

    /*
     * WARNING - void declaration
     */
    public void doubleClick(DoubleClickEvent event) {
        MarkerItem markerItem;
        void selection;
        Object object;
        if (event.getSelection().isEmpty()) {
            return;
        }
        ISelection iSelection = event.getSelection();
        if (iSelection instanceof TreeSelection var2_3 && (object = selection.getFirstElement()) instanceof MarkerItem && (markerItem = (MarkerItem)object) == (MarkerItem)object) {
            try {
                void item;
                IAnnotation annotation = (IAnnotation)Activator.getDefault().getSystemwideController().getCurrentAssessmentController().getAnnotationById(item.getMarker().getAttribute("annotationID").toString()).orElseThrow(() -> new NoSuchElementException("Could not find annotation. Please create it again."));
                String customMessage = annotation.getCustomMessage().orElse("");
                CustomButtonDialog dialog = new CustomButtonDialog(AssessmentUtilities.getWindowsShell(), this.gradingView.isPositiveFeedbackAllowed(), null, null);
                if (annotation.getMistakeType().isCustomPenalty()) {
                    dialog.setCustomPoints(annotation.getCustomPenalty().orElse(null));
                    dialog.setForcePenaltyField(true);
                }
                dialog.setCustomMessage(customMessage);
                dialog.setBlockOnOpen(true);
                dialog.open();
                if (!dialog.isClosedByOk()) {
                    return;
                }
                String newMessage = dialog.getCustomMessage();
                Double newPenalty = annotation.getMistakeType().isCustomPenalty() ? dialog.getCustomPoints() : (Double)annotation.getCustomPenalty().orElse(null);
                AssessmentUtilities.updateMarkerMessage((IMarker)item.getMarker(), (String)newMessage, (Double)newPenalty);
                Activator.getDefault().getSystemwideController().getCurrentAssessmentController().modifyAnnotation(annotation.getUUID(), newMessage, newPenalty);
                this.gradingView.updatePenalties();
            }
            catch (ArtemisClientException | CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

