/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core;

import net.sf.eclipsecs.core.util.CheckstyleLog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class CheckstylePluginPrefs
extends AbstractPreferenceInitializer {
    public static final String PREF_INCLUDE_RULE_NAMES = "include.rule.names";
    public static final String PREF_INCLUDE_MODULE_IDS = "include.module.ids";
    public static final String PREF_LIMIT_MARKERS_PER_RESOURCE = "limit.markers.per.resource";
    public static final String PREF_MARKER_AMOUNT_LIMIT = "marker.amount.limit";
    public static final String PREF_BACKGROUND_FULL_BUILD = "background.full.build";
    public static final int MARKER_LIMIT = 100;
    public static final String PREF_LOCALE_LANGUAGE = "checkstyle_rule_language";

    public void initializeDefaultPreferences() {
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode("net.sf.eclipsecs.core");
        prefs.putBoolean(PREF_INCLUDE_RULE_NAMES, false);
        prefs.putBoolean(PREF_INCLUDE_MODULE_IDS, false);
        prefs.putBoolean(PREF_LIMIT_MARKERS_PER_RESOURCE, false);
        prefs.putInt(PREF_MARKER_AMOUNT_LIMIT, 100);
        prefs.putBoolean(PREF_BACKGROUND_FULL_BUILD, false);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            CheckstyleLog.log(ex);
        }
    }

    public static String getString(String prefId) {
        IPreferencesService prefs = Platform.getPreferencesService();
        return prefs.getString("net.sf.eclipsecs.core", prefId, null, null);
    }

    public static boolean getBoolean(String prefId) {
        IPreferencesService prefs = Platform.getPreferencesService();
        return prefs.getBoolean("net.sf.eclipsecs.core", prefId, false, null);
    }

    public static int getInt(String prefId) {
        IPreferencesService prefs = Platform.getPreferencesService();
        return prefs.getInt("net.sf.eclipsecs.core", prefId, 0, null);
    }

    public static void setString(String prefId, String value) throws BackingStoreException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("net.sf.eclipsecs.core");
        prefs.put(prefId, value);
        prefs.flush();
    }

    public static void setBoolean(String prefId, boolean value) throws BackingStoreException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("net.sf.eclipsecs.core");
        prefs.putBoolean(prefId, value);
        prefs.flush();
    }

    public static void setInt(String prefId, int value) throws BackingStoreException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("net.sf.eclipsecs.core");
        prefs.putInt(prefId, value);
        prefs.flush();
    }
}

