/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.builder;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.eclipsecs.core.CheckstylePluginPrefs;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.builder.CheckerFactory;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.Module;
import net.sf.eclipsecs.core.config.meta.MetadataFactory;
import net.sf.eclipsecs.core.config.meta.RuleMetadata;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;

public class Auditor {
    private static final int MONITOR_INTERVAL = 10;
    private final ICheckConfiguration mCheckConfiguration;
    private final Map<String, IFile> mFiles = new HashMap<String, IFile>();
    private final ITextFileBufferManager mFileBufferManager = FileBuffers.getTextFileBufferManager();
    private IProgressMonitor mMonitor;
    private boolean mAddRuleName = false;
    private boolean mAddModuleId = false;

    public Auditor(ICheckConfiguration checkConfiguration) {
        this.mCheckConfiguration = checkConfiguration;
        this.mAddRuleName = CheckstylePluginPrefs.getBoolean("include.rule.names");
        this.mAddModuleId = CheckstylePluginPrefs.getBoolean("include.module.ids");
    }

    public void runAudit(IProject project, IProgressMonitor monitor) throws CheckstylePluginException {
        if (project == null || this.mFiles.isEmpty()) {
            return;
        }
        this.mMonitor = monitor;
        Checker checker = null;
        CheckstyleAuditListener listener = null;
        try {
            try {
                List<File> filesToAudit = this.getFilesList();
                monitor.beginTask(NLS.bind((String)Messages.Auditor_msgCheckingConfig, (Object)this.mCheckConfiguration.getName()), filesToAudit.size());
                checker = CheckerFactory.createChecker(this.mCheckConfiguration, project);
                listener = new CheckstyleAuditListener(project);
                checker.addListener((AuditListener)listener);
                checker.process(filesToAudit);
            }
            catch (CheckstyleException ex) {
                if (!(ex.getCause() instanceof OperationCanceledException)) {
                    this.handleCheckstyleFailure(project, ex);
                }
                monitor.done();
                if (checker != null) {
                    checker.removeListener((AuditListener)listener);
                }
            }
            catch (RuntimeException ex) {
                if (listener != null) {
                    listener.cleanup();
                }
                throw ex;
            }
        }
        finally {
            monitor.done();
            if (checker != null) {
                checker.removeListener((AuditListener)listener);
            }
        }
    }

    private void handleCheckstyleFailure(IProject project, CheckstyleException error) throws CheckstylePluginException {
        try {
            CheckstyleLog.log(error);
            project.deleteMarkers("net.sf.eclipsecs.core.CheckstyleMarker", false, 0);
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("priority", 1);
            attrs.put("severity", 2);
            attrs.put("message", NLS.bind((String)Messages.Auditor_msgMsgCheckstyleInternalError, null));
            IMarker projectMarker = project.createMarker("net.sf.eclipsecs.core.CheckstyleMarker");
            projectMarker.setAttributes(attrs);
        }
        catch (CoreException nested) {
            CheckstylePluginException.rethrow(error);
        }
    }

    public void addFile(IFile file) {
        this.mFiles.put(file.getLocation().toString(), file);
    }

    private IFile getFile(String fileName) {
        return this.mFiles.get(new Path(fileName).toString());
    }

    private List<File> getFilesList() {
        ArrayList<File> files = new ArrayList<File>();
        for (IFile file : this.mFiles.values()) {
            files.add(file.getLocation().toFile());
        }
        return files;
    }

    private class CheckstyleAuditListener
    implements AuditListener {
        private final IProject mProject;
        private final Map<String, Object> mMarkerAttributes = new HashMap<String, Object>();
        private final boolean mLimitMarkers;
        private final int mMarkerLimit;
        private IResource mResource;
        private IDocument mDocument;
        private int mMonitorCounter;
        private int mMarkerCount;
        private Set<IPath> mConnectedFileBufferPaths = new HashSet<IPath>();

        public CheckstyleAuditListener(IProject project) {
            this.mProject = project;
            this.mLimitMarkers = CheckstylePluginPrefs.getBoolean("limit.markers.per.resource");
            this.mMarkerLimit = CheckstylePluginPrefs.getInt("marker.amount.limit");
        }

        public void fileStarted(AuditEvent event) {
            if (Auditor.this.mMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.mResource = Auditor.this.getFile(event.getFileName());
            this.mMarkerCount = 0;
            if (this.mResource != null) {
                if (this.mMonitorCounter == 0) {
                    Auditor.this.mMonitor.subTask(NLS.bind((String)Messages.Auditor_msgCheckingFile, (Object)this.mResource.getName()));
                }
                ++this.mMonitorCounter;
            } else {
                Path filePath = new Path(event.getFileName());
                IPath dirPath = filePath.removeFileExtension().removeLastSegments(1);
                IPath projectPath = this.mProject.getLocation();
                this.mResource = projectPath.isPrefixOf(dirPath) ? this.mProject.findMember(dirPath.removeFirstSegments(projectPath.segmentCount())) : this.mProject;
            }
        }

        public void addError(AuditEvent error) {
            try {
                if (!this.mLimitMarkers || this.mMarkerCount < this.mMarkerLimit) {
                    SeverityLevel severity = error.getSeverityLevel();
                    if (this.mResource != null && !severity.equals((Object)SeverityLevel.IGNORE)) {
                        RuleMetadata metaData = MetadataFactory.getRuleMetadata(error.getSourceName());
                        if (metaData == null) {
                            Module module = new Module(error.getSourceName());
                            metaData = MetadataFactory.createGenericMetadata(module);
                        }
                        this.mMarkerAttributes.put("ModuleName", metaData.getInternalName());
                        this.mMarkerAttributes.put("MessageKey", error.getViolation().getKey());
                        this.mMarkerAttributes.put("priority", 1);
                        this.mMarkerAttributes.put("severity", this.getSeverityValue(severity));
                        this.mMarkerAttributes.put("lineNumber", error.getLine());
                        this.mMarkerAttributes.put("message", this.getMessage(error));
                        this.calculateMarkerOffset(error, this.mMarkerAttributes);
                        this.mMarkerAttributes.put("categoryId", 999);
                        IMarker marker = this.mResource.createMarker("net.sf.eclipsecs.core.CheckstyleMarker");
                        marker.setAttributes(this.mMarkerAttributes);
                        ++this.mMarkerCount;
                        this.mMarkerAttributes.clear();
                    }
                }
            }
            catch (CoreException ex) {
                CheckstyleLog.log(ex);
            }
        }

        public void addException(AuditEvent event, Throwable throwable) {
            CheckstyleLog.log(throwable);
        }

        public void fileFinished(AuditEvent event) {
            if (this.mMonitorCounter == 10) {
                Auditor.this.mMonitor.worked(10);
                this.mMonitorCounter = 0;
            }
            this.disconnectFileBuffer(this.mResource);
            this.mDocument = null;
        }

        public void auditFinished(AuditEvent event) {
            this.cleanup();
        }

        public void auditStarted(AuditEvent event) {
        }

        public void cleanup() {
            this.mDocument = null;
            for (IPath p : this.mConnectedFileBufferPaths) {
                this.disconnectFileBuffer(p);
            }
        }

        private void calculateMarkerOffset(AuditEvent error, Map<String, Object> markerAttributes) {
            if (this.mDocument == null) {
                this.mDocument = this.connectFileBuffer(this.mResource);
            }
            if (this.mDocument != null) {
                try {
                    int line = error.getLine();
                    IRegion lineInformation = this.mDocument.getLineInformation(line == 0 ? 0 : line - 1);
                    int lineOffset = lineInformation.getOffset();
                    int lineLength = lineInformation.getLength();
                    int offset = error.getViolation().getColumnCharIndex();
                    markerAttributes.put("charStart", lineOffset + offset);
                    markerAttributes.put("charEnd", lineOffset + lineLength);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private IDocument connectFileBuffer(IResource resource) {
            if (!(resource instanceof IFile)) {
                return null;
            }
            IDocument document = null;
            try {
                IPath path = resource.getFullPath();
                Auditor.this.mFileBufferManager.connect(path, (IProgressMonitor)new NullProgressMonitor());
                this.mConnectedFileBufferPaths.add(path);
                document = Auditor.this.mFileBufferManager.getTextFileBuffer(path).getDocument();
            }
            catch (CoreException ex) {
                CheckstyleLog.log(ex);
            }
            return document;
        }

        private void disconnectFileBuffer(IResource resource) {
            if (!(resource instanceof IFile)) {
                return;
            }
            IPath path = this.mResource.getFullPath();
            this.disconnectFileBuffer(path);
        }

        private void disconnectFileBuffer(IPath path) {
            try {
                if (this.mConnectedFileBufferPaths.contains(path)) {
                    Auditor.this.mFileBufferManager.disconnect(path, (IProgressMonitor)new NullProgressMonitor());
                    this.mConnectedFileBufferPaths.remove(path);
                }
            }
            catch (CoreException ex) {
                CheckstyleLog.log(ex);
            }
        }

        private int getSeverityValue(SeverityLevel severity) {
            int result = 1;
            if (severity.equals((Object)SeverityLevel.INFO)) {
                result = 0;
            } else if (severity.equals((Object)SeverityLevel.WARNING)) {
                result = 1;
            } else if (severity.equals((Object)SeverityLevel.ERROR)) {
                result = 2;
            }
            return result;
        }

        private String getMessage(AuditEvent error) {
            RuleMetadata metaData;
            String moduleId = error.getModuleId();
            if (moduleId == null && (metaData = MetadataFactory.getRuleMetadata(error.getSourceName())) != null) {
                moduleId = metaData.getInternalName();
            }
            String message = error.getMessage();
            StringBuilder prefix = new StringBuilder();
            if (Auditor.this.mAddRuleName) {
                prefix.append(this.getRuleName(error));
            }
            if (Auditor.this.mAddModuleId && error.getModuleId() != null) {
                if (prefix.length() > 0) {
                    prefix.append(" - ");
                }
                prefix.append(error.getModuleId());
            }
            StringBuilder buf = new StringBuilder();
            if (prefix.length() > 0) {
                buf.append((CharSequence)prefix).append(": ");
            }
            buf.append(message);
            return buf.toString();
        }

        private String getRuleName(AuditEvent error) {
            RuleMetadata metaData = MetadataFactory.getRuleMetadata(error.getSourceName());
            if (metaData == null) {
                return Messages.Auditor_txtUnknownModule;
            }
            return metaData.getInternalName();
        }
    }
}

