/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.config.Module;
import net.sf.eclipsecs.core.config.Severity;
import net.sf.eclipsecs.core.config.meta.MetadataFactory;
import net.sf.eclipsecs.core.config.meta.RuleMetadata;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.core.util.XMLUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class ConfigurationReader {
    private static final Pattern PROPERTY_REF_PATTERN = Pattern.compile("^.*\\$\\{.*\\}.*$");
    private static final Map<String, String> PUBLIC2INTERNAL_DTD_MAP;
    private static final String DTD_PUBLIC_ID_1_0 = "-//Puppy Crawl//DTD Check Configuration 1.0//EN";
    private static final String DTD_PUBLIC_CS_ID_1_0 = "-//Checkstyle//DTD Checkstyle Configuration 1.0//EN";
    private static final String DTD_CONFIGURATION_NAME_1_0 = "com/puppycrawl/tools/checkstyle/configuration_1_0.dtd";
    private static final String DTD_PUBLIC_ID_1_1 = "-//Puppy Crawl//DTD Check Configuration 1.1//EN";
    private static final String DTD_PUBLIC_CS_ID_1_1 = "-//Checkstyle//DTD Checkstyle Configuration 1.1//EN";
    private static final String DTD_CONFIGURATION_NAME_1_1 = "com/puppycrawl/tools/checkstyle/configuration_1_1.dtd";
    private static final String DTD_PUBLIC_ID_1_2 = "-//Puppy Crawl//DTD Check Configuration 1.2//EN";
    private static final String DTD_PUBLIC_CS_ID_1_2 = "-//Checkstyle//DTD Checkstyle Configuration 1.2//EN";
    private static final String DTD_CONFIGURATION_NAME_1_2 = "com/puppycrawl/tools/checkstyle/configuration_1_2.dtd";
    private static final String DTD_PUBLIC_ID_1_3 = "-//Puppy Crawl//DTD Check Configuration 1.3//EN";
    private static final String DTD_PUBLIC_CS_ID_1_3 = "-//Checkstyle//DTD Checkstyle Configuration 1.3//EN";
    private static final String DTD_CONFIGURATION_NAME_1_3 = "com/puppycrawl/tools/checkstyle/configuration_1_3.dtd";

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DTD_PUBLIC_ID_1_0, DTD_CONFIGURATION_NAME_1_0);
        map.put(DTD_PUBLIC_ID_1_1, DTD_CONFIGURATION_NAME_1_1);
        map.put(DTD_PUBLIC_ID_1_2, DTD_CONFIGURATION_NAME_1_2);
        map.put(DTD_PUBLIC_ID_1_3, DTD_CONFIGURATION_NAME_1_3);
        map.put(DTD_PUBLIC_CS_ID_1_0, DTD_CONFIGURATION_NAME_1_0);
        map.put(DTD_PUBLIC_CS_ID_1_1, DTD_CONFIGURATION_NAME_1_1);
        map.put(DTD_PUBLIC_CS_ID_1_2, DTD_CONFIGURATION_NAME_1_2);
        map.put(DTD_PUBLIC_CS_ID_1_3, DTD_CONFIGURATION_NAME_1_3);
        PUBLIC2INTERNAL_DTD_MAP = map;
    }

    private ConfigurationReader() {
    }

    public static List<Module> read(InputSource input) throws CheckstylePluginException {
        List<Object> rules = null;
        try {
            SAXReader reader = new SAXReader();
            reader.setEntityResolver((EntityResolver)new XMLUtil.InternalDtdEntityResolver(PUBLIC2INTERNAL_DTD_MAP));
            Document document = reader.read(input);
            rules = ConfigurationReader.getModules(document);
        }
        catch (DocumentException ex) {
            CheckstylePluginException.rethrow(ex);
        }
        return rules != null ? rules : new ArrayList();
    }

    private static List<Module> getModules(Document document) {
        final ArrayList<Module> modules = new ArrayList<Module>();
        document.accept((Visitor)new VisitorSupport(){

            public void visit(Element node) {
                if ("module".equals(node.getName())) {
                    String name = node.attributeValue("name");
                    RuleMetadata metadata = MetadataFactory.getRuleMetadata(name);
                    Module module = null;
                    module = metadata != null ? new Module(metadata, true) : new Module(name);
                    ConfigurationReader.addProperties(node, module);
                    ConfigurationReader.addMessages(node, module);
                    ConfigurationReader.addMetadata(node, module);
                    if (module.getMetaData() == null) {
                        MetadataFactory.createGenericMetadata(module);
                    }
                    modules.add(module);
                }
            }
        });
        return modules;
    }

    private static void addProperties(Element moduleEl, Module module) {
        List propertyEls = moduleEl.elements("property");
        for (Element propertyEl : propertyEls) {
            ConfigProperty property;
            boolean isPropertyRef;
            String name = propertyEl.attributeValue("name");
            String value = propertyEl.attributeValue("value");
            boolean bl = isPropertyRef = value != null && PROPERTY_REF_PATTERN.matcher(value).matches();
            if (name.equals("severity") && module.getMetaData() != null && module.getMetaData().hasSeverity()) {
                try {
                    module.setSeverity(Severity.valueOf(value));
                }
                catch (IllegalArgumentException ex) {
                    module.setSeverity(Severity.inherit);
                }
                continue;
            }
            if (name.equals("id")) {
                module.setId(Strings.emptyToNull((String)value));
                continue;
            }
            if (module.getMetaData() != null) {
                property = module.getProperty(name);
                if (property == null) continue;
                property.setValue(value);
                property.setPropertyReference(isPropertyRef);
                continue;
            }
            property = new ConfigProperty(name, value);
            property.setPropertyReference(isPropertyRef);
            module.getProperties().add(property);
        }
    }

    private static void addMessages(Element moduleEl, Module module) {
        List messageEls = moduleEl.elements("message");
        for (Element messageEl : messageEls) {
            String key = messageEl.attributeValue("key");
            String value = messageEl.attributeValue("value");
            module.getCustomMessages().put(key, value);
        }
    }

    private static void addMetadata(Element moduleEl, Module module) {
        List metaEls = moduleEl.elements("metadata");
        for (Element metaEl : metaEls) {
            String name = metaEl.attributeValue("name");
            String value = metaEl.attributeValue("value");
            if ("net.sf.eclipsecs.core.comment".equals(name)) {
                module.setComment(value);
                continue;
            }
            if ("net.sf.eclipsecs.core.lastEnabledSeverity".equals(name)) {
                module.setLastEnabledSeverity(Severity.valueOf(value));
                continue;
            }
            module.getCustomMetaData().put(name, value);
        }
    }
}

