/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.configtypes;

import com.puppycrawl.tools.checkstyle.PropertyResolver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;

public class BuiltInFilePropertyResolver
implements PropertyResolver {
    private static final String SAMEDIR_LOC = "samedir";
    private static final String CONFIG_LOC = "config_loc";
    private final String mBuiltInConfigLocation;

    public BuiltInFilePropertyResolver(String builtInConfigLocation) {
        this.mBuiltInConfigLocation = builtInConfigLocation;
    }

    public String resolve(String property) {
        int lastSlash;
        String value = null;
        if (this.mBuiltInConfigLocation != null && (SAMEDIR_LOC.equals(property) || CONFIG_LOC.equals(property)) && (lastSlash = this.mBuiltInConfigLocation.lastIndexOf("/")) > -1) {
            value = this.mBuiltInConfigLocation.substring(0, lastSlash + 1);
        }
        if (value != null) {
            try {
                URL bundleLocatedURL = new URL(value);
                URL fileURL = FileLocator.toFileURL((URL)bundleLocatedURL);
                value = URIUtil.toFile((URI)fileURL.toURI()).getAbsolutePath();
            }
            catch (IOException | URISyntaxException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return value;
    }
}

