/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.configtypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public final class ConfigurationTypes {
    private static final String CONFIGTYPES_EXTENSION_POINT = "net.sf.eclipsecs.core.configurationtypes";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_INTERNAL_NAME = "internal-name";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_CREATABLE = "creatable";
    private static final String ATTR_EDITABLE = "editable";
    private static final String ATTR_CONFIGURABLE = "configurable";
    private static final Map<String, IConfigurationType> CONFIGURATION_TYPES = new LinkedHashMap<String, IConfigurationType>();

    static {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = pluginRegistry.getConfigurationElementsFor(CONFIGTYPES_EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            try {
                String name = elements[i].getAttribute(ATTR_NAME);
                String internalName = elements[i].getAttribute(ATTR_INTERNAL_NAME);
                String definingPluginId = elements[i].getDeclaringExtension().getNamespaceIdentifier();
                boolean isCreatable = Boolean.parseBoolean(elements[i].getAttribute(ATTR_CREATABLE));
                boolean isEditable = Boolean.parseBoolean(elements[i].getAttribute(ATTR_EDITABLE));
                boolean isConfigurable = Boolean.parseBoolean(elements[i].getAttribute(ATTR_CONFIGURABLE));
                IConfigurationType configType = (IConfigurationType)elements[i].createExecutableExtension(ATTR_CLASS);
                configType.initialize(name, internalName, definingPluginId, isCreatable, isEditable, isConfigurable);
                CONFIGURATION_TYPES.put(internalName, configType);
            }
            catch (Exception ex) {
                CheckstyleLog.log(ex);
            }
            ++i;
        }
    }

    private ConfigurationTypes() {
    }

    public static IConfigurationType[] getCreatableConfigTypes() {
        ArrayList<IConfigurationType> creatableTypes = new ArrayList<IConfigurationType>();
        for (IConfigurationType type : CONFIGURATION_TYPES.values()) {
            if (!type.isCreatable()) continue;
            creatableTypes.add(type);
        }
        return creatableTypes.toArray(new IConfigurationType[creatableTypes.size()]);
    }

    public static IConfigurationType[] getConfigurableConfigTypes() {
        ArrayList<IConfigurationType> configurableTypes = new ArrayList<IConfigurationType>();
        configurableTypes.addAll(Arrays.asList(ConfigurationTypes.getCreatableConfigTypes()));
        IConfigurationType remoteType = ConfigurationTypes.getByInternalName("remote");
        configurableTypes.remove(remoteType);
        return configurableTypes.toArray(new IConfigurationType[configurableTypes.size()]);
    }

    public static IConfigurationType getByInternalName(String name) {
        return CONFIGURATION_TYPES.get(name);
    }

    public static IConfigurationType getByName(String name) {
        for (IConfigurationType type : CONFIGURATION_TYPES.values()) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }
}

