/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.meta;

import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.eclipsecs.core.CheckstylePlugin;

public final class CheckUtil {
    private CheckUtil() {
    }

    public static String getModifiableTokens(String checkName) {
        AbstractCheck checkResult = CheckUtil.getCheck(checkName);
        String result = null;
        if (AbstractJavadocCheck.class.isAssignableFrom(checkResult.getClass())) {
            AbstractJavadocCheck javadocCheck = (AbstractJavadocCheck)checkResult;
            List<Integer> modifiableJavadocTokens = CheckUtil.subtractTokens(javadocCheck.getAcceptableJavadocTokens(), javadocCheck.getRequiredJavadocTokens());
            result = CheckUtil.getTokens(JavadocUtil::getTokenName, modifiableJavadocTokens);
        } else if (AbstractCheck.class.isAssignableFrom(checkResult.getClass())) {
            AbstractCheck check = checkResult;
            List<Integer> modifiableTokens = CheckUtil.subtractTokens(check.getAcceptableTokens(), check.getRequiredTokens());
            result = CheckUtil.getTokens(TokenUtil::getTokenName, modifiableTokens);
        } else {
            throw new IllegalStateException("Exception caused in CheckUtil.getCheck, method executed in wrong context, heirarchy of check class missing");
        }
        return result;
    }

    private static AbstractCheck getCheck(String checkName) {
        ClassLoader classLoader = CheckstylePlugin.getDefault().getAddonExtensionClassLoader();
        try {
            Set packageNames = PackageNamesLoader.getPackageNames((ClassLoader)classLoader);
            return (AbstractCheck)new PackageObjectFactory(packageNames, classLoader).createModule(checkName);
        }
        catch (CheckstyleException ex) {
            throw new IllegalStateException("exception occured during load of " + checkName, ex);
        }
    }

    private static List<Integer> subtractTokens(int[] tokens, int ... requiredTokens) {
        HashSet requiredTokensSet = new HashSet(Arrays.stream(requiredTokens).boxed().collect(Collectors.toList()));
        return Arrays.stream(tokens).boxed().filter(token -> !requiredTokensSet.contains(token)).collect(Collectors.toList());
    }

    private static String getTokens(Function<Integer, String> function, List<Integer> modifiableTokens) {
        return modifiableTokens.stream().map(function::apply).collect(Collectors.joining(","));
    }
}

