/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.meta;

import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.meta.ModuleDetails;
import com.puppycrawl.tools.checkstyle.meta.ModulePropertyDetails;
import com.puppycrawl.tools.checkstyle.meta.XmlMetaReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.config.Module;
import net.sf.eclipsecs.core.config.Severity;
import net.sf.eclipsecs.core.config.meta.CheckUtil;
import net.sf.eclipsecs.core.config.meta.ConfigPropertyMetadata;
import net.sf.eclipsecs.core.config.meta.ConfigPropertyType;
import net.sf.eclipsecs.core.config.meta.IOptionProvider;
import net.sf.eclipsecs.core.config.meta.RuleGroupMetadata;
import net.sf.eclipsecs.core.config.meta.RuleMetadata;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.core.util.XMLUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.xml.sax.EntityResolver;
import org.yaml.snakeyaml.Yaml;

public final class MetadataFactory {
    private static final String TYPE_ID_PATTERN = "java.util.regex.Pattern";
    private static final Map<String, String> PUBLIC2INTERNAL_DTD_MAP = new HashMap<String, String>();
    private static final Pattern ECLIPSE_EXTENSION_CONFIG_FILE = Pattern.compile(".*eclipse-metadata.*\\.yml");
    private static final String DOT_PATTERN = "\\.";
    private static final String OTHER_GROUP_NAME = "Other";
    private static final String METADATA_FILENAME = "checkstyle-metadata.xml";
    private static Map<String, RuleGroupMetadata> sRuleGroupMetadata;
    private static Map<String, RuleMetadata> sRuleMetadata;
    private static Map<String, RuleMetadata> sAlternativeNamesMap;
    private static Map<String, ConfigPropertyType> sPropertyTypeMap;
    private static Map<String, String> sPackageToGroupNameMap;
    private static Map<String, ModuleDetails> sModuleDetailsRepo;
    private static Set<String> sPackageNameSet;
    private static Map<String, Map<String, String>> sThirdPartyRuleGroupMap;

    static {
        PUBLIC2INTERNAL_DTD_MAP.put("-//eclipse-cs//DTD Check Metadata 1.0//EN", "/com/puppycrawl/tools/checkstyle/checkstyle-metadata_1_0.dtd");
        PUBLIC2INTERNAL_DTD_MAP.put("-//eclipse-cs//DTD Check Metadata 1.1//EN", "/com/puppycrawl/tools/checkstyle/checkstyle-metadata_1_1.dtd");
        MetadataFactory.refresh();
    }

    private MetadataFactory() {
    }

    private static RuleMetadata createRuleMetadata(ModuleDetails moduleDetails) {
        RuleGroupMetadata group;
        String[] packageTokens;
        String moduleClassName = moduleDetails.getFullQualifiedName();
        if (moduleClassName.startsWith("com.puppycrawl.tools.checkstyle")) {
            packageTokens = moduleDetails.getFullQualifiedName().split(DOT_PATTERN);
            group = MetadataFactory.getRuleGroupMetadata(sPackageToGroupNameMap.get(packageTokens[packageTokens.length - 2]));
        } else {
            String lookupKey = MetadataFactory.findLookupKey(moduleClassName);
            String ruleGroupName = sThirdPartyRuleGroupMap.get(lookupKey).get("name");
            group = MetadataFactory.getRuleGroupMetadata(ruleGroupName);
            if (group == null) {
                String ruleDescription = sThirdPartyRuleGroupMap.get(lookupKey).get("description");
                int rulePriority = Integer.parseInt(sThirdPartyRuleGroupMap.get(lookupKey).get("priority"));
                group = new RuleGroupMetadata(ruleGroupName, ruleDescription, false, rulePriority);
                sRuleGroupMetadata.put(ruleGroupName, group);
            }
        }
        packageTokens = moduleDetails.getParent().split(DOT_PATTERN);
        RuleMetadata ruleMeta = new RuleMetadata(moduleDetails.getName(), moduleDetails.getName(), packageTokens[packageTokens.length - 1], MetadataFactory.getDefaultSeverity(), false, true, true, false, group);
        ruleMeta.setDescription(moduleDetails.getDescription());
        moduleDetails.getProperties().forEach(modulePropertyDetails -> {
            boolean bl = ruleMeta.getPropertyMetadata().add(MetadataFactory.createPropertyConfig(moduleDetails, modulePropertyDetails));
        });
        return ruleMeta;
    }

    private static ConfigPropertyMetadata createPropertyConfig(ModuleDetails moduleDetails, ModulePropertyDetails modulePropertyDetails) {
        ConfigPropertyType dataType = null;
        String propertyType = modulePropertyDetails.getType();
        if (sPropertyTypeMap.get(propertyType) != null) {
            String validationType = modulePropertyDetails.getValidationType();
            if (validationType != null) {
                if (validationType.equals(TYPE_ID_PATTERN)) {
                    dataType = ConfigPropertyType.Regex;
                } else if (validationType.equals("tokenSet") || validationType.equals("tokenTypesSet")) {
                    dataType = ConfigPropertyType.MultiCheck;
                }
            } else {
                dataType = sPropertyTypeMap.get(propertyType);
            }
        } else {
            dataType = propertyType.endsWith("Option") ? ConfigPropertyType.SingleSelect : (propertyType.endsWith("[]") ? ConfigPropertyType.StringArray : ConfigPropertyType.String);
        }
        ConfigPropertyMetadata modifiedConfigPropertyMetadata = new ConfigPropertyMetadata(dataType, modulePropertyDetails.getName(), modulePropertyDetails.getDefaultValue(), null);
        modifiedConfigPropertyMetadata.setDescription(modulePropertyDetails.getDescription());
        if (dataType == ConfigPropertyType.SingleSelect) {
            List<String> resultList = MetadataFactory.getEnumValues(propertyType);
            resultList.forEach(modifiedConfigPropertyMetadata.getPropertyEnumeration()::add);
        } else if (dataType == ConfigPropertyType.MultiCheck) {
            String result = CheckUtil.getModifiableTokens(moduleDetails.getName());
            Collections.addAll(modifiedConfigPropertyMetadata.getPropertyEnumeration(), result.split(","));
        }
        return modifiedConfigPropertyMetadata;
    }

    public static RuleMetadata createGenericMetadata(Module module) {
        String parent = null;
        try {
            Class<?> checkClass = CheckstylePlugin.getDefault().getAddonExtensionClassLoader().loadClass(module.getName());
            Object moduleInstance = checkClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            parent = moduleInstance instanceof AbstractFileSetCheck ? "Checker" : "TreeWalker";
        }
        catch (Exception ex) {
            parent = "TreeWalker";
        }
        RuleGroupMetadata otherGroup = MetadataFactory.getRuleGroupMetadata(OTHER_GROUP_NAME);
        RuleMetadata ruleMeta = new RuleMetadata(module.getName(), module.getName(), parent, MetadataFactory.getDefaultSeverity(), false, true, true, false, otherGroup);
        module.setMetaData(ruleMeta);
        sRuleMetadata.put(ruleMeta.getInternalName(), ruleMeta);
        List<ConfigProperty> properties = module.getProperties();
        int size = properties != null ? properties.size() : 0;
        int i = 0;
        while (i < size) {
            ConfigProperty property = properties.get(i);
            ConfigPropertyMetadata meta = new ConfigPropertyMetadata(ConfigPropertyType.String, property.getName(), null, null);
            property.setMetaData(meta);
            ++i;
        }
        return ruleMeta;
    }

    private static void createMetadataMap() {
        XmlMetaReader.readAllModulesIncludingThirdPartyIfAny((String[])sPackageNameSet.toArray(new String[sPackageNameSet.size()])).forEach(moduleDetail -> {
            ModuleDetails moduleDetails = sModuleDetailsRepo.put(moduleDetail.getName(), (ModuleDetails)moduleDetail);
        });
    }

    private static void loadThirdPartyModuleExtensionMetadata() {
        HashSet eclipseMetaDataFiles = new HashSet();
        for (String packageName : sPackageNameSet) {
            String topMostPackageName = packageName.split(DOT_PATTERN)[0];
            Reflections reflections = new Reflections(topMostPackageName, new Scanner[]{new ResourcesScanner()});
            eclipseMetaDataFiles.addAll(reflections.getResources(ECLIPSE_EXTENSION_CONFIG_FILE));
        }
        eclipseMetaDataFiles.forEach(MetadataFactory::loadThirdPartyData);
    }

    private static void loadThirdPartyData(String metadataFile) {
        InputStream inputStream = CheckstylePlugin.getDefault().getAddonExtensionClassLoader().getResourceAsStream(metadataFile);
        Map objects = (Map)new Yaml().load(inputStream);
        for (Map obj : (List)objects.get("ruleGroups")) {
            HashMap<String, String> ruleGroupData = new HashMap<String, String>();
            ruleGroupData.put("name", (String)obj.get("name"));
            ruleGroupData.put("description", (String)obj.get("description"));
            ruleGroupData.put("priority", Integer.toString((Integer)obj.get("priority")));
            sThirdPartyRuleGroupMap.put((String)obj.get("package"), ruleGroupData);
        }
    }

    public static List<RuleGroupMetadata> getRuleGroupMetadata() {
        ArrayList<RuleGroupMetadata> groups = new ArrayList<RuleGroupMetadata>(sRuleGroupMetadata.values());
        Collections.sort(groups, new Comparator<RuleGroupMetadata>(){

            @Override
            public int compare(RuleGroupMetadata arg0, RuleGroupMetadata arg1) {
                int prio2;
                int prio1 = arg0.getPriority();
                return prio1 < (prio2 = arg1.getPriority()) ? -1 : (prio1 == prio2 ? 0 : 1);
            }
        });
        return groups;
    }

    private static RuleGroupMetadata getRuleGroupMetadata(String name) {
        return sRuleGroupMetadata.get(name);
    }

    public static RuleMetadata getRuleMetadata(String name) {
        RuleMetadata metadata = null;
        metadata = sRuleMetadata.get(name);
        if (metadata == null) {
            metadata = sAlternativeNamesMap.get(name);
        }
        return metadata;
    }

    private static String findLookupKey(String packageName) {
        String[] packageTokens = packageName.split(DOT_PATTERN);
        ArrayList<String> prefixList = new ArrayList<String>();
        String lookupKey = packageTokens[0];
        prefixList.add(lookupKey);
        int i = 1;
        while (i < packageTokens.length) {
            lookupKey = String.valueOf(lookupKey) + "." + packageTokens[i];
            prefixList.add(lookupKey);
            ++i;
        }
        String result = null;
        Collections.reverse(prefixList);
        for (String candidate : prefixList) {
            if (!sThirdPartyRuleGroupMap.containsKey(candidate)) continue;
            result = candidate;
            break;
        }
        return result;
    }

    private static List<String> getEnumValues(String className) {
        ArrayList<String> resultList = new ArrayList<String>();
        Class<?> providerClass = null;
        try {
            providerClass = CheckstylePlugin.getDefault().getAddonExtensionClassLoader().loadClass(className);
            EnumSet<Enum> values = EnumSet.allOf(providerClass);
            for (Enum value : values) {
                resultList.add(value.name().toLowerCase());
            }
        }
        catch (ClassNotFoundException exc) {
            CheckstyleLog.log(exc, "Class " + className + " not found.");
        }
        return resultList;
    }

    public static Severity getDefaultSeverity() {
        return Severity.inherit;
    }

    public static String getStandardMessage(String messageKey, String moduleInternalName) {
        RuleMetadata rule = MetadataFactory.getRuleMetadata(moduleInternalName);
        return MetadataFactory.getStandardMessage(messageKey, rule);
    }

    private static String getStandardMessage(String messageKey, RuleMetadata rule) {
        if (messageKey == null || rule == null) {
            return null;
        }
        ArrayList<String> namesToCheck = new ArrayList<String>();
        namesToCheck.add(rule.getInternalName());
        namesToCheck.addAll(rule.getAlternativeNames());
        for (String moduleClass : namesToCheck) {
            try {
                int endIndex = moduleClass.lastIndexOf(46);
                String messages = "messages";
                if (endIndex >= 0) {
                    String packageName = moduleClass.substring(0, endIndex);
                    messages = String.valueOf(packageName) + "." + messages;
                }
                ResourceBundle resourceBundle = ResourceBundle.getBundle(messages, CheckstylePlugin.getPlatformLocale(), CheckstylePlugin.class.getClassLoader(), new UTF8Control());
                String message = resourceBundle.getString(messageKey);
                return message;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    private static synchronized void refresh() {
        sRuleGroupMetadata = new TreeMap<String, RuleGroupMetadata>();
        sRuleMetadata = new HashMap<String, RuleMetadata>();
        sAlternativeNamesMap = new HashMap<String, RuleMetadata>();
        sPropertyTypeMap = new HashMap<String, ConfigPropertyType>();
        sPackageToGroupNameMap = new HashMap<String, String>();
        sModuleDetailsRepo = new HashMap<String, ModuleDetails>();
        sThirdPartyRuleGroupMap = new HashMap<String, Map<String, String>>();
        sPackageNameSet = new HashSet<String>();
        try {
            MetadataFactory.doInitialization();
        }
        catch (CheckstylePluginException ex) {
            CheckstyleLog.log(ex);
        }
    }

    private static void doInitialization() throws CheckstylePluginException {
        MetadataFactory.createPropertyTypeMapping();
        MetadataFactory.createPackageToGroupNameMapping();
        ClassLoader classLoader = CheckstylePlugin.getDefault().getAddonExtensionClassLoader();
        Collection<String> potentialMetadataFiles = MetadataFactory.getAllPotentialMetadataFiles(classLoader);
        MetadataFactory.loadThirdPartyModuleExtensionMetadata();
        MetadataFactory.createMetadataMap();
        for (String metadataFile : potentialMetadataFiles) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream metadataStream = classLoader.getResourceAsStream(metadataFile);){
                    if (metadataStream == null) continue;
                    ResourceBundle metadataBundle = MetadataFactory.getMetadataI18NBundle(metadataFile, classLoader);
                    MetadataFactory.parseMetadata(metadataStream, metadataBundle);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | DocumentException ex) {
                CheckstyleLog.log(ex, "Could not read metadata " + metadataFile);
            }
        }
        MetadataFactory.loadRuleMetadata();
    }

    private static void loadRuleMetadata() {
        for (Map.Entry<String, ModuleDetails> entry : sModuleDetailsRepo.entrySet()) {
            ModuleDetails moduleDetails = entry.getValue();
            RuleMetadata createdRuleMetadata = MetadataFactory.createRuleMetadata(moduleDetails);
            sRuleMetadata.put(moduleDetails.getName(), createdRuleMetadata);
            sRuleGroupMetadata.get(createdRuleMetadata.getGroup().getGroupName()).getRuleMetadata().add(createdRuleMetadata);
        }
    }

    private static void createPropertyTypeMapping() {
        sPropertyTypeMap.put("java.lang.String", ConfigPropertyType.String);
        sPropertyTypeMap.put("java.lang.String[]", ConfigPropertyType.StringArray);
        sPropertyTypeMap.put("boolean", ConfigPropertyType.Boolean);
        sPropertyTypeMap.put("int", ConfigPropertyType.Integer);
        sPropertyTypeMap.put(TYPE_ID_PATTERN, ConfigPropertyType.Regex);
        sPropertyTypeMap.put("java.util.regex.Pattern[]", ConfigPropertyType.StringArray);
        sPropertyTypeMap.put("File", ConfigPropertyType.File);
    }

    private static void createPackageToGroupNameMapping() {
        sPackageToGroupNameMap.put("annotation", "Annotations");
        sPackageToGroupNameMap.put("checks", "Miscellaneous");
        sPackageToGroupNameMap.put("checkstyle", OTHER_GROUP_NAME);
        sPackageToGroupNameMap.put("blocks", "Blocks");
        sPackageToGroupNameMap.put("coding", "Coding Problems");
        sPackageToGroupNameMap.put("design", "Class Design");
        sPackageToGroupNameMap.put("header", "Headers");
        sPackageToGroupNameMap.put("imports", "Imports");
        sPackageToGroupNameMap.put("indentation", "Indentation");
        sPackageToGroupNameMap.put("javadoc", "Javadoc Comments");
        sPackageToGroupNameMap.put("metrics", "Metrics");
        sPackageToGroupNameMap.put("modifier", "Modifiers");
        sPackageToGroupNameMap.put("naming", "Naming Conventions");
        sPackageToGroupNameMap.put("regexp", "Regexp");
        sPackageToGroupNameMap.put("sizes", "Size Violations");
        sPackageToGroupNameMap.put("whitespace", "Whitespace");
        sPackageToGroupNameMap.put("filters", "Filters");
        sPackageToGroupNameMap.put("filefilters", "File Filters");
    }

    private static Collection<String> getAllPotentialMetadataFiles(ClassLoader classLoader) throws CheckstylePluginException {
        ArrayList<String> potentialMetadataFiles = new ArrayList<String>();
        Set packages = null;
        try {
            packages = PackageNamesLoader.getPackageNames((ClassLoader)classLoader);
        }
        catch (CheckstyleException ex) {
            CheckstylePluginException.rethrow(ex);
        }
        sPackageNameSet.addAll(packages);
        for (String packageName : packages) {
            String metaFileLocation = packageName.replace('.', '/');
            if (!metaFileLocation.endsWith("/")) {
                metaFileLocation = String.valueOf(metaFileLocation) + "/";
            }
            metaFileLocation = String.valueOf(metaFileLocation) + METADATA_FILENAME;
            potentialMetadataFiles.add(metaFileLocation);
        }
        return potentialMetadataFiles;
    }

    private static ResourceBundle getMetadataI18NBundle(String metadataFile, ClassLoader classLoader) {
        String bundle = metadataFile.substring(0, metadataFile.length() - 4).replace('/', '.');
        try {
            return ResourceBundle.getBundle(bundle, CheckstylePlugin.getPlatformLocale(), classLoader);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    private static void parseMetadata(InputStream metadataStream, ResourceBundle metadataBundle) throws DocumentException, CheckstylePluginException {
        SAXReader reader = new SAXReader();
        reader.setEntityResolver((EntityResolver)new XMLUtil.InternalDtdEntityResolver(PUBLIC2INTERNAL_DTD_MAP));
        Document document = reader.read(metadataStream);
        List groupElements = document.getRootElement().elements("rule-group-metadata");
        for (Element groupEl : groupElements) {
            String groupName = groupEl.attributeValue("name").trim();
            groupName = MetadataFactory.localize(groupName, metadataBundle);
            String groupDesc = groupEl.elementTextTrim("description");
            groupDesc = MetadataFactory.localize(groupDesc, metadataBundle);
            RuleGroupMetadata group = MetadataFactory.getRuleGroupMetadata(groupName);
            if (group == null) {
                boolean hidden = Boolean.parseBoolean(groupEl.attributeValue("hidden"));
                int priority = 0;
                try {
                    priority = Integer.parseInt(groupEl.attributeValue("priority"));
                }
                catch (Exception ex) {
                    CheckstyleLog.log(ex);
                    priority = Integer.MAX_VALUE;
                }
                group = new RuleGroupMetadata(groupName, groupDesc, hidden, priority);
                sRuleGroupMetadata.put(groupName, group);
            }
            MetadataFactory.processModules(groupEl, group, metadataBundle);
        }
    }

    private static void processModules(Element groupElement, RuleGroupMetadata groupMetadata, ResourceBundle metadataBundle) throws CheckstylePluginException {
        List moduleElements = groupElement.elements("rule-metadata");
        for (Element moduleEl : moduleElements) {
            String defaultSeverity = moduleEl.attributeValue("default-severity");
            Severity severity = defaultSeverity == null || defaultSeverity.trim().length() == 0 ? MetadataFactory.getDefaultSeverity() : Severity.valueOf(defaultSeverity);
            String name = moduleEl.attributeValue("name").trim();
            name = MetadataFactory.localize(name, metadataBundle);
            String internalName = moduleEl.attributeValue("internal-name").trim();
            String parentName = moduleEl.attributeValue("parent") != null ? moduleEl.attributeValue("parent").trim() : null;
            boolean hidden = Boolean.parseBoolean(moduleEl.attributeValue("hidden"));
            boolean hasSeverity = !"false".equals(moduleEl.attributeValue("hasSeverity"));
            boolean deletable = !"false".equals(moduleEl.attributeValue("deletable"));
            boolean isSingleton = Boolean.parseBoolean(moduleEl.attributeValue("singleton"));
            RuleMetadata module = new RuleMetadata(name, internalName, parentName, severity, hidden, hasSeverity, deletable, isSingleton, groupMetadata);
            sRuleMetadata.put(internalName, module);
            String description = moduleEl.elementTextTrim("description");
            description = MetadataFactory.localize(description, metadataBundle);
            module.setDescription(description);
            MetadataFactory.processProperties(moduleEl, module, metadataBundle);
            for (Element altNameEl : moduleEl.elements("alternative-name")) {
                String alternativeName = altNameEl.attributeValue("internal-name");
                sAlternativeNamesMap.put(alternativeName, module);
                module.addAlternativeName(alternativeName);
            }
            for (Element quickfixEl : moduleEl.elements("quickfix")) {
                String quickfixClassName = quickfixEl.attributeValue("classname");
                module.addQuickfix(quickfixClassName);
            }
            for (Element quickfixEl : moduleEl.elements("message-key")) {
                String messageKey = quickfixEl.attributeValue("key");
                module.addMessageKey(messageKey);
            }
            groupMetadata.getRuleMetadata().add(module);
        }
    }

    private static void processProperties(Element moduleElement, RuleMetadata moduleMetadata, ResourceBundle metadataBundle) throws CheckstylePluginException {
        List propertyElements = moduleElement.elements("property-metadata");
        for (Element propertyEl : propertyElements) {
            String overrideDefaultValue;
            ConfigPropertyType type = ConfigPropertyType.valueOf(propertyEl.attributeValue("datatype"));
            String name = propertyEl.attributeValue("name").trim();
            String defaultValue = propertyEl.attributeValue("default-value");
            if (defaultValue != null) {
                defaultValue = defaultValue.trim();
            }
            if ((overrideDefaultValue = propertyEl.attributeValue("override-default-value")) != null) {
                overrideDefaultValue = overrideDefaultValue.trim();
            }
            ConfigPropertyMetadata property = new ConfigPropertyMetadata(type, name, defaultValue, overrideDefaultValue);
            moduleMetadata.getPropertyMetadata().add(property);
            String description = propertyEl.elementTextTrim("description");
            description = MetadataFactory.localize(description, metadataBundle);
            property.setDescription(description);
            Element enumEl = propertyEl.element("enumeration");
            if (enumEl == null) continue;
            String optionProvider = enumEl.attributeValue("option-provider");
            if (optionProvider != null) {
                try {
                    Class<?> providerClass = CheckstylePlugin.getDefault().getAddonExtensionClassLoader().loadClass(optionProvider);
                    if (IOptionProvider.class.isAssignableFrom(providerClass)) {
                        IOptionProvider provider = (IOptionProvider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        property.getPropertyEnumeration().addAll(provider.getOptions());
                    } else if (Enum.class.isAssignableFrom(providerClass)) {
                        EnumSet<Enum> values = EnumSet.allOf(providerClass);
                        for (Enum e : values) {
                            property.getPropertyEnumeration().add(e.name().toLowerCase());
                        }
                    }
                }
                catch (ReflectiveOperationException ex) {
                    CheckstylePluginException.rethrow(ex);
                }
            }
            for (Element optionEl : enumEl.elements("property-value-option")) {
                property.getPropertyEnumeration().add(optionEl.attributeValue("value"));
            }
        }
    }

    private static String localize(String localizationCandidate, ResourceBundle metadataBundle) {
        if (metadataBundle != null && localizationCandidate != null && localizationCandidate.startsWith("%")) {
            try {
                return metadataBundle.getString(localizationCandidate.substring(1));
            }
            catch (MissingResourceException ex) {
                return localizationCandidate;
            }
        }
        return localizationCandidate;
    }

    private static class UTF8Control
    extends ResourceBundle.Control {
        private UTF8Control() {
        }

        @Override
        public ResourceBundle newBundle(String aBaseName, Locale aLocale, String aFormat, ClassLoader aLoader, boolean aReload) throws IOException {
            String bundleName = this.toBundleName(aBaseName, aLocale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (aReload) {
                URLConnection connection;
                URL url = aLoader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = aLoader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                Reader streamReader = null;
                try {
                    streamReader = new InputStreamReader(stream, "UTF-8");
                    bundle = new PropertyResourceBundle(streamReader);
                }
                finally {
                    streamReader.close();
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

