/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.builder.CheckstyleBuilder;
import net.sf.eclipsecs.core.jobs.AbstractCheckJob;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationFactory;
import net.sf.eclipsecs.core.projectconfig.filters.IFilter;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class RunCheckstyleOnFilesJob
extends AbstractCheckJob {
    private List<IFile> mFilesToCheck;

    public RunCheckstyleOnFilesJob(List<IFile> files) {
        super(Messages.RunCheckstyleOnFilesJob_title);
        this.mFilesToCheck = new ArrayList<IFile>(files);
        this.setRule(this);
    }

    public RunCheckstyleOnFilesJob(IFile file) {
        super(Messages.RunCheckstyleOnFilesJob_title);
        this.mFilesToCheck = new ArrayList<IFile>();
        this.mFilesToCheck.add(file);
        this.setRule(this);
    }

    public boolean contains(ISchedulingRule arg0) {
        return arg0 instanceof RunCheckstyleOnFilesJob;
    }

    public final IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            Map<IProject, List<IFile>> projectFilesMap = RunCheckstyleOnFilesJob.getFilesSortedToProject(this.mFilesToCheck);
            for (Map.Entry<IProject, List<IFile>> entry : projectFilesMap.entrySet()) {
                IProject project = entry.getKey();
                List<IFile> files = entry.getValue();
                IProjectConfiguration checkConfig = ProjectConfigurationFactory.getConfiguration(project);
                RunCheckstyleOnFilesJob.filter(files, checkConfig);
                CheckstyleBuilder builder = new CheckstyleBuilder();
                builder.handleBuildSelection(files, checkConfig, monitor, project, 10);
            }
        }
        catch (CheckstylePluginException ex) {
            Status status = new Status(4, "net.sf.eclipsecs.core", 4, ex.getLocalizedMessage(), (Throwable)ex);
            throw new CoreException((IStatus)status);
        }
        return Status.OK_STATUS;
    }

    private static Map<IProject, List<IFile>> getFilesSortedToProject(List<IFile> filesToCheck) {
        HashMap<IProject, List<IFile>> projectFilesMap = new HashMap<IProject, List<IFile>>();
        int i = 0;
        int size = filesToCheck.size();
        while (i < size) {
            IFile file = filesToCheck.get(i);
            IProject project = file.getProject();
            ArrayList<IFile> projectFiles = (ArrayList<IFile>)projectFilesMap.get(project);
            if (projectFiles == null) {
                projectFiles = new ArrayList<IFile>();
                projectFilesMap.put(project, projectFiles);
            }
            projectFiles.add(file);
            ++i;
        }
        return projectFilesMap;
    }

    private static void filter(List<IFile> files, IProjectConfiguration projectConfig) {
        List<IFilter> filters = projectConfig.getFilters();
        for (IFilter filter : filters) {
            Iterator<IFile> filesIt = files.iterator();
            while (filesIt.hasNext()) {
                IFile file = filesIt.next();
                if (!filter.isEnabled() || filter.accept(file)) continue;
                filesIt.remove();
            }
        }
    }
}

