/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.projectconfig;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.config.CheckConfigurationFactory;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ICheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.config.ResolvableProperty;
import net.sf.eclipsecs.core.config.configtypes.BuiltInConfigurationType;
import net.sf.eclipsecs.core.config.configtypes.ProjectConfigurationType;
import net.sf.eclipsecs.core.projectconfig.FileMatchPattern;
import net.sf.eclipsecs.core.projectconfig.FileSet;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.LocalCheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.projectconfig.PluginFilters;
import net.sf.eclipsecs.core.projectconfig.filters.IFilter;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.core.util.XMLUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ProjectConfigurationWorkingCopy
implements Cloneable,
IProjectConfiguration {
    private final IProjectConfiguration mProjectConfig;
    private final ICheckConfigurationWorkingSet mLocalConfigWorkingSet;
    private final ICheckConfigurationWorkingSet mGlobalConfigWorkingSet;
    private List<FileSet> mFileSets = new LinkedList<FileSet>();
    private List<IFilter> mFilters = new LinkedList<IFilter>();
    private boolean mUseSimpleConfig;
    private boolean mSyncFormatter;

    public ProjectConfigurationWorkingCopy(IProjectConfiguration projectConfig) {
        this.mProjectConfig = projectConfig;
        this.mLocalConfigWorkingSet = new LocalCheckConfigurationWorkingSet(this, projectConfig.getLocalCheckConfigurations());
        this.mGlobalConfigWorkingSet = CheckConfigurationFactory.newWorkingSet();
        for (FileSet fileSet : projectConfig.getFileSets()) {
            this.mFileSets.add(fileSet.clone());
        }
        List<IFilter> standardFilters = Arrays.asList(PluginFilters.getConfiguredFilters());
        this.mFilters = new ArrayList<IFilter>(standardFilters);
        List<IFilter> configuredFilters = projectConfig.getFilters();
        int i = 0;
        int size = this.mFilters.size();
        while (i < size) {
            IFilter standardFilter = this.mFilters.get(i);
            int j = 0;
            int size2 = configuredFilters.size();
            while (j < size2) {
                IFilter configuredFilter = configuredFilters.get(j);
                if (standardFilter.getInternalName().equals(configuredFilter.getInternalName())) {
                    this.mFilters.set(i, configuredFilter.clone());
                }
                ++j;
            }
            ++i;
        }
        this.mUseSimpleConfig = projectConfig.isUseSimpleConfig();
        this.mSyncFormatter = projectConfig.isSyncFormatter();
    }

    public ICheckConfigurationWorkingSet getLocalCheckConfigWorkingSet() {
        return this.mLocalConfigWorkingSet;
    }

    public ICheckConfigurationWorkingSet getGlobalCheckConfigWorkingSet() {
        return this.mGlobalConfigWorkingSet;
    }

    public ICheckConfiguration getLocalCheckConfigByName(String name) {
        CheckConfigurationWorkingCopy config = null;
        CheckConfigurationWorkingCopy[] configs = this.mLocalConfigWorkingSet.getWorkingCopies();
        int i = 0;
        while (i < configs.length) {
            if (configs[i].getName().equals(name)) {
                config = configs[i];
                break;
            }
            ++i;
        }
        return config;
    }

    public ICheckConfiguration getGlobalCheckConfigByName(String name) {
        CheckConfigurationWorkingCopy config = null;
        CheckConfigurationWorkingCopy[] configs = this.mGlobalConfigWorkingSet.getWorkingCopies();
        int i = 0;
        while (i < configs.length) {
            if (configs[i].getName().equals(name)) {
                config = configs[i];
                break;
            }
            ++i;
        }
        return config;
    }

    public void setUseSimpleConfig(boolean useSimpleConfig) {
        this.mUseSimpleConfig = useSimpleConfig;
    }

    public void setSyncFormatter(boolean syncFormatter) {
        this.mSyncFormatter = syncFormatter;
    }

    public boolean isDirty() {
        return !this.equals(this.mProjectConfig) || this.mLocalConfigWorkingSet.isDirty();
    }

    public boolean isRebuildNeeded() throws CheckstylePluginException {
        return !this.equals(this.mProjectConfig) || this.mLocalConfigWorkingSet.getAffectedProjects().contains(this.getProject()) || this.mGlobalConfigWorkingSet.getAffectedProjects().contains(this.getProject());
    }

    public void store() throws CheckstylePluginException {
        this.storeToPersistence(this);
    }

    @Override
    public IProject getProject() {
        return this.mProjectConfig.getProject();
    }

    public List<ICheckConfiguration> getLocalCheckConfigurations() {
        ArrayList<ICheckConfiguration> list = new ArrayList<ICheckConfiguration>();
        Collections.addAll(list, this.mLocalConfigWorkingSet.getWorkingCopies());
        return list;
    }

    @Override
    public List<FileSet> getFileSets() {
        return this.mFileSets;
    }

    @Override
    public List<IFilter> getFilters() {
        return this.mFilters;
    }

    @Override
    public boolean isUseSimpleConfig() {
        return this.mUseSimpleConfig;
    }

    @Override
    public boolean isSyncFormatter() {
        return this.mSyncFormatter;
    }

    @Override
    public boolean isConfigInUse(ICheckConfiguration configuration) {
        boolean result = false;
        for (FileSet fileSet : this.getFileSets()) {
            ICheckConfiguration checkConfig = fileSet.getCheckConfig();
            if (!configuration.equals(checkConfig) && (!(checkConfig instanceof CheckConfigurationWorkingCopy) || !configuration.equals(((CheckConfigurationWorkingCopy)checkConfig).getSourceCheckConfiguration()))) continue;
            result = true;
            break;
        }
        return result;
    }

    public Object clone() {
        ProjectConfigurationWorkingCopy clone = null;
        try {
            clone = (ProjectConfigurationWorkingCopy)super.clone();
            clone.mFileSets = new LinkedList<FileSet>();
            clone.setUseSimpleConfig(this.isUseSimpleConfig());
            clone.setSyncFormatter(this.isSyncFormatter());
            for (FileSet fileSet : this.getFileSets()) {
                clone.getFileSets().add(fileSet.clone());
            }
            ArrayList<IFilter> clonedFilters = new ArrayList<IFilter>();
            for (IFilter filter : this.getFilters()) {
                clonedFilters.add(filter.clone());
            }
            clone.mFilters = clonedFilters;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IProjectConfiguration)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        IProjectConfiguration rhs = (IProjectConfiguration)obj;
        return Objects.equals(this.getProject(), rhs.getProject()) && this.isUseSimpleConfig() == rhs.isUseSimpleConfig() && this.isSyncFormatter() == rhs.isSyncFormatter() && Objects.equals(this.getFileSets(), rhs.getFileSets()) && Objects.equals(this.getFilters(), rhs.getFilters());
    }

    public int hashCode() {
        return Objects.hash(this.mProjectConfig, this.mUseSimpleConfig, this.mFileSets, this.mFilters);
    }

    private void storeToPersistence(ProjectConfigurationWorkingCopy config) throws CheckstylePluginException {
        try {
            Document docu = this.writeProjectConfig(config);
            byte[] data = XMLUtil.toByteArray(docu);
            ByteArrayInputStream pipeIn = new ByteArrayInputStream(data);
            IProject project = config.getProject();
            IFile file = project.getFile(".checkstyle");
            if (file.exists()) {
                if (file.isReadOnly()) {
                    ResourceAttributes attrs = ResourceAttributes.fromFile((File)file.getFullPath().toFile());
                    attrs.setReadOnly(true);
                    file.setResourceAttributes(attrs);
                }
                file.setContents((InputStream)pipeIn, true, true, null);
            } else {
                file.create((InputStream)pipeIn, true, null);
                file.refreshLocal(2, null);
            }
            config.getLocalCheckConfigWorkingSet().store();
        }
        catch (Exception ex) {
            CheckstylePluginException.rethrow(ex, NLS.bind((String)Messages.errorWritingCheckConfigurations, (Object)ex.getLocalizedMessage()));
        }
    }

    private Document writeProjectConfig(ProjectConfigurationWorkingCopy config) throws CheckstylePluginException {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("fileset-config");
        root.addAttribute("file-format-version", "1.2.0");
        root.addAttribute("simple-config", Boolean.toString(config.isUseSimpleConfig()));
        root.addAttribute("sync-formatter", Boolean.toString(config.isSyncFormatter()));
        CheckConfigurationWorkingCopy[] workingCopies = config.getLocalCheckConfigWorkingSet().getWorkingCopies();
        int i = 0;
        while (i < workingCopies.length) {
            this.writeLocalConfiguration(workingCopies[i], root);
            ++i;
        }
        for (FileSet fileSet : config.getFileSets()) {
            this.writeFileSet(fileSet, config.getProject(), root);
        }
        for (IFilter filter : config.getFilters()) {
            this.writeFilter(filter, root);
        }
        return doc;
    }

    private void writeLocalConfiguration(ICheckConfiguration checkConfig, Element docRoot) {
        IWorkspaceRoot iWorkspaceRoot;
        IFile configFile;
        IProject configFileProject;
        IProject project;
        if (checkConfig.getType() instanceof BuiltInConfigurationType || checkConfig.isGlobal()) {
            return;
        }
        String location = checkConfig.getLocation();
        if (checkConfig.getType() instanceof ProjectConfigurationType && (project = this.mProjectConfig.getProject()).equals((Object)(configFileProject = (configFile = (iWorkspaceRoot = project.getWorkspace().getRoot()).getFile((IPath)new Path(location))).getProject()))) {
            location = configFile.getProjectRelativePath().toString();
        }
        Element configEl = docRoot.addElement("local-check-config");
        configEl.addAttribute("name", checkConfig.getName());
        configEl.addAttribute("location", location);
        configEl.addAttribute("type", checkConfig.getType().getInternalName());
        if (checkConfig.getDescription() != null) {
            configEl.addAttribute("description", checkConfig.getDescription());
        }
        for (ResolvableProperty resolvableProperty : checkConfig.getResolvableProperties()) {
            Element propEl = configEl.addElement("property");
            propEl.addAttribute("name", resolvableProperty.getPropertyName());
            propEl.addAttribute("value", resolvableProperty.getValue());
        }
        for (Map.Entry entry : checkConfig.getAdditionalData().entrySet()) {
            Element addEl = configEl.addElement("additional-data");
            addEl.addAttribute("name", (String)entry.getKey());
            addEl.addAttribute("value", (String)entry.getValue());
        }
    }

    private void writeFileSet(FileSet fileSet, IProject project, Element docRoot) throws CheckstylePluginException {
        if (fileSet.getCheckConfig() == null) {
            throw new CheckstylePluginException(NLS.bind((String)Messages.errorFilesetWithoutCheckConfig, (Object)fileSet.getName(), (Object)project.getName()));
        }
        Element fileSetEl = docRoot.addElement("fileset");
        fileSetEl.addAttribute("name", fileSet.getName());
        fileSetEl.addAttribute("enabled", Boolean.toString(fileSet.isEnabled()));
        ICheckConfiguration checkConfig = fileSet.getCheckConfig();
        if (checkConfig != null) {
            fileSetEl.addAttribute("check-config-name", checkConfig.getName());
            fileSetEl.addAttribute("local", Boolean.toString(!checkConfig.isGlobal()));
        }
        for (FileMatchPattern pattern : fileSet.getFileMatchPatterns()) {
            Element patternEl = fileSetEl.addElement("file-match-pattern");
            patternEl.addAttribute("match-pattern", pattern.getMatchPattern() != null ? pattern.getMatchPattern() : "");
            patternEl.addAttribute("include-pattern", Boolean.toString(pattern.isIncludePattern()));
        }
    }

    private void writeFilter(IFilter filter, Element docRoot) {
        IFilter prototype = PluginFilters.getByInternalName(filter.getInternalName());
        if (prototype.equals(filter)) {
            return;
        }
        Element filterEl = docRoot.addElement("filter");
        filterEl.addAttribute("name", filter.getInternalName());
        filterEl.addAttribute("enabled", Boolean.toString(filter.isEnabled()));
        List<String> data = filter.getFilterData();
        if (data != null && !data.isEmpty()) {
            for (String item : data) {
                Element dataEl = filterEl.addElement("filter-data");
                dataEl.addAttribute("value", item);
            }
        }
    }
}

