/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.transformer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import net.sf.eclipsecs.core.transformer.CheckstyleSetting;
import net.sf.eclipsecs.core.util.CheckstyleLog;

public class CheckstyleFileWriter {
    private final CheckstyleSetting mCheckstyleSetting;

    public CheckstyleFileWriter(CheckstyleSetting setting, String file) {
        this.mCheckstyleSetting = setting;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fw = new FileOutputStream(file);){
                this.writeXMLFile(fw);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            CheckstyleLog.log(ex);
        }
    }

    private void writeXMLFile(OutputStream outStream) throws IOException {
        outStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes("UTF-8"));
        outStream.write("<module name=\"Checker\">\n".getBytes("UTF-8"));
        outStream.write("<property name=\"severity\" value=\"warning\"/>\n".getBytes("UTF-8"));
        CheckstyleFileWriter.writeModules(this.mCheckstyleSetting.getmCheckerModules(), outStream);
        outStream.write("<module name=\"TreeWalker\">\n".getBytes("UTF-8"));
        CheckstyleFileWriter.writeModules(this.mCheckstyleSetting.getmTreeWalkerModules(), outStream);
        outStream.write("</module>\n".getBytes("UTF-8"));
        outStream.write("</module>\n".getBytes("UTF-8"));
    }

    private static void writeModules(HashMap<String, HashMap<String, String>> modules, OutputStream outStream) throws IOException {
        for (String module : modules.keySet()) {
            if (modules.get(module) == null) {
                outStream.write(("<module name=\"" + module + "\"/>\n").getBytes("UTF-8"));
                continue;
            }
            outStream.write(("<module name=\"" + module + "\">\n").getBytes("UTF-8"));
            CheckstyleFileWriter.writeProperty(modules.get(module), outStream);
            outStream.write("</module>\n".getBytes("UTF-8"));
        }
    }

    private static void writeProperty(HashMap<String, String> properties, OutputStream outStream) throws IOException {
        for (String prop : properties.keySet()) {
            outStream.write(("<property name=\"" + prop + "\" value=\"" + properties.get(prop) + "\"/>\n").getBytes("UTF-8"));
        }
    }
}

