/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.transformer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XmlProfileWriter {
    private static final String XML_NODE_ROOT = "profiles";
    private static final String XML_NODE_PROFILE = "profile";
    private static final String XML_NODE_SETTING = "setting";
    private static final String XML_ATTRIBUTE_VERSION = "version";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_PROFILE_KIND = "kind";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private static final String CLEANUP_PROFILE_VERSION = "2";
    private static final String CLEANUP_PROFILE_KIND = "CleanUpProfile";
    private static final String FORMATTER_PROFILE_VERSION = "10";
    private static final String FORMATTER_PROFILE_KIND = "CodeFormatterProfile";

    private XmlProfileWriter() {
    }

    public static InputStream writeCleanupProfileToStream(String name, Map<String, String> settings) throws TransformerException, ParserConfigurationException {
        return XmlProfileWriter.writeProfileToStream(name, CLEANUP_PROFILE_VERSION, CLEANUP_PROFILE_KIND, settings);
    }

    public static InputStream writeFormatterProfileToStream(String name, Map<String, String> settings) throws TransformerException, ParserConfigurationException {
        return XmlProfileWriter.writeProfileToStream(name, FORMATTER_PROFILE_VERSION, FORMATTER_PROFILE_KIND, settings);
    }

    private static InputStream writeProfileToStream(String name, String profileVersion, String profileKind, Map<String, String> settings) throws TransformerException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = document.createElement(XML_NODE_ROOT);
        rootElement.setAttribute(XML_ATTRIBUTE_VERSION, profileVersion);
        document.appendChild(rootElement);
        Element profileElement = document.createElement(XML_NODE_PROFILE);
        profileElement.setAttribute(XML_ATTRIBUTE_NAME, name);
        profileElement.setAttribute(XML_ATTRIBUTE_VERSION, profileVersion);
        profileElement.setAttribute(XML_ATTRIBUTE_PROFILE_KIND, profileKind);
        for (String key : settings.keySet()) {
            String value = settings.get(key);
            if (value != null) {
                Element setting = document.createElement(XML_NODE_SETTING);
                setting.setAttribute(XML_ATTRIBUTE_ID, key);
                setting.setAttribute(XML_ATTRIBUTE_VALUE, value);
                profileElement.appendChild(setting);
                continue;
            }
            CheckstyleLog.log(null, String.format("Profile is missing value for [key=%s]", key));
        }
        rootElement.appendChild(profileElement);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return new ByteArrayInputStream(writer.toString().getBytes());
    }
}

