/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui;

import java.util.function.Supplier;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public enum CheckstyleUIPluginImages {
    PLUGIN_LOGO(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/eclipse-cs-little.png")),
    MARKER_ERROR(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/checkstyle_error.gif")),
    MARKER_WARNING(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/checkstyle_warning.gif")),
    MARKER_INFO(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/checkstyle_info.gif")),
    HELP_ICON(() -> PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_LCL_LINKTO_HELP")),
    CORRECTION_ADD(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/add_correction.gif")),
    CORRECTION_CHANGE(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/correction_change.gif")),
    CORRECTION_REMOVE(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/remove_correction.gif")),
    TICK_ICON(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/tick.gif")),
    FILTER_ICON(() -> ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.ui.ide", (String)"platform:/plugin/org.eclipse.ui.ide/icons/full/elcl16/filter_ps.png").orElse(MARKER_ERROR.getImageDescriptor())),
    LIST_VIEW_ICON(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/listingView.gif")),
    GRAPH_VIEW_ICON(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/graphView.gif")),
    EXPORT_REPORT_ICON(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/exportReport.gif")),
    MODULEGROUP_ICON(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/modulegroup.gif")),
    MODULEGROUP_TICKED_ICON(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/modulegroup_used.gif")),
    MODULE_ICON(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/module.gif")),
    MODULE_TICKED_ICON(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/module_used.gif")),
    REFRESH_ICON(() -> ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.search", (String)"platform:/plugin/org.eclipse.search/icons/full/elcl16/refresh.png").orElse(MARKER_ERROR.getImageDescriptor())),
    CHECKSTYLE_ICON(() -> AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)"icons/checkstyle_command.png"));

    private Supplier<ImageDescriptor> factory;
    private ImageDescriptor imageDescriptor;
    private Image image;

    private CheckstyleUIPluginImages(Supplier<ImageDescriptor> factory) {
        this.factory = factory;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor == null) {
            this.imageDescriptor = this.factory.get();
        }
        return this.imageDescriptor;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = this.getImageDescriptor().createImage();
        }
        return this.image;
    }

    public static void clearCachedImages() {
        CheckstyleUIPluginImages[] checkstyleUIPluginImagesArray = CheckstyleUIPluginImages.values();
        int n = checkstyleUIPluginImagesArray.length;
        int n2 = 0;
        while (n2 < n) {
            CheckstyleUIPluginImages value = checkstyleUIPluginImagesArray[n2];
            if (value.image != null) {
                value.image.dispose();
            }
            ++n2;
        }
    }
}

