/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui;

import net.sf.eclipsecs.core.util.CheckstyleLog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class CheckstyleUIPluginPrefs
extends AbstractPreferenceInitializer {
    public static final String PREF_FILESET_WARNING = "warn.before.losing.filesets";
    public static final String PREF_ASK_BEFORE_REBUILD = "ask.before.rebuild";
    public static final String PREF_TRANSLATE_TOKENS = "translate.checkstyle.tokens";
    public static final String PREF_SORT_TOKENS = "translate.sort.tokens";
    public static final String PREF_OPEN_MODULE_EDITOR = "open.module.editor.on.add";
    public static final String PREF_DUPLICATED_CODE_MIN_LINES = "checker.strictDuplicatedCode.minLines";
    public static final int DUPLICATED_CODE_MIN_LINES = 20;
    public static final String PREF_STATS_SHOW_ALL_CATEGORIES = "show_all_categories";

    public void initializeDefaultPreferences() {
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode("net.sf.eclipsecs.ui");
        prefs.putBoolean(PREF_FILESET_WARNING, true);
        prefs.put(PREF_ASK_BEFORE_REBUILD, "prompt");
        prefs.putBoolean(PREF_TRANSLATE_TOKENS, true);
        prefs.putBoolean(PREF_SORT_TOKENS, false);
        prefs.putBoolean(PREF_OPEN_MODULE_EDITOR, true);
        prefs.putInt(PREF_DUPLICATED_CODE_MIN_LINES, 20);
        prefs.putBoolean(PREF_STATS_SHOW_ALL_CATEGORIES, false);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            CheckstyleLog.log((Throwable)ex);
        }
    }

    public static String getString(String prefId) {
        IPreferencesService prefs = Platform.getPreferencesService();
        return prefs.getString("net.sf.eclipsecs.ui", prefId, null, null);
    }

    public static boolean getBoolean(String prefId) {
        IPreferencesService prefs = Platform.getPreferencesService();
        return prefs.getBoolean("net.sf.eclipsecs.ui", prefId, false, null);
    }

    public static int getInt(String prefId) {
        IPreferencesService prefs = Platform.getPreferencesService();
        return prefs.getInt("net.sf.eclipsecs.ui", prefId, 0, null);
    }

    public static void setString(String prefId, String value) throws BackingStoreException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("net.sf.eclipsecs.ui");
        prefs.put(prefId, value);
        prefs.flush();
    }

    public static void setBoolean(String prefId, boolean value) throws BackingStoreException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("net.sf.eclipsecs.ui");
        prefs.putBoolean(prefId, value);
        prefs.flush();
    }

    public static void setInt(String prefId, int value) throws BackingStoreException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("net.sf.eclipsecs.ui");
        prefs.putInt(prefId, value);
        prefs.flush();
    }
}

