/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.actions;

import java.util.Collection;
import java.util.List;
import net.sf.eclipsecs.ui.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ClearSelectedFilesAction
implements IObjectActionDelegate {
    private IStructuredSelection mSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.mSelection = (IStructuredSelection)selection;
        }
    }

    public void run(IAction action) {
        List resourcesToClear = this.mSelection.toList();
        ClearMarkersJob job = new ClearMarkersJob(resourcesToClear);
        job.schedule();
    }

    private static class ClearMarkersJob
    extends WorkspaceJob {
        private Collection<IResource> mResourcesToClear;

        public ClearMarkersJob(Collection<IResource> resourcesToClear) {
            super(Messages.ClearSelectedFilesAction_title);
            this.mResourcesToClear = resourcesToClear;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            for (IResource resource : this.mResourcesToClear) {
                if (!resource.isAccessible()) continue;
                resource.deleteMarkers("net.sf.eclipsecs.core.CheckstyleMarker", true, 2);
            }
            return Status.OK_STATUS;
        }
    }
}

