/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config;

import java.io.File;
import java.util.ArrayList;
import net.sf.eclipsecs.core.config.CheckConfigurationFactory;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.GlobalCheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ICheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationFactory;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.CheckConfigurationConfigureDialog;
import net.sf.eclipsecs.ui.config.CheckConfigurationLabelProvider;
import net.sf.eclipsecs.ui.config.CheckConfigurationPropertiesDialog;
import net.sf.eclipsecs.ui.util.table.EnhancedTableViewer;
import net.sf.eclipsecs.ui.util.table.ITableComparableProvider;
import net.sf.eclipsecs.ui.util.table.ITableSettingsProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CheckConfigurationWorkingSetEditor {
    private final PageController mController = new PageController();
    private final ICheckConfigurationWorkingSet mWorkingSet;
    private final boolean mIsShowUsage;
    private EnhancedTableViewer mViewer;
    private Button mAddButton;
    private Button mEditButton;
    private Button mConfigureButton;
    private Button mCopyButton;
    private Button mRemoveButton;
    private Button mDefaultButton;
    private Button mExportButton;
    private Text mConfigurationDescription;
    private StructuredViewer mUsageView;

    public CheckConfigurationWorkingSetEditor(ICheckConfigurationWorkingSet workingSet, boolean showUsage) {
        this.mWorkingSet = workingSet;
        this.mIsShowUsage = showUsage;
    }

    public Control createContents(Composite ancestor) {
        Composite configComposite = this.createCheckConfigContents(ancestor);
        return configComposite;
    }

    private Composite createCheckConfigContents(Composite parent) {
        Composite configComposite = new Composite(parent, 0);
        configComposite.setLayout((Layout)new FormLayout());
        Control rightButtons = this.createButtonBar(configComposite);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        rightButtons.setLayoutData((Object)formData);
        Composite tableAndDesc = new Composite(configComposite, 0);
        tableAndDesc.setLayout((Layout)new FormLayout());
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment(0);
        formData.right = new FormAttachment(rightButtons, -3, 16384);
        formData.bottom = new FormAttachment(100, 0);
        tableAndDesc.setLayoutData((Object)formData);
        Control table = this.createConfigTable(tableAndDesc);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(70);
        table.setLayoutData((Object)formData);
        Composite descArea = new Composite(tableAndDesc, 0);
        descArea.setLayout((Layout)new FormLayout());
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment(table, 0);
        formData.right = new FormAttachment(this.mIsShowUsage ? 60 : 100);
        formData.bottom = new FormAttachment(100);
        descArea.setLayoutData((Object)formData);
        Label lblDescription = new Label(descArea, 0);
        lblDescription.setText(Messages.CheckstylePreferencePage_lblDescription);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment(3);
        formData.right = new FormAttachment(100);
        lblDescription.setLayoutData((Object)formData);
        this.mConfigurationDescription = new Text(descArea, 19018);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment((Control)lblDescription);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        this.mConfigurationDescription.setLayoutData((Object)formData);
        if (this.mIsShowUsage) {
            Composite usageArea = new Composite(tableAndDesc, 0);
            usageArea.setLayout((Layout)new FormLayout());
            formData = new FormData();
            formData.left = new FormAttachment(60, 0);
            formData.top = new FormAttachment(table, 3);
            formData.right = new FormAttachment(100);
            formData.bottom = new FormAttachment(100);
            usageArea.setLayoutData((Object)formData);
            Label lblUsage = new Label(usageArea, 0);
            lblUsage.setText(Messages.CheckstylePreferencePage_lblProjectUsage);
            formData = new FormData();
            formData.left = new FormAttachment(0);
            formData.top = new FormAttachment(0);
            formData.right = new FormAttachment(100);
            lblUsage.setLayoutData((Object)formData);
            this.mUsageView = new TableViewer(usageArea);
            this.mUsageView.getControl().setBackground(usageArea.getBackground());
            this.mUsageView.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.mUsageView.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            formData = new FormData();
            formData.left = new FormAttachment(0);
            formData.top = new FormAttachment((Control)lblUsage);
            formData.right = new FormAttachment(100);
            formData.bottom = new FormAttachment(100);
            this.mUsageView.getControl().setLayoutData((Object)formData);
        }
        this.mController.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.mViewer, (ISelection)new StructuredSelection()));
        return configComposite;
    }

    private Control createConfigTable(Composite parent) {
        Table table = new Table(parent, 67588);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.CheckstylePreferencePage_colCheckConfig);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.CheckstylePreferencePage_colLocation);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(Messages.CheckstylePreferencePage_colType);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        if (this.mWorkingSet instanceof GlobalCheckConfigurationWorkingSet) {
            TableColumn column4 = new TableColumn(table, 0);
            column4.setText(Messages.CheckstylePreferencePage_colDefault);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(12));
        }
        this.mViewer = new EnhancedTableViewer(table);
        ConfigurationLabelProvider multiProvider = new ConfigurationLabelProvider();
        this.mViewer.setLabelProvider((IBaseLabelProvider)multiProvider);
        this.mViewer.setTableComparableProvider(multiProvider);
        this.mViewer.setTableSettingsProvider(multiProvider);
        this.mViewer.installEnhancements();
        this.mViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mViewer.setInput(this.mWorkingSet.getWorkingCopies());
        this.mViewer.addDoubleClickListener(this.mController);
        this.mViewer.addSelectionChangedListener(this.mController);
        return table;
    }

    private Control createButtonBar(Composite parent) {
        Composite rightButtons = new Composite(parent, 0);
        rightButtons.setLayout((Layout)new FormLayout());
        this.mAddButton = new Button(rightButtons, 8);
        this.mAddButton.setText(Messages.CheckstylePreferencePage_btnNew);
        this.mAddButton.addSelectionListener((SelectionListener)this.mController);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.mAddButton.setLayoutData((Object)formData);
        this.mEditButton = new Button(rightButtons, 8);
        this.mEditButton.setText(Messages.CheckstylePreferencePage_btnProperties);
        this.mEditButton.addSelectionListener((SelectionListener)this.mController);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment((Control)this.mAddButton, 3, 1024);
        formData.right = new FormAttachment(100);
        this.mEditButton.setLayoutData((Object)formData);
        this.mConfigureButton = new Button(rightButtons, 8);
        this.mConfigureButton.setText(Messages.CheckstylePreferencePage_btnConfigure);
        this.mConfigureButton.addSelectionListener((SelectionListener)this.mController);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment((Control)this.mEditButton, 3, 1024);
        formData.right = new FormAttachment(100);
        this.mConfigureButton.setLayoutData((Object)formData);
        this.mCopyButton = new Button(rightButtons, 8);
        this.mCopyButton.setText(Messages.CheckstylePreferencePage_btnCopy);
        this.mCopyButton.addSelectionListener((SelectionListener)this.mController);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment((Control)this.mConfigureButton, 3, 1024);
        formData.right = new FormAttachment(100);
        this.mCopyButton.setLayoutData((Object)formData);
        this.mRemoveButton = new Button(rightButtons, 8);
        this.mRemoveButton.setText(Messages.CheckstylePreferencePage_btnRemove);
        this.mRemoveButton.addSelectionListener((SelectionListener)this.mController);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment((Control)this.mCopyButton, 3, 1024);
        formData.right = new FormAttachment(100);
        this.mRemoveButton.setLayoutData((Object)formData);
        this.mDefaultButton = new Button(rightButtons, 8);
        this.mDefaultButton.setText(Messages.CheckstylePreferencePage_btnDefault);
        this.mDefaultButton.addSelectionListener((SelectionListener)this.mController);
        this.mDefaultButton.setToolTipText(Messages.CheckstylePreferencePage_txtDefault);
        if (this.mWorkingSet instanceof GlobalCheckConfigurationWorkingSet) {
            formData = new FormData();
            formData.left = new FormAttachment(0);
            formData.top = new FormAttachment((Control)this.mRemoveButton, 3, 1024);
            formData.right = new FormAttachment(100);
            this.mDefaultButton.setLayoutData((Object)formData);
        }
        this.mExportButton = new Button(rightButtons, 8);
        this.mExportButton.setText(Messages.CheckstylePreferencePage_btnExport);
        this.mExportButton.addSelectionListener((SelectionListener)this.mController);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        this.mExportButton.setLayoutData((Object)formData);
        return rightButtons;
    }

    private Shell getShell() {
        return this.mViewer.getControl().getShell();
    }

    private void addCheckConfig() {
        CheckConfigurationPropertiesDialog dialog = new CheckConfigurationPropertiesDialog(this.getShell(), null, this.mWorkingSet);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            CheckConfigurationWorkingCopy newConfig = dialog.getCheckConfiguration();
            this.mWorkingSet.addCheckConfiguration(newConfig);
            this.mViewer.setInput(this.mWorkingSet.getWorkingCopies());
            this.mViewer.refresh(true);
            this.mViewer.setSelection((ISelection)new StructuredSelection((Object)newConfig));
        }
    }

    private void editCheckConfig() {
        CheckConfigurationWorkingCopy config = (CheckConfigurationWorkingCopy)((IStructuredSelection)this.mViewer.getSelection()).getFirstElement();
        if (config != null) {
            CheckConfigurationPropertiesDialog dialog = new CheckConfigurationPropertiesDialog(this.getShell(), config, this.mWorkingSet);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                this.mViewer.refresh(true);
            }
        }
    }

    private void configureCheckConfig() {
        CheckConfigurationWorkingCopy config = (CheckConfigurationWorkingCopy)((IStructuredSelection)this.mViewer.getSelection()).getFirstElement();
        if (config != null) {
            try {
                config.getCheckstyleConfiguration();
                CheckConfigurationConfigureDialog dialog = new CheckConfigurationConfigureDialog(this.getShell(), config);
                dialog.setBlockOnOpen(true);
                dialog.open();
            }
            catch (CheckstylePluginException ex) {
                CheckstyleUIPlugin.warningDialog(this.getShell(), NLS.bind((String)Messages.errorCannotResolveCheckLocation, (Object)config.getLocation(), (Object)config.getName()), ex);
            }
        }
    }

    private void copyCheckConfig() {
        IStructuredSelection selection = (IStructuredSelection)this.mViewer.getSelection();
        ICheckConfiguration sourceConfig = (ICheckConfiguration)selection.getFirstElement();
        if (sourceConfig == null) {
            return;
        }
        try {
            CheckConfigurationPropertiesDialog dialog = new CheckConfigurationPropertiesDialog(this.getShell(), null, this.mWorkingSet);
            dialog.setTemplateConfiguration(sourceConfig);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                CheckConfigurationWorkingCopy newConfig = dialog.getCheckConfiguration();
                CheckConfigurationFactory.copyConfiguration((ICheckConfiguration)sourceConfig, (ICheckConfiguration)newConfig);
                this.mWorkingSet.addCheckConfiguration(newConfig);
                this.mViewer.setInput(this.mWorkingSet.getWorkingCopies());
                this.mViewer.refresh();
            }
        }
        catch (CheckstylePluginException ex) {
            CheckstyleUIPlugin.errorDialog(this.getShell(), ex, true);
        }
    }

    private void removeCheckConfig() {
        IStructuredSelection selection = (IStructuredSelection)this.mViewer.getSelection();
        CheckConfigurationWorkingCopy checkConfig = (CheckConfigurationWorkingCopy)selection.getFirstElement();
        if (checkConfig == null || !checkConfig.isEditable()) {
            return;
        }
        boolean confirm = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.CheckstylePreferencePage_titleDelete, (String)NLS.bind((String)Messages.CheckstylePreferencePage_msgDelete, (Object)checkConfig.getName()));
        if (confirm) {
            if (this.mWorkingSet.removeCheckConfiguration(checkConfig)) {
                this.mViewer.setInput(this.mWorkingSet.getWorkingCopies());
                this.mViewer.refresh();
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.CheckstylePreferencePage_titleCantDelete, (String)NLS.bind((String)Messages.CheckstylePreferencePage_msgCantDelete, (Object)checkConfig.getName()));
                return;
            }
        }
    }

    private void setDefaultCheckConfig() {
        IStructuredSelection selection = (IStructuredSelection)this.mViewer.getSelection();
        CheckConfigurationWorkingCopy checkConfig = (CheckConfigurationWorkingCopy)selection.getFirstElement();
        if (checkConfig == null) {
            return;
        }
        if (this.mWorkingSet instanceof GlobalCheckConfigurationWorkingSet) {
            ((GlobalCheckConfigurationWorkingSet)this.mWorkingSet).setDefaultCheckConfig(checkConfig);
        }
        this.mViewer.refresh();
    }

    private void exportCheckstyleCheckConfig() {
        IStructuredSelection selection = (IStructuredSelection)this.mViewer.getSelection();
        ICheckConfiguration config = (ICheckConfiguration)selection.getFirstElement();
        if (config == null) {
            return;
        }
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.CheckstylePreferencePage_titleExportConfig);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        try {
            CheckConfigurationFactory.exportConfiguration((File)file, (ICheckConfiguration)config);
        }
        catch (CheckstylePluginException ex) {
            CheckstyleUIPlugin.errorDialog(this.getShell(), Messages.msgErrorFailedExportConfig, ex, true);
        }
    }

    private class ConfigurationLabelProvider
    extends CheckConfigurationLabelProvider
    implements ITableLabelProvider,
    ITableComparableProvider,
    ITableSettingsProvider {
        private ConfigurationLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = element.toString();
            if (element instanceof ICheckConfiguration) {
                ICheckConfiguration cfg = (ICheckConfiguration)element;
                if (columnIndex == 0) {
                    result = cfg.getName();
                }
                if (columnIndex == 1) {
                    result = cfg.getLocation();
                }
                if (columnIndex == 2) {
                    result = cfg.getType().getName();
                }
                if (columnIndex == 3) {
                    result = "";
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            switch (columnIndex) {
                case 0: {
                    image = this.getImage(element);
                    break;
                }
                case 3: {
                    ICheckConfiguration cfg = (ICheckConfiguration)element;
                    if (!(CheckConfigurationWorkingSetEditor.this.mWorkingSet instanceof GlobalCheckConfigurationWorkingSet) || ((GlobalCheckConfigurationWorkingSet)CheckConfigurationWorkingSetEditor.this.mWorkingSet).getDefaultCheckConfig() != cfg) break;
                    image = CheckstyleUIPluginImages.TICK_ICON.getImage();
                    break;
                }
            }
            return image;
        }

        public Comparable<String> getComparableValue(Object element, int col) {
            return this.getColumnText(element, col);
        }

        @Override
        public IDialogSettings getTableSettings() {
            String concreteViewId = CheckConfigurationWorkingSetEditor.this.mWorkingSet.getClass().getName();
            IDialogSettings workbenchSettings = CheckstyleUIPlugin.getDefault().getDialogSettings();
            IDialogSettings settings = workbenchSettings.getSection(concreteViewId);
            if (settings == null) {
                settings = workbenchSettings.addNewSection(concreteViewId);
            }
            return settings;
        }
    }

    private class PageController
    implements SelectionListener,
    IDoubleClickListener,
    ISelectionChangedListener {
        private PageController() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (CheckConfigurationWorkingSetEditor.this.mAddButton == e.widget) {
                CheckConfigurationWorkingSetEditor.this.addCheckConfig();
            } else if (CheckConfigurationWorkingSetEditor.this.mEditButton == e.widget && CheckConfigurationWorkingSetEditor.this.mViewer.getSelection() instanceof IStructuredSelection) {
                CheckConfigurationWorkingSetEditor.this.editCheckConfig();
            } else if (CheckConfigurationWorkingSetEditor.this.mConfigureButton == e.widget && CheckConfigurationWorkingSetEditor.this.mViewer.getSelection() instanceof IStructuredSelection) {
                CheckConfigurationWorkingSetEditor.this.configureCheckConfig();
            } else if (CheckConfigurationWorkingSetEditor.this.mCopyButton == e.widget && CheckConfigurationWorkingSetEditor.this.mViewer.getSelection() instanceof IStructuredSelection) {
                CheckConfigurationWorkingSetEditor.this.copyCheckConfig();
            } else if (CheckConfigurationWorkingSetEditor.this.mRemoveButton == e.widget && CheckConfigurationWorkingSetEditor.this.mViewer.getSelection() instanceof IStructuredSelection) {
                CheckConfigurationWorkingSetEditor.this.removeCheckConfig();
            } else if (CheckConfigurationWorkingSetEditor.this.mDefaultButton == e.widget && CheckConfigurationWorkingSetEditor.this.mViewer.getSelection() instanceof IStructuredSelection) {
                CheckConfigurationWorkingSetEditor.this.setDefaultCheckConfig();
            } else if (CheckConfigurationWorkingSetEditor.this.mExportButton == e.widget && CheckConfigurationWorkingSetEditor.this.mViewer.getSelection() instanceof IStructuredSelection) {
                CheckConfigurationWorkingSetEditor.this.exportCheckstyleCheckConfig();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void doubleClick(DoubleClickEvent event) {
            CheckConfigurationWorkingSetEditor.this.configureCheckConfig();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSource() == CheckConfigurationWorkingSetEditor.this.mViewer && event.getSelection() instanceof IStructuredSelection) {
                boolean configSelected;
                CheckConfigurationWorkingCopy config = (CheckConfigurationWorkingCopy)((IStructuredSelection)event.getSelection()).getFirstElement();
                boolean bl = configSelected = config != null;
                if (configSelected) {
                    CheckConfigurationWorkingSetEditor.this.mConfigurationDescription.setText(config.getDescription() != null ? config.getDescription() : "");
                    if (CheckConfigurationWorkingSetEditor.this.mIsShowUsage) {
                        try {
                            CheckConfigurationWorkingSetEditor.this.mUsageView.setInput((Object)ProjectConfigurationFactory.getProjectsUsingConfig((ICheckConfiguration)config.getSourceCheckConfiguration()));
                        }
                        catch (CheckstylePluginException ex) {
                            CheckstyleLog.log((Throwable)ex);
                        }
                    }
                } else {
                    CheckConfigurationWorkingSetEditor.this.mConfigurationDescription.setText("");
                    if (CheckConfigurationWorkingSetEditor.this.mIsShowUsage) {
                        CheckConfigurationWorkingSetEditor.this.mUsageView.setInput(new ArrayList());
                    }
                }
                CheckConfigurationWorkingSetEditor.this.mEditButton.setEnabled(configSelected);
                CheckConfigurationWorkingSetEditor.this.mConfigureButton.setEnabled(configSelected);
                CheckConfigurationWorkingSetEditor.this.mCopyButton.setEnabled(configSelected);
                CheckConfigurationWorkingSetEditor.this.mRemoveButton.setEnabled(configSelected && config.isEditable());
                CheckConfigurationWorkingCopy defaultConfig = null;
                if (CheckConfigurationWorkingSetEditor.this.mWorkingSet instanceof GlobalCheckConfigurationWorkingSet) {
                    defaultConfig = ((GlobalCheckConfigurationWorkingSet)CheckConfigurationWorkingSetEditor.this.mWorkingSet).getDefaultCheckConfig();
                }
                CheckConfigurationWorkingSetEditor.this.mDefaultButton.setEnabled(configSelected && !config.equals((Object)defaultConfig));
                CheckConfigurationWorkingSetEditor.this.mExportButton.setEnabled(configSelected);
            }
        }
    }
}

