/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.configtypes;

import java.util.HashMap;
import java.util.Map;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.config.configtypes.ICheckConfigurationEditor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ConfigurationTypesUI {
    private static final String CONFIGTYPES_EXTENSION_POINT = "net.sf.eclipsecs.ui.configtypesui";
    private static final String ATTR_NAME = "configtypename";
    private static final String ATTR_CLASS = "editorclass";
    private static final String ATTR_ICON = "icon";
    private static final Map<String, Class<? extends ICheckConfigurationEditor>> CONFIGURATION_TYPE_EDITORS = new HashMap<String, Class<? extends ICheckConfigurationEditor>>();
    private static final Map<String, String> CONFIGURATION_TYPE_ICONS = new HashMap<String, String>();

    static {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = pluginRegistry.getConfigurationElementsFor(CONFIGTYPES_EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            try {
                String internalName = elements[i].getAttribute(ATTR_NAME);
                ICheckConfigurationEditor editor = (ICheckConfigurationEditor)elements[i].createExecutableExtension(ATTR_CLASS);
                String iconPath = elements[i].getAttribute(ATTR_ICON);
                CONFIGURATION_TYPE_EDITORS.put(internalName, editor.getClass());
                CONFIGURATION_TYPE_ICONS.put(internalName, iconPath);
            }
            catch (Exception ex) {
                CheckstyleLog.log((Throwable)ex);
            }
            ++i;
        }
    }

    private ConfigurationTypesUI() {
    }

    public static ICheckConfigurationEditor getNewEditor(IConfigurationType configType) throws CheckstylePluginException {
        Class<? extends ICheckConfigurationEditor> editorClass = CONFIGURATION_TYPE_EDITORS.get(configType.getInternalName());
        if (editorClass != null) {
            try {
                ICheckConfigurationEditor editor = editorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return editor;
            }
            catch (ClassCastException | ReflectiveOperationException ex) {
                CheckstylePluginException.rethrow((Throwable)ex);
            }
        }
        return null;
    }

    public static Image getConfigurationTypeImage(IConfigurationType configType) {
        String iconPath = CONFIGURATION_TYPE_ICONS.get(configType.getInternalName());
        if (iconPath != null) {
            ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
            Image image = imageRegistry.get(iconPath);
            if (image == null) {
                ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.sf.eclipsecs.ui", (String)iconPath);
                imageRegistry.put(iconPath, descriptor);
                image = imageRegistry.get(iconPath);
            }
            return image;
        }
        return null;
    }
}

