/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.configtypes;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ConfigurationWriter;
import net.sf.eclipsecs.core.config.GlobalCheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ICheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.projectconfig.LocalCheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.CheckConfigurationPropertiesDialog;
import net.sf.eclipsecs.ui.config.configtypes.ICheckConfigurationEditor;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectConfigurationEditor
implements ICheckConfigurationEditor {
    private CheckConfigurationWorkingCopy mWorkingCopy;
    private CheckConfigurationPropertiesDialog mCheckConfigDialog;
    private Text mConfigName;
    private Text mLocation;
    private Button mBtnBrowse;
    private Text mDescription;
    private Button mChkProtectConfig;

    @Override
    public void initialize(CheckConfigurationWorkingCopy checkConfiguration, CheckConfigurationPropertiesDialog dialog) {
        this.mWorkingCopy = checkConfiguration;
        this.mCheckConfigDialog = dialog;
    }

    @Override
    public Control createEditorControl(Composite parent, final Shell shell) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        contents.setLayout((Layout)layout);
        Label lblConfigName = new Label(contents, 0);
        lblConfigName.setText(Messages.CheckConfigurationPropertiesDialog_lblName);
        GridData gridData = new GridData();
        lblConfigName.setLayoutData((Object)gridData);
        this.mConfigName = new Text(contents, 18436);
        gridData = new GridData(768);
        this.mConfigName.setLayoutData((Object)gridData);
        this.mConfigName.setFocus();
        Label lblConfigLocation = new Label(contents, 0);
        lblConfigLocation.setText(Messages.CheckConfigurationPropertiesDialog_lblLocation);
        gridData = new GridData();
        lblConfigLocation.setLayoutData((Object)gridData);
        Composite locationComposite = new Composite(contents, 0);
        locationComposite.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        locationComposite.setLayout((Layout)layout);
        this.mLocation = new Text(locationComposite, 18436);
        gridData = new GridData(768);
        this.mLocation.setLayoutData((Object)gridData);
        this.mBtnBrowse = new Button(locationComposite, 8);
        this.mBtnBrowse.setText(Messages.ProjectConfigurationLocationEditor_btnBrowse);
        this.mBtnBrowse.setLayoutData((Object)new GridData());
        this.mBtnBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setHelpAvailable(false);
                dialog.setTitle(Messages.ProjectConfigurationLocationEditor_titleSelectConfigFile);
                dialog.setMessage(Messages.ProjectConfigurationLocationEditor_msgSelectConfigFile);
                dialog.setBlockOnOpen(true);
                dialog.setAllowMultiple(false);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection.length == 1 && selection[0] instanceof IFile) {
                            return new Status(0, "org.eclipse.ui", 4, new String(), null);
                        }
                        return new Status(4, "org.eclipse.ui", 4, new String(), null);
                    }
                });
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    IFile checkFile = (IFile)result[0];
                    ProjectConfigurationEditor.this.mLocation.setText(checkFile.getFullPath().toString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblDescription = new Label(contents, 0);
        lblDescription.setText(Messages.CheckConfigurationPropertiesDialog_lblDescription);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        lblDescription.setLayoutData((Object)gridData);
        this.mDescription = new Text(contents, 19010);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        gridData.heightHint = 100;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.mDescription.setLayoutData((Object)gridData);
        Group advancedGroup = new Group(contents, 0);
        advancedGroup.setText(Messages.RemoteConfigurationEditor_titleAdvancedOptions);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        advancedGroup.setLayoutData((Object)gridData);
        advancedGroup.setLayout((Layout)new GridLayout(2, false));
        this.mChkProtectConfig = new Button((Composite)advancedGroup, 32);
        this.mChkProtectConfig.setText(Messages.ProjectConfigurationEditor_chkProtectConfigFile);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mChkProtectConfig.setLayoutData((Object)gridData);
        if (this.mWorkingCopy.getName() != null) {
            this.mConfigName.setText(this.mWorkingCopy.getName());
        }
        if (this.mWorkingCopy.getLocation() != null) {
            this.mLocation.setText(this.mWorkingCopy.getLocation());
        }
        if (this.mWorkingCopy.getDescription() != null) {
            this.mDescription.setText(this.mWorkingCopy.getDescription());
        }
        this.mChkProtectConfig.setSelection(Boolean.parseBoolean((String)this.mWorkingCopy.getAdditionalData().get("protect-config-file")));
        return contents;
    }

    @Override
    public CheckConfigurationWorkingCopy getEditedWorkingCopy() throws CheckstylePluginException {
        this.mWorkingCopy.setName(this.mConfigName.getText());
        this.mWorkingCopy.setDescription(this.mDescription.getText());
        this.mWorkingCopy.getAdditionalData().put("protect-config-file", "" + this.mChkProtectConfig.getSelection());
        try {
            this.mWorkingCopy.setLocation(this.mLocation.getText());
        }
        catch (CheckstylePluginException ex) {
            String location = this.mLocation.getText();
            if (StringUtils.isBlank((CharSequence)location)) {
                throw ex;
            }
            ICheckConfigurationWorkingSet workingSet = this.mCheckConfigDialog.getCheckConfigurationWorkingSet();
            Path tmp = new Path(location);
            boolean isFirstPartProject = ResourcesPlugin.getWorkspace().getRoot().getProject(tmp.segment(0)).exists();
            if (!isFirstPartProject && workingSet instanceof LocalCheckConfigurationWorkingSet) {
                location = ((LocalCheckConfigurationWorkingSet)workingSet).getProject().getFullPath().append(location).toString();
                this.mLocation.setText(location);
            } else if (!isFirstPartProject && workingSet instanceof GlobalCheckConfigurationWorkingSet) {
                throw new CheckstylePluginException(NLS.bind((String)Messages.ProjectConfigurationEditor_msgNoProjectInWorkspace, (Object)tmp.segment(0)));
            }
            if (this.ensureFileExists(location)) {
                this.mWorkingCopy.setLocation(this.mLocation.getText());
            }
            throw ex;
        }
        return this.mWorkingCopy;
    }

    private boolean ensureFileExists(String location) throws CheckstylePluginException {
        IFile file = null;
        try {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(location));
        }
        catch (IllegalArgumentException ex) {
            CheckstylePluginException.rethrow((Throwable)ex);
        }
        if (!file.exists() && file.getLocation() != null) {
            boolean confirm = MessageDialog.openQuestion((Shell)this.mBtnBrowse.getShell(), (String)Messages.ExternalFileConfigurationEditor_titleFileDoesNotExist, (String)Messages.ExternalFileConfigurationEditor_msgFileDoesNotExist);
            if (confirm) {
                File trueFile = file.getLocation().toFile();
                if (trueFile.getParentFile() != null) {
                    trueFile.getParentFile().mkdirs();
                }
                try {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(trueFile));){
                        ConfigurationWriter.writeNewConfiguration((OutputStream)out, (ICheckConfiguration)this.mWorkingCopy);
                        file.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CoreException ex) {
                    CheckstylePluginException.rethrow((Throwable)ex);
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

