/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.widgets;

import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.config.widgets.IConfigPropertyWidget;
import net.sf.eclipsecs.ui.util.SWTUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class ConfigPropertyWidgetAbstractBase
implements IConfigPropertyWidget {
    private ConfigProperty mProp;
    private Control mValueWidget;
    private Composite mParent;

    protected ConfigPropertyWidgetAbstractBase(Composite parent, ConfigProperty prop) {
        this.mParent = parent;
        this.mProp = prop;
    }

    protected abstract Control getValueWidget(Composite var1);

    @Override
    public abstract String getValue();

    @Override
    public void initialize() {
        Label label = new Label(this.mParent, 0);
        label.setText(String.valueOf(this.mProp.getName()) + ":");
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
        this.mValueWidget = this.getValueWidget(this.mParent);
        gridData = (GridData)this.mValueWidget.getLayoutData();
        this.mValueWidget.setToolTipText(this.mProp.getMetaData().getDescription());
        Label lblPropertyInfo = new Label(this.mParent, 0);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        lblPropertyInfo.setLayoutData((Object)gridData);
        lblPropertyInfo.setImage(CheckstyleUIPluginImages.HELP_ICON.getImage());
        lblPropertyInfo.setToolTipText(this.mProp.getMetaData().getDescription());
        SWTUtil.addTooltipOnPressSupport((Control)lblPropertyInfo);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mValueWidget.setEnabled(enabled);
    }

    protected String getInitValue() {
        String initValue = null;
        if (this.mProp != null) {
            initValue = this.mProp.getValue();
        }
        if (initValue == null) {
            initValue = this.mProp.getMetaData().getOverrideDefault();
        }
        if (initValue == null) {
            initValue = this.mProp.getMetaData().getDefaultValue();
        }
        if (initValue == null) {
            initValue = "";
        }
        return initValue;
    }

    @Override
    public ConfigProperty getConfigProperty() {
        return this.mProp;
    }

    @Override
    public void validate() throws CheckstylePluginException {
    }
}

