/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.widgets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.config.meta.ConfigPropertyMetadata;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetAbstractBase;
import net.sf.eclipsecs.ui.util.regex.RegexCompletionProposalFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConfigPropertyWidgetRegex
extends ConfigPropertyWidgetAbstractBase {
    private final String mDefaultMessage = Messages.ConfigPropertyWidgetRegex_msgRegexTestString;
    private final Color mRedColor;
    private final Color mGreenColor;
    private Composite mContents;
    private Text mTextWidget;
    private Text mRegexTestWidget;
    private Color mTextBgColor;

    public ConfigPropertyWidgetRegex(Composite parent, ConfigProperty prop) {
        super(parent, prop);
        this.mGreenColor = new Color((Device)parent.getDisplay(), 219, 235, 204);
        this.mRedColor = new Color((Device)parent.getDisplay(), 255, 225, 225);
    }

    @Override
    protected Control getValueWidget(Composite parent) {
        if (this.mContents == null) {
            this.mContents = new Composite(parent, 0);
            this.mContents.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(2, true);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.mContents.setLayout((Layout)layout);
            this.mTextWidget = new Text(this.mContents, 2052);
            this.mTextWidget.setLayoutData((Object)new GridData(768));
            this.mTextWidget.addKeyListener((KeyListener)new RegexTestListener());
            this.mTextBgColor = this.mTextWidget.getBackground();
            RegexCompletionProposalFactory.createForText(this.mTextWidget);
            String initValue = this.getInitValue();
            if (initValue != null) {
                this.mTextWidget.setText(initValue);
            }
            this.mRegexTestWidget = new Text(this.mContents, 2052);
            this.mRegexTestWidget.setLayoutData((Object)new GridData(768));
            this.mRegexTestWidget.setMessage(this.mDefaultMessage);
            this.mRegexTestWidget.addKeyListener((KeyListener)new RegexTestListener());
        }
        return this.mTextWidget;
    }

    @Override
    public String getValue() {
        String result = this.mTextWidget.getText();
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public void restorePropertyDefault() {
        ConfigPropertyMetadata metadata = this.getConfigProperty().getMetaData();
        String defaultValue = metadata.getOverrideDefault() != null ? metadata.getOverrideDefault() : metadata.getDefaultValue();
        this.mTextWidget.setText(defaultValue != null ? defaultValue : "");
    }

    @Override
    public void validate() throws CheckstylePluginException {
        try {
            Pattern.compile(this.mTextWidget.getText());
        }
        catch (PatternSyntaxException ex) {
            CheckstylePluginException.rethrow((Throwable)ex, (String)ex.getLocalizedMessage());
        }
    }

    private void testRegex() {
        try {
            Pattern pattern = Pattern.compile(this.mTextWidget.getText());
            Matcher matcher = pattern.matcher(this.mRegexTestWidget.getText());
            if (matcher.find()) {
                this.mRegexTestWidget.setBackground(this.mGreenColor);
            } else {
                this.mRegexTestWidget.setBackground(this.mRedColor);
            }
            this.mTextWidget.setBackground(this.mTextBgColor);
        }
        catch (PatternSyntaxException ex) {
            this.mTextWidget.setBackground(this.mRedColor);
        }
    }

    private class RegexTestListener
    implements KeyListener {
        private RegexTestListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            ConfigPropertyWidgetRegex.this.testRegex();
        }
    }
}

