/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.widgets;

import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.config.meta.ConfigPropertyMetadata;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetAbstractBase;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ConfigPropertyWidgetString
extends ConfigPropertyWidgetAbstractBase {
    private static final String APOSTROPHE_PLAIN = "'";
    private static final String APOSTROPHE_ESCAPED = "''";
    private Text mTextWidget;

    public ConfigPropertyWidgetString(Composite parent, ConfigProperty prop) {
        super(parent, prop);
    }

    @Override
    protected Control getValueWidget(Composite parent) {
        if (this.mTextWidget == null) {
            this.mTextWidget = new Text(parent, 2052);
            this.mTextWidget.setLayoutData((Object)new GridData(768));
            String initValue = this.getInitValue();
            if (initValue != null) {
                this.mTextWidget.setText(this.unescape(initValue));
            }
        }
        return this.mTextWidget;
    }

    @Override
    public String getValue() {
        String result = this.mTextWidget.getText();
        if (result == null) {
            result = "";
        }
        return this.escape(result);
    }

    private String unescape(String text) {
        if ("message".equals(this.getConfigProperty().getName())) {
            return text.replace(APOSTROPHE_ESCAPED, APOSTROPHE_PLAIN);
        }
        return text;
    }

    private String escape(String text) {
        if ("message".equals(this.getConfigProperty().getName())) {
            return text.replace(APOSTROPHE_PLAIN, APOSTROPHE_ESCAPED);
        }
        return text;
    }

    @Override
    public void restorePropertyDefault() {
        ConfigPropertyMetadata metadata = this.getConfigProperty().getMetaData();
        String defaultValue = metadata.getOverrideDefault() != null ? metadata.getOverrideDefault() : metadata.getDefaultValue();
        this.mTextWidget.setText(defaultValue != null ? defaultValue : "");
    }
}

