/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.preferences;

import com.puppycrawl.tools.checkstyle.Main;
import java.util.Collection;
import net.sf.eclipsecs.core.CheckstylePluginPrefs;
import net.sf.eclipsecs.core.builder.CheckerFactory;
import net.sf.eclipsecs.core.builder.CheckstyleBuilder;
import net.sf.eclipsecs.core.config.CheckConfigurationFactory;
import net.sf.eclipsecs.core.config.ICheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.CheckstyleUIPluginPrefs;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.CheckConfigurationWorkingSetEditor;
import net.sf.eclipsecs.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class CheckstylePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final PageController mController = new PageController();
    private final ICheckConfigurationWorkingSet mWorkingSet;
    private Combo mRebuildIfNeeded;
    private Button mPurgeCacheButton;
    private Button mWarnBeforeLosingFilesets;
    private Button mIncludeRuleNamesButton;
    private Button mIncludeModuleIdButton;
    private Button mLimitCheckstyleMarkers;
    private Combo mLanguageIf;
    private Text mTxtMarkerLimit;
    private Button mBackgroundFullBuild;
    private CheckConfigurationWorkingSetEditor mWorkingSetEditor;
    private boolean mRebuildAll = false;

    public CheckstylePreferencePage() {
        this.setDescription(NLS.bind((String)Messages.CheckstylePreferencePage_version, (Object)this.getCheckstyleVersion()));
        this.setPreferenceStore(CheckstyleUIPlugin.getDefault().getPreferenceStore());
        this.mWorkingSet = CheckConfigurationFactory.newWorkingSet();
        CheckstylePreferencePage.initializeDefaults();
    }

    private String getCheckstyleVersion() {
        return Main.class.getPackage().getImplementationVersion();
    }

    private static void initializeDefaults() {
    }

    public Control createContents(Composite ancestor) {
        this.noDefaultAndApplyButton();
        Composite parentComposite = new Composite(ancestor, 0);
        FormLayout layout = new FormLayout();
        parentComposite.setLayout((Layout)layout);
        Composite generalComposite = this.createGeneralContents(parentComposite);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        generalComposite.setLayoutData((Object)formData);
        Composite configComposite = this.createCheckConfigContents(parentComposite);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment((Control)generalComposite, 3, 1024);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        configComposite.setLayoutData((Object)formData);
        return parentComposite;
    }

    private Composite createGeneralContents(Composite parent) {
        Group generalComposite = new Group(parent, 0);
        generalComposite.setText(Messages.CheckstylePreferencePage_lblGeneralSettings);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        generalComposite.setLayout((Layout)gridLayout);
        Composite langComposite = new Composite((Composite)generalComposite, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        langComposite.setLayout((Layout)gridLayout);
        langComposite.setLayoutData((Object)new GridData(768));
        Label lblLanguage = new Label(langComposite, 0);
        lblLanguage.setText(Messages.CheckstylePreferencePage_lblLocaleLanguage);
        this.mLanguageIf = new Combo(langComposite, 8);
        this.mLanguageIf.setItems(Messages.CheckstylePreferencePage_lblLocaleLanguages.split("[, ;]+"));
        String lang = CheckstylePluginPrefs.getString((String)"checkstyle_rule_language");
        int selectedLang = this.mLanguageIf.indexOf(lang == null || lang.isEmpty() ? "default" : lang);
        if (selectedLang != -1) {
            this.mLanguageIf.select(selectedLang);
        }
        Composite rebuildComposite = new Composite((Composite)generalComposite, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        rebuildComposite.setLayout((Layout)gridLayout);
        rebuildComposite.setLayoutData((Object)new GridData(768));
        Label lblRebuild = new Label(rebuildComposite, 0);
        lblRebuild.setText(Messages.CheckstylePreferencePage_lblRebuild);
        this.mRebuildIfNeeded = new Combo(rebuildComposite, 8);
        this.mRebuildIfNeeded.setItems(new String[]{"prompt", "always", "never"});
        this.mRebuildIfNeeded.select(this.mRebuildIfNeeded.indexOf(CheckstyleUIPluginPrefs.getString("ask.before.rebuild")));
        this.mPurgeCacheButton = new Button(rebuildComposite, 0x800000);
        this.mPurgeCacheButton.setImage(CheckstyleUIPluginImages.REFRESH_ICON.getImage());
        this.mPurgeCacheButton.setToolTipText(Messages.CheckstylePreferencePage_btnRefreshCheckerCache);
        this.mPurgeCacheButton.addSelectionListener((SelectionListener)this.mController);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 20;
        gridData.widthHint = 20;
        this.mPurgeCacheButton.setLayoutData((Object)gridData);
        this.mWarnBeforeLosingFilesets = new Button((Composite)generalComposite, 32);
        this.mWarnBeforeLosingFilesets.setText(Messages.CheckstylePreferencePage_lblWarnFilesets);
        this.mWarnBeforeLosingFilesets.setSelection(CheckstyleUIPluginPrefs.getBoolean("warn.before.losing.filesets"));
        Composite includeRuleNamesComposite = new Composite((Composite)generalComposite, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        includeRuleNamesComposite.setLayout((Layout)gridLayout);
        this.mIncludeRuleNamesButton = new Button(includeRuleNamesComposite, 32);
        this.mIncludeRuleNamesButton.setText(Messages.CheckstylePreferencePage_lblIncludeRulenames);
        this.mIncludeRuleNamesButton.setSelection(CheckstylePluginPrefs.getBoolean((String)"include.rule.names"));
        Label lblRebuildNote = new Label(includeRuleNamesComposite, 0);
        lblRebuildNote.setImage(CheckstyleUIPluginImages.HELP_ICON.getImage());
        lblRebuildNote.setToolTipText(Messages.CheckstylePreferencePage_txtSuggestRebuild);
        SWTUtil.addTooltipOnPressSupport((Control)lblRebuildNote);
        Composite includeModuleIdComposite = new Composite((Composite)generalComposite, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        includeModuleIdComposite.setLayout((Layout)gridLayout);
        this.mIncludeModuleIdButton = new Button(includeModuleIdComposite, 32);
        this.mIncludeModuleIdButton.setText(Messages.CheckstylePreferencePage_lblIncludeModuleIds);
        this.mIncludeModuleIdButton.setSelection(CheckstylePluginPrefs.getBoolean((String)"include.module.ids"));
        lblRebuildNote = new Label(includeModuleIdComposite, 0);
        lblRebuildNote.setImage(CheckstyleUIPluginImages.HELP_ICON.getImage());
        lblRebuildNote.setToolTipText(Messages.CheckstylePreferencePage_txtSuggestRebuild);
        SWTUtil.addTooltipOnPressSupport((Control)lblRebuildNote);
        Composite limitMarkersComposite = new Composite((Composite)generalComposite, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        limitMarkersComposite.setLayout((Layout)gridLayout);
        this.mLimitCheckstyleMarkers = new Button(limitMarkersComposite, 32);
        this.mLimitCheckstyleMarkers.setText(Messages.CheckstylePreferencePage_lblLimitMarker);
        this.mLimitCheckstyleMarkers.setSelection(CheckstylePluginPrefs.getBoolean((String)"limit.markers.per.resource"));
        this.mTxtMarkerLimit = new Text(limitMarkersComposite, 2052);
        this.mTxtMarkerLimit.setTextLimit(5);
        SWTUtil.addOnlyDigitInputSupport(this.mTxtMarkerLimit);
        this.mTxtMarkerLimit.setText(Integer.toString(CheckstylePluginPrefs.getInt((String)"marker.amount.limit")));
        gridData = new GridData();
        gridData.widthHint = 30;
        this.mTxtMarkerLimit.setLayoutData((Object)gridData);
        lblRebuildNote = new Label(limitMarkersComposite, 0);
        lblRebuildNote.setImage(CheckstyleUIPluginImages.HELP_ICON.getImage());
        lblRebuildNote.setToolTipText(Messages.CheckstylePreferencePage_txtSuggestRebuild);
        SWTUtil.addTooltipOnPressSupport((Control)lblRebuildNote);
        Composite backgroundFullBuildComposite = new Composite((Composite)generalComposite, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        backgroundFullBuildComposite.setLayout((Layout)gridLayout);
        this.mBackgroundFullBuild = new Button(backgroundFullBuildComposite, 32);
        this.mBackgroundFullBuild.setText(Messages.CheckstylePreferencePage_txtBackgroundFullBuild0);
        this.mBackgroundFullBuild.setSelection(CheckstylePluginPrefs.getBoolean((String)"background.full.build"));
        return generalComposite;
    }

    private Composite createCheckConfigContents(Composite parent) {
        Group configComposite = new Group(parent, 0);
        configComposite.setText(Messages.CheckstylePreferencePage_titleCheckConfigs);
        configComposite.setLayout((Layout)new FormLayout());
        this.mWorkingSetEditor = new CheckConfigurationWorkingSetEditor(this.mWorkingSet, true);
        Control editorControl = this.mWorkingSetEditor.createContents((Composite)configComposite);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 3);
        formData.top = new FormAttachment(0, 3);
        formData.right = new FormAttachment(100, -3);
        formData.bottom = new FormAttachment(100, -3);
        editorControl.setLayoutData((Object)formData);
        return configComposite;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        block6: {
            try {
                boolean rebuild;
                this.mWorkingSet.store();
                CheckstylePluginPrefs.setString((String)"checkstyle_rule_language", (String)this.mLanguageIf.getItem(this.mLanguageIf.getSelectionIndex()));
                CheckstyleUIPluginPrefs.setString("ask.before.rebuild", this.mRebuildIfNeeded.getItem(this.mRebuildIfNeeded.getSelectionIndex()));
                boolean warnFileSetsNow = this.mWarnBeforeLosingFilesets.getSelection();
                CheckstyleUIPluginPrefs.setBoolean("warn.before.losing.filesets", warnFileSetsNow);
                boolean includeRuleNamesNow = this.mIncludeRuleNamesButton.getSelection();
                boolean includeRuleNamesOriginal = CheckstylePluginPrefs.getBoolean((String)"include.rule.names");
                CheckstylePluginPrefs.setBoolean((String)"include.rule.names", (boolean)includeRuleNamesNow);
                boolean includeModuleIdNow = this.mIncludeModuleIdButton.getSelection();
                boolean includeModuleIdOriginal = CheckstylePluginPrefs.getBoolean((String)"include.module.ids");
                CheckstylePluginPrefs.setBoolean((String)"include.module.ids", (boolean)includeModuleIdNow);
                boolean limitMarkersNow = this.mLimitCheckstyleMarkers.getSelection();
                boolean limitMarkersOriginal = CheckstylePluginPrefs.getBoolean((String)"limit.markers.per.resource");
                CheckstylePluginPrefs.setBoolean((String)"limit.markers.per.resource", (boolean)limitMarkersNow);
                int markerLimitNow = Integer.parseInt(this.mTxtMarkerLimit.getText());
                int markerLimitOriginal = CheckstylePluginPrefs.getInt((String)"marker.amount.limit");
                CheckstylePluginPrefs.setInt((String)"marker.amount.limit", (int)markerLimitNow);
                boolean runInBackgroundNow = this.mBackgroundFullBuild.getSelection();
                CheckstylePluginPrefs.setBoolean((String)"background.full.build", (boolean)runInBackgroundNow);
                boolean needRebuildAllProjects = includeRuleNamesNow != includeRuleNamesOriginal || includeModuleIdNow != includeModuleIdOriginal || limitMarkersNow != limitMarkersOriginal || markerLimitNow != markerLimitOriginal || this.mRebuildAll;
                Collection projectsToBuild = this.mWorkingSet.getAffectedProjects();
                String promptRebuildPref = CheckstyleUIPluginPrefs.getString("ask.before.rebuild");
                boolean bl = rebuild = "always".equals(promptRebuildPref) && (needRebuildAllProjects || projectsToBuild.size() > 0);
                if ("prompt".equals(promptRebuildPref) && (needRebuildAllProjects || projectsToBuild.size() > 0)) {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getShell(), (String)Messages.CheckstylePreferencePage_titleRebuild, (String)Messages.CheckstylePreferencePage_msgRebuild, (String)Messages.CheckstylePreferencePage_nagRebuild, (boolean)false, (IPreferenceStore)CheckstyleUIPlugin.getDefault().getPreferenceStore(), (String)"ask.before.rebuild");
                    boolean bl2 = rebuild = dialog.getReturnCode() == 2;
                }
                if (!rebuild) break block6;
                try {
                    if (needRebuildAllProjects) {
                        CheckstyleBuilder.buildAllProjects();
                        break block6;
                    }
                    CheckstyleBuilder.buildProjects((Collection)projectsToBuild);
                }
                catch (CheckstylePluginException ex) {
                    CheckstyleUIPlugin.errorDialog(this.getShell(), NLS.bind((String)Messages.errorFailedRebuild, (Object)ex.getMessage()), ex, true);
                }
            }
            catch (CheckstylePluginException | BackingStoreException ex) {
                CheckstyleUIPlugin.errorDialog(this.getShell(), NLS.bind((String)Messages.errorFailedSavePreferences, (Object)ex.getLocalizedMessage()), ex, true);
            }
        }
        return true;
    }

    private class PageController
    extends SelectionAdapter {
        private PageController() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (CheckstylePreferencePage.this.mPurgeCacheButton == e.widget) {
                CheckerFactory.cleanup();
                CheckstylePreferencePage.this.mRebuildAll = true;
            }
        }
    }
}

