/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes;

import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.quickfixes.CheckstyleMarkerResolutionGenerator;
import net.sf.eclipsecs.ui.quickfixes.ICheckstyleMarkerResolution;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;

public class FixCheckstyleMarkersJob
extends UIJob {
    private IFile mFile;

    public FixCheckstyleMarkersJob(IFile file) {
        super(Messages.FixCheckstyleMarkersJob_title);
        this.mFile = file;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        try {
            CheckstyleMarkerResolutionGenerator generator = new CheckstyleMarkerResolutionGenerator();
            IMarker[] markers = this.mFile.findMarkers("net.sf.eclipsecs.core.CheckstyleMarker", true, 2);
            int i = 0;
            while (i < markers.length) {
                ICheckstyleMarkerResolution[] resolutions = (ICheckstyleMarkerResolution[])generator.getResolutions(markers[i]);
                if (resolutions.length > 0) {
                    resolutions[0].run(markers[i]);
                }
                ++i;
            }
        }
        catch (CoreException ex) {
            return new Status(4, "net.sf.eclipsecs.ui", 0, ex.getMessage(), (Throwable)ex);
        }
        return Status.OK_STATUS;
    }
}

