/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes.coding;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import net.sf.eclipsecs.ui.quickfixes.Messages;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class SimplifyBooleanReturnQuickfix
extends AbstractASTResolution {
    private static final Collection<Class<? extends Expression>> OMIT_PARANETHESES_CLASSES = Arrays.asList(BooleanLiteral.class, FieldAccess.class, MethodInvocation.class, QualifiedName.class, SimpleName.class, ParenthesizedExpression.class, SuperFieldAccess.class, SuperMethodInvocation.class, ThisExpression.class);

    @Override
    protected ASTVisitor handleGetCorrectingASTVisitor(IRegion lineInfo, final int markerStartOffset) {
        return new ASTVisitor(){

            public boolean visit(IfStatement node) {
                if (SimplifyBooleanReturnQuickfix.this.containsPosition((ASTNode)node, markerStartOffset)) {
                    ReturnStatement replacement;
                    boolean isNotCondition;
                    Boolean isThenStatementTrue = this.isReturnStatementTrue(node.getThenStatement());
                    if (isThenStatementTrue == null) {
                        return true;
                    }
                    Expression condition = this.removeNotFromCondition(node.getExpression());
                    boolean bl = isNotCondition = condition != node.getExpression();
                    if (isThenStatementTrue ^ isNotCondition) {
                        replacement = node.getAST().newReturnStatement();
                        replacement.setExpression((Expression)SimplifyBooleanReturnQuickfix.this.copy((ASTNode)condition));
                    } else {
                        AST ast = node.getAST();
                        replacement = ast.newReturnStatement();
                        PrefixExpression not = ast.newPrefixExpression();
                        not.setOperator(PrefixExpression.Operator.NOT);
                        if (this.omitParantheses(condition)) {
                            not.setOperand((Expression)SimplifyBooleanReturnQuickfix.this.copy((ASTNode)condition));
                        } else {
                            ParenthesizedExpression parentheses = ast.newParenthesizedExpression();
                            parentheses.setExpression((Expression)SimplifyBooleanReturnQuickfix.this.copy((ASTNode)condition));
                            not.setOperand((Expression)parentheses);
                        }
                        replacement.setExpression((Expression)not);
                    }
                    SimplifyBooleanReturnQuickfix.this.replace((ASTNode)node, (ASTNode)replacement);
                }
                return true;
            }

            private Boolean isReturnStatementTrue(Statement node) {
                List statements;
                if (node instanceof ReturnStatement) {
                    Expression expression = ((ReturnStatement)node).getExpression();
                    if (expression instanceof BooleanLiteral) {
                        return ((BooleanLiteral)expression).booleanValue();
                    }
                } else if (node instanceof Block && (statements = ((Block)node).statements()).size() > 0) {
                    return this.isReturnStatementTrue((Statement)statements.get(0));
                }
                return null;
            }

            private Expression removeNotFromCondition(Expression condition) {
                PrefixExpression prefix;
                if (condition instanceof PrefixExpression && PrefixExpression.Operator.NOT.equals((prefix = (PrefixExpression)condition).getOperator())) {
                    return prefix.getOperand();
                }
                return condition;
            }

            private boolean omitParantheses(Expression condition) {
                return OMIT_PARANETHESES_CLASSES.contains(condition.getClass());
            }
        };
    }

    public String getDescription() {
        return Messages.SimplifyBooleanReturnQuickfix_description;
    }

    public String getLabel() {
        return Messages.SimplifyBooleanReturnQuickfix_label;
    }

    @Override
    public Image getImage() {
        return CheckstyleUIPluginImages.CORRECTION_CHANGE.getImage();
    }
}

