/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.ui.internal;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.eclipse.m2e.jdt.ui.internal.MavenJdtUiPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.w3c.dom.Element;

public class AddDependencyJavaCompletionProposal
implements IJavaCompletionProposal {
    private ArtifactKey artifactKey;
    private IFile pomfile;

    public AddDependencyJavaCompletionProposal(ArtifactKey artifactKey, IFile pomfile) {
        this.artifactKey = artifactKey;
        this.pomfile = pomfile;
    }

    public void apply(IDocument javaDocument) {
        try {
            PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(this.pomfile, document -> {
                Element depsEl = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"dependencies"});
                PomHelper.addOrUpdateDependency((Element)depsEl, (String)this.artifactKey.groupId(), (String)this.artifactKey.artifactId(), (String)this.artifactKey.version(), null, (String)"compile", null);
            })});
        }
        catch (IOException ex) {
            MavenJdtUiPlugin.getDefault().getLog().error("Can't modify file " + this.pomfile, (Throwable)ex);
        }
        catch (CoreException ex) {
            MavenJdtUiPlugin.getDefault().getLog().log(ex.getStatus());
        }
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return "Add " + this.artifactKey.groupId() + ":" + this.artifactKey.artifactId() + ":" + this.artifactKey.version() + " as dependency";
    }

    public Image getImage() {
        return MavenJdtUiPlugin.getDefault().getImageRegistry().get("M2E_ICON");
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return 100;
    }
}

